/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.signal;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.core.SessionDescription;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.media.http.HttpClient;
import cn.rongcloud.rtc.media.http.Request;
import cn.rongcloud.rtc.proxy.message.messagebeans.ExchangeSDPDataResult;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.SubscribeLiveDataResult;
import cn.rongcloud.rtc.signal.IMSignalWrapper;
import cn.rongcloud.rtc.signal.IUpdateUdpObfuscationKeyListener;
import cn.rongcloud.rtc.sniffer.SnifferInfo;
import cn.rongcloud.rtc.sniffer.SnifferListener;
import cn.rongcloud.rtc.sniffer.SnifferManager;
import cn.rongcloud.rtc.utils.DeviceUtils;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.ILocalVideoStreamResource;
import cn.rongcloud.rtc.webrtc.IRemoteVideoStreamResource;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import io.rong.common.RLog;
import io.rong.imlib.IMLibRTCClient;
import io.rong.imlib.IRongCoreListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaSignalWrapper {
    private static final String TAG = "MediaSignalWrapper";
    private static String RONG_RTC_CONFIG_SERVER_URL = "MESERVER";
    private static final int LIVE_ROOM_TYPE = 2;
    private static final int RESPONSE_OK = 10000;
    private static String RONG_RTC_MEDIA_SERVER_URL = "";
    private static String EXCHANGE_SDP = "/exchange";
    private static String RTC_PROBE_START = "/rtc/media/echo/start";
    private static String RTC_PROBE_STOP = "/rtc/media/echo/stop";
    private static String EXIT = "/exit";
    private final String SUBSCRIBE_LIVE_SDP = "/broadcast/subscribe ";
    private final String EXIT_LIVE = "/broadcast/exit ";
    private static String CHANGERESOLUTION = "/server/resolution/change";
    private static final String FEATURE_SUPPORT_OBFUSCATION = "Udp-Obfuscation";
    private static final String HEAD_CLIENT_SESSION_ID = "Client-Session-Id";
    private static final String HEAD_REQUEST_ID = "Request-Id";
    private String clusterId;
    private String rtcToken;
    private String[] mOrderedMediaServer;
    private int mediaServerIndex;
    private static String mediaServer;
    private int maxStreamCount;
    private static final int ENGINE_RTC = 4;
    private boolean isSniffing;
    private long lastSnifferTime = 0L;
    private final int TWO_HOURS = 0x6DDD00;
    private static final String PREFIX_HTTPS = "https://";
    private IUpdateUdpObfuscationKeyListener mObfuscationKeyListener;
    private int retry = 0;
    private IMSignalWrapper mImSignal;
    private String mWisse;

    public MediaSignalWrapper(IMSignalWrapper imSignal, IUpdateUdpObfuscationKeyListener obfuscationKeyListener) {
        this.mObfuscationKeyListener = obfuscationKeyListener;
        this.mImSignal = imSignal;
    }

    public String getRtcToken() {
        return this.rtcToken;
    }

    public void setRtcToken(String token) {
        ReportUtil.libStatus(ReportUtil.TAG.GETRTCTOKEN, "desc", "MediaSignalWrapper.setRtcToken : " + token);
        this.rtcToken = token;
    }

    public void setMediaServerUrl(String url) {
        RONG_RTC_MEDIA_SERVER_URL = url;
        FinLog.d(TAG, "setMediaServerUrl as:: " + url);
    }

    private String getMediaServer() {
        if (!TextUtils.isEmpty((CharSequence)this.clusterId)) {
            return this.clusterId;
        }
        if (!TextUtils.isEmpty((CharSequence)RONG_RTC_MEDIA_SERVER_URL)) {
            return RONG_RTC_MEDIA_SERVER_URL;
        }
        if (this.mOrderedMediaServer == null || this.mOrderedMediaServer.length == 0) {
            FinLog.i(TAG, "getMediaServer() return null !");
            this.parseVoIPInfo();
            if (this.mOrderedMediaServer == null || this.mOrderedMediaServer.length == 0) {
                return null;
            }
        }
        String tmpMediaServer = "";
        for (int i = 0; i < this.mOrderedMediaServer.length; ++i) {
            if (TextUtils.isEmpty((CharSequence)this.mOrderedMediaServer[i])) continue;
            tmpMediaServer = this.mOrderedMediaServer[i];
            break;
        }
        FinLog.i(TAG, "Valid media server address :" + tmpMediaServer);
        return tmpMediaServer;
    }

    public void onIMConnectChanged(IRongCoreListener.ConnectionStatusListener.ConnectionStatus status) {
        boolean expired;
        RLog.i((String)TAG, (String)("onIMConnectChanged status " + status));
        if (this.mOrderedMediaServer == null && status == IRongCoreListener.ConnectionStatusListener.ConnectionStatus.CONNECTED) {
            this.parseVoIPInfo();
        }
        boolean bl = expired = System.currentTimeMillis() - this.lastSnifferTime >= 0x6DDD00L;
        if (expired && status == IRongCoreListener.ConnectionStatusListener.ConnectionStatus.CONNECTED && !RTCEngineImpl.getInstance().isInRoom() && !TextUtils.isEmpty((CharSequence)mediaServer)) {
            RLog.i((String)TAG, (String)"onIMConnectChanged sniff ");
            this.isSniffing = true;
            this.lastSnifferTime = System.currentTimeMillis();
            SnifferManager.getInstance().snifferServer(mediaServer, new SnifferListener(){

                @Override
                public void onSuccess(SnifferInfo snifferInfo) {
                    RLog.i((String)MediaSignalWrapper.TAG, (String)"sniff success() :");
                    MediaSignalWrapper.this.printOrderedServer("before sniff host add ", MediaSignalWrapper.this.mOrderedMediaServer);
                    try {
                        int sizeServers = MediaSignalWrapper.this.mOrderedMediaServer.length - MediaSignalWrapper.this.mediaServerIndex;
                        int sizeHost = snifferInfo.getOrderedHosts().size();
                        String[] temp = new String[sizeServers + sizeHost];
                        List<String> orderHosts = snifferInfo.getOrderedHosts();
                        String[] hosts = orderHosts.toArray(new String[0]);
                        System.arraycopy(hosts, 0, temp, 0, hosts.length);
                        System.arraycopy(MediaSignalWrapper.this.mOrderedMediaServer, MediaSignalWrapper.this.mediaServerIndex, temp, hosts.length, sizeServers);
                        MediaSignalWrapper.this.mediaServerIndex = hosts.length;
                        MediaSignalWrapper.access$002(MediaSignalWrapper.this, temp);
                    }
                    catch (Exception e) {
                        FinLog.e(MediaSignalWrapper.TAG, "handle sniffer result error: " + e.getMessage());
                    }
                    MediaSignalWrapper.this.printOrderedServer("after sniff host add ", MediaSignalWrapper.this.mOrderedMediaServer);
                    MediaSignalWrapper.this.isSniffing = false;
                }

                @Override
                public void onFailed() {
                    MediaSignalWrapper.this.isSniffing = false;
                    RLog.i((String)MediaSignalWrapper.TAG, (String)"sniff failed()");
                }
            });
        }
    }

    public boolean wisseIsEnable() {
        String voIPInfo = IMLibRTCClient.getInstance().getVoIPInfo();
        if (TextUtils.isEmpty((CharSequence)voIPInfo)) {
            return false;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(voIPInfo);
            JSONArray jsonArray = jsonObject.getJSONArray("callEngine");
            if (null == jsonArray) {
                return false;
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject rtcInfo = (JSONObject)jsonArray.get(i);
                if (rtcInfo.getInt("engineType") != 4) continue;
                if (rtcInfo.has("wwise")) {
                    return rtcInfo.optInt("wwise") == 1;
                }
                return false;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void parseVoIPInfo() {
        if (RONG_RTC_CONFIG_SERVER_URL.contains("http")) {
            mediaServer = RONG_RTC_CONFIG_SERVER_URL;
            FinLog.i(TAG, "Change mediaServer as configured: " + mediaServer);
        }
        if (!TextUtils.isEmpty((CharSequence)RONG_RTC_MEDIA_SERVER_URL)) {
            mediaServer = RONG_RTC_MEDIA_SERVER_URL;
            FinLog.i(TAG, "Change mediaServer as set: " + mediaServer);
        }
        if (!TextUtils.isEmpty((CharSequence)mediaServer)) {
            this.mOrderedMediaServer = new String[1];
            this.mOrderedMediaServer[0] = mediaServer;
            mediaServer = this.solveAddress();
            return;
        }
        try {
            String voIPInfo = IMLibRTCClient.getInstance().getVoIPInfo();
            if (TextUtils.isEmpty((CharSequence)voIPInfo)) {
                FinLog.e(TAG, "Can't get VoIP info: please check whether is VoIP service available!!");
                return;
            }
            ReportUtil.libStatus(ReportUtil.TAG.RTCNAVIDATA, "navi", voIPInfo);
            JSONObject jsonObject = new JSONObject(voIPInfo);
            JSONArray jsonArray = jsonObject.getJSONArray("callEngine");
            boolean isRTCEngine = false;
            for (int i = 0; i < jsonArray.length(); ++i) {
                int timeOut;
                JSONObject rtcInfo = (JSONObject)jsonArray.get(i);
                if (rtcInfo.getInt("engineType") != 4) continue;
                isRTCEngine = true;
                mediaServer = rtcInfo.getString("mediaServer");
                this.mOrderedMediaServer = new String[1];
                this.mOrderedMediaServer[0] = mediaServer;
                this.maxStreamCount = rtcInfo.getInt("maxStreamCount");
                JSONArray backupMediaServer = rtcInfo.optJSONArray("backupMediaServer");
                FinLog.i(TAG, "backupMediaServers::" + backupMediaServer);
                if (backupMediaServer != null) {
                    int j;
                    int length = backupMediaServer.length();
                    int start = this.mOrderedMediaServer.length;
                    String[] temp = new String[start + length];
                    for (j = 0; j < start; ++j) {
                        temp[j] = this.mOrderedMediaServer[j];
                    }
                    for (j = 0; j < length; ++j) {
                        temp[start + j] = backupMediaServer.optString(j);
                    }
                    this.mOrderedMediaServer = temp;
                }
                if (rtcInfo.has("timeOut") && (timeOut = rtcInfo.optInt("timeOut")) > 0) {
                    FinLog.d(TAG, "change timeOut as nav config : " + timeOut);
                    HttpClient.getDefault().CONNECT_TIME_OUT = timeOut * 1000;
                }
                mediaServer = this.solveAddress();
                this.printOrderedServer("nav parseVoIPInfo end ", this.mOrderedMediaServer);
            }
            if (!isRTCEngine) {
                FinLog.e(TAG, "Current selection is not RTC Engine. Please check navigation settings:: " + voIPInfo);
            }
        }
        catch (Exception e) {
            FinLog.e(TAG, "parseVoIPInfo error: " + e.getMessage());
        }
    }

    private void printOrderedServer(String info, String[] orderedServer) {
        if (orderedServer == null) {
            FinLog.i(TAG, "printOrderedServer orderedServer is null!");
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (String str : orderedServer) {
            builder.append(str);
            builder.append(", ");
        }
        String servers = builder.substring(0, builder.length() - 2);
        FinLog.i(TAG, info + "printOrderedServer: " + servers);
    }

    private String solveAddress() {
        if (null != this.mOrderedMediaServer) {
            for (int i = 0; i < this.mOrderedMediaServer.length; ++i) {
                String address = this.mOrderedMediaServer[i];
                if (address.contains("http")) continue;
                this.mOrderedMediaServer[i] = PREFIX_HTTPS + address;
            }
            FinLog.d(TAG, "mOrderedMediaServer = " + Arrays.toString(this.mOrderedMediaServer));
            return this.mOrderedMediaServer[0];
        }
        return mediaServer;
    }

    private int getBackupMediaServerIndex() {
        return 0;
    }

    public void reportWisseInfo(String roomId, int roomType, String sessionId, long startUTC, long endUTC) {
        if (null == this.mWisse) {
            return;
        }
        JSONObject body = new JSONObject();
        try {
            body.put("startUTC", startUTC);
            body.put("endUTC", endUTC);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.rtcToken)) {
            return;
        }
        Request.Builder builder = new Request.Builder().url(this.mWisse).method("POST").header("Token", this.getRtcToken()).header("User-Id", this.getUserId()).header(HEAD_REQUEST_ID, String.valueOf(System.currentTimeMillis())).header("App-Key", this.getAppKey()).header("Room-Id", roomId).header("App-Id", "").header("Session-Id", sessionId).header("RoomType", String.valueOf(roomType)).body(body.toString());
        Request request = builder.build();
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                Log.d((String)"jg", (String)("reportWisseInfo onResponse result is " + result));
            }

            @Override
            public void onFailure(int errorCode) {
                Log.d((String)"jg", (String)("reportWisseInfo onFailure errorCode is " + errorCode));
            }
        });
    }

    public void sendSDPOffer(String roomId, SessionDescription sdp, String clientSessionId, List<? extends IStreamResource> pubStreams, List<? extends IStreamResource> subStreams, RCRTCRoomType roomType, String autoMixJSONInfo, String role, IRCRTCResultDataCallback<ExchangeSDPDataResult> callback) {
        this.sendSDPOffer(roomId, sdp, this.getMediaServer(), false, clientSessionId, this.getBackupMediaServerIndex(), pubStreams, subStreams, roomType.getRoomType(), roomType.getMediaType(), autoMixJSONInfo, role, callback);
    }

    private void sendSDPOffer(final String roomId, final SessionDescription sdp, final String mediaServerAddress, final boolean isRetry, final String clientSessionId, final int backupIndex, final List<? extends IStreamResource> pubStreams, final List<? extends IStreamResource> subStreams, final int roomType, final int liveType, final String autoMixJSONInfo, final String role, final IRCRTCResultDataCallback<ExchangeSDPDataResult> callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeNotInRoom);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.rtcToken)) {
            ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, RTCErrorCode.RongRTCCodeRTCTokenIsNull.getValue(), RTCErrorCode.RongRTCCodeRTCTokenIsNull.getReason());
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeRTCTokenIsNull);
            }
            return;
        }
        JSONObject exchangeSDP = new JSONObject();
        try {
            JSONObject sdpJson = new JSONObject();
            JSONObject extendJson = this.getExtentInfo(pubStreams, role);
            JSONArray subscribeArray = this.parseSubscribeList(subStreams);
            ReportUtil.libTask(ReportUtil.TAG.SDPEXCHANGE, "roomId|mediaUrl|isRetry|subList|sdp", roomId, mediaServerAddress, isRetry, subscribeArray.toString(), sdp.toJsonString());
            sdpJson.put("type", (Object)sdp.type.name().toLowerCase());
            sdpJson.put("sdp", (Object)sdp.description);
            exchangeSDP.put("sdp", (Object)sdpJson);
            exchangeSDP.put("subscribeList", (Object)subscribeArray);
            exchangeSDP.put("resolutionInfo", (Object)this.getResolutionInfo(pubStreams));
            exchangeSDP.put("token", (Object)this.rtcToken);
            exchangeSDP.put("extend", (Object)extendJson);
            if (!(roomType != RCRTCRoomType.LIVE_AUDIO.getRoomType() && roomType != RCRTCRoomType.LIVE_AUDIO_VIDEO.getRoomType() || TextUtils.isEmpty((CharSequence)autoMixJSONInfo))) {
                JSONArray jsonArray = new JSONArray(autoMixJSONInfo);
                exchangeSDP.put("pushOtherRooms", (Object)jsonArray);
                FinLog.i(TAG, "sendSDPOffer autoMixJSON: " + autoMixJSONInfo);
                ReportUtil.libStatus(ReportUtil.TAG.SDPEXCHANGE, "pushOtherRooms", autoMixJSONInfo);
            }
            FinLog.i(TAG, "sendSDPOffer extend: " + extendJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
            ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, RTCErrorCode.RongRTCCodeParameterError.getValue(), e.getMessage());
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        Request request = this.getRequest(this.rtcToken, roomId, roomType, clientSessionId, EXCHANGE_SDP, mediaServerAddress, exchangeSDP);
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                block21: {
                    try {
                        JSONObject jsonObject = new JSONObject(result);
                        int reposeCode = jsonObject.getInt("resultCode");
                        if (reposeCode == 10000) {
                            String wisseUrl;
                            MediaSignalWrapper.this.changeMediaServer2ClusterId(mediaServerAddress, jsonObject);
                            JSONObject sdpObject = jsonObject.getJSONObject("sdp");
                            String sdpInfo = sdpObject.getString("sdp");
                            String type = sdpObject.getString("type");
                            SessionDescription.Type descriptionType = SessionDescription.Type.ANSWER;
                            if (!TextUtils.isEmpty((CharSequence)type)) {
                                if (type.equals("answer")) {
                                    descriptionType = SessionDescription.Type.ANSWER;
                                } else if (type.equals("offer")) {
                                    descriptionType = SessionDescription.Type.OFFER;
                                }
                            }
                            SessionDescription remoteDescription = new SessionDescription(descriptionType, sdpInfo);
                            JSONArray jsonArray = jsonObject.getJSONArray("publishList");
                            FinLog.d(MediaSignalWrapper.TAG, "sendSDPOffer success res = \n" + jsonArray.toString());
                            JSONObject urlsObject = null;
                            String urls = "";
                            if (jsonObject.has("urls") && (urlsObject = jsonObject.optJSONObject("urls")) != null) {
                                urls = urlsObject.toString();
                            }
                            MediaSignalWrapper.this.parseUDPObfuscation(jsonObject);
                            List publishMediaInfoList = MediaSignalWrapper.this.parsePublishList(jsonArray);
                            MediaSignalWrapper.this.setDefaultStreamContent(publishMediaInfoList);
                            List mcuPubMediaInfoList = null;
                            if (jsonObject.has("mcuPublishList")) {
                                jsonArray = jsonObject.getJSONArray("mcuPublishList");
                                mcuPubMediaInfoList = MediaSignalWrapper.this.parsePublishList(jsonArray);
                            }
                            if (!TextUtils.isEmpty((CharSequence)(wisseUrl = jsonObject.optString("wise_billing_url")))) {
                                MediaSignalWrapper.this.mWisse = MediaSignalWrapper.PREFIX_HTTPS + wisseUrl;
                            }
                            ReportUtil.libRes(ReportUtil.TAG.SDPEXCHANGE, "roomId|liveInfo|clusterId|code|pubList|sdp", roomId, urls, MediaSignalWrapper.this.clusterId, 0, jsonArray.toString(), remoteDescription.toJsonString());
                            if (callback != null) {
                                callback.onSuccess(new ExchangeSDPDataResult(remoteDescription, publishMediaInfoList, urlsObject, mcuPubMediaInfoList));
                            }
                        } else {
                            RTCErrorCode errorCode = RTCErrorCode.valueOf(reposeCode);
                            if (errorCode == RTCErrorCode.RongRTCCodeTokenExpired || errorCode == RTCErrorCode.RongRTCCodeTokenNotInRoom) {
                                ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, errorCode.getValue(), result);
                                if (MediaSignalWrapper.this.retry > 0) {
                                    MediaSignalWrapper.this.retry = 0;
                                    if (callback != null) {
                                        callback.onFailed(errorCode);
                                    }
                                } else {
                                    MediaSignalWrapper.this.retry++;
                                    AsyncResult<String> tokenRes = MediaSignalWrapper.this.mImSignal.syncGetRTCToken(roomId, roomType, liveType);
                                    if (tokenRes.isFailed()) {
                                        MediaSignalWrapper.this.retry = 0;
                                        if (callback != null) {
                                            callback.onFailed(tokenRes.getErrorCode());
                                        }
                                    }
                                    MediaSignalWrapper.this.rtcToken = tokenRes.getData();
                                    MediaSignalWrapper.this.sendSDPOffer(roomId, sdp, mediaServerAddress, isRetry, clientSessionId, backupIndex, pubStreams, subStreams, roomType, liveType, autoMixJSONInfo, role, callback);
                                }
                            } else {
                                ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, errorCode.getValue(), result);
                                if (callback != null) {
                                    callback.onFailed(errorCode);
                                }
                            }
                        }
                    }
                    catch (JSONException e) {
                        ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, RTCErrorCode.JsonParseError.getValue(), "Exception: " + e.getMessage() + " , result: " + result);
                        MediaSignalWrapper.this.retrySendSDPOffer(roomId, sdp, clientSessionId, backupIndex, RTCErrorCode.JsonParseError, pubStreams, subStreams, roomType, liveType, autoMixJSONInfo, role, callback);
                    }
                    catch (Exception e) {
                        ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, RTCErrorCode.UnknownError.getValue(), "Exception: " + e.getMessage() + " , result: " + result);
                        if (callback == null) break block21;
                        callback.onFailed(RTCErrorCode.UnknownError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, 2, "roomId|code|desc", roomId, errorCode, "sendSDPOffer onFailure");
                MediaSignalWrapper.this.retrySendSDPOffer(roomId, sdp, clientSessionId, backupIndex, RTCErrorCode.valueOf(errorCode), pubStreams, subStreams, roomType, liveType, autoMixJSONInfo, role, callback);
            }
        });
    }

    private void setDefaultStreamContent(List<MediaResourceInfo> mediaResourceInfoList) {
        RCMicOutputStreamImpl micOutputStream = (RCMicOutputStreamImpl)RTCEngineImpl.getInstance().getDefaultAudioStream();
        if (null != micOutputStream && null != mediaResourceInfoList) {
            for (MediaResourceInfo info : mediaResourceInfoList) {
                if (!info.getTag().equals(micOutputStream.getTag()) || RCRTCMediaType.AUDIO != info.getType()) continue;
                micOutputStream.setSsrc(info.getSsrc());
            }
        }
    }

    public void onResolutionChanged(String roomId, RCRTCRoomType roomType, String clientSessionId, List<? extends IStreamResource> pubStreamRes, final IRCRTCResultCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.RESOLUTIONCHANGED, "roomId|roomType|resolutionInfo", new Object[]{roomId, roomType, this.getResolutionInfo(pubStreamRes).toString()});
        this.changeResolution(roomId, roomType.getRoomType(), clientSessionId, this.getMediaServer(), pubStreamRes, -1, new IRCRTCResultDataCallback<String>(){

            @Override
            public void onSuccess(String data) {
                block6: {
                    try {
                        JSONObject jsonObject = new JSONObject(data);
                        int reposeCode = jsonObject.getInt("resultCode");
                        if (reposeCode == 10000) {
                            FinLog.v(MediaSignalWrapper.TAG, "onResolutionChanged() success");
                            ReportUtil.libRes(ReportUtil.TAG.RESOLUTIONCHANGED, "code", 0);
                            if (callback != null) {
                                callback.onSuccess();
                            }
                        } else {
                            RTCErrorCode errorCode = RTCErrorCode.valueOf(reposeCode);
                            ReportUtil.libError(ReportUtil.TAG.RESOLUTIONCHANGED, "code|msg", errorCode.getValue(), data);
                            if (callback != null) {
                                callback.onFailed(errorCode);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ReportUtil.libError(ReportUtil.TAG.RESOLUTIONCHANGED, "code|msg", RTCErrorCode.RongRTCCodeParameterError.getReason(), data);
                        if (callback == null) break block6;
                        callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                    }
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.RESOLUTIONCHANGED, "code|msg", errorCode.getValue(), errorCode.getReason());
                if (callback != null) {
                    callback.onFailed(errorCode);
                }
            }
        });
    }

    private void changeResolution(final String roomId, final int roomType, final String clientSessionId, String mediaServerAddress, final List<? extends IStreamResource> pubStreamRes, final int backupIndex, final IRCRTCResultDataCallback<String> callback) {
        JSONObject resolutionInfo = new JSONObject();
        try {
            resolutionInfo.put("resolutionInfo", (Object)this.getResolutionInfo(pubStreamRes));
            FinLog.i(TAG, "changeResolution:: " + resolutionInfo.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        String token = this.getRtcToken();
        Request request = this.getRequest(token, roomId, roomType, clientSessionId, CHANGERESOLUTION, mediaServerAddress, resolutionInfo, false);
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (MediaSignalWrapper.this.needRetry(backupIndex)) {
                    MediaSignalWrapper.this.changeResolution(roomId, roomType, clientSessionId, MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1], pubStreamRes, backupIndex + 1, callback);
                } else if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    public void quit(String roomId, RCRTCRoomType roomType, String clientSessionId, IRCRTCResultCallback callback) {
        this.quit(roomId, roomType.getRoomType(), clientSessionId, this.getMediaServer(), callback);
    }

    private void quit(final String roomId, int roomType, String clientSessionId, String mediaServer, final IRCRTCResultCallback callback) {
        JSONObject quitInfo;
        String token;
        block3: {
            if (TextUtils.isEmpty((CharSequence)roomId)) {
                callback.onFailed(RTCErrorCode.RongRTCCodeNotInRoom);
                return;
            }
            ReportUtil.libTask(ReportUtil.TAG.LEAVEROOM, "roomId|mediaUrl ", roomId, mediaServer);
            token = this.getRtcToken();
            this.setRtcToken(null);
            quitInfo = new JSONObject();
            try {
                quitInfo.put("token", (Object)token);
            }
            catch (JSONException e) {
                e.printStackTrace();
                ReportUtil.libError(ReportUtil.TAG.LEAVEROOM, RTCErrorCode.RongRTCCodeParameterError, "roomId", roomId);
                if (callback == null) break block3;
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
        }
        this.request(token, roomId, roomType, clientSessionId, EXIT, mediaServer, quitInfo, false, this.getBackupMediaServerIndex(), new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                block6: {
                    try {
                        JSONObject jsonObject = new JSONObject(result);
                        int resultCode = jsonObject.getInt("resultCode");
                        if (resultCode == 10000) {
                            ReportUtil.libRes(ReportUtil.TAG.LEAVEROOM, roomId);
                            if (callback != null) {
                                callback.onSuccess();
                            }
                            break block6;
                        }
                        ReportUtil.libError(ReportUtil.TAG.LEAVEROOM, "roomId|code|desc", roomId, resultCode, "Server Result: " + result);
                        if (callback == null) break block6;
                        int errorCode = -1;
                        try {
                            errorCode = resultCode;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        callback.onFailed(RTCErrorCode.valueOf(errorCode));
                    }
                    catch (JSONException e) {
                        ReportUtil.libError(ReportUtil.TAG.LEAVEROOM, "roomId|code|desc", roomId, RTCErrorCode.JsonParseError.getValue(), "JSONException:" + e.getMessage());
                        if (callback == null) break block6;
                        callback.onFailed(RTCErrorCode.JsonParseError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.LEAVEROOM, "roomId|code|desc", roomId, errorCode, "Http Request Failed");
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    private void request(final String rtcToken, final String roomId, final int roomType, final String clientSessionId, final String command, String mediaServerAddress, final JSONObject body, final boolean isAudience, final int backupIndex, final HttpClient.ResultCallback callback) {
        Request request = this.getRequest(rtcToken, roomId, roomType, clientSessionId, command, mediaServerAddress, body, isAudience);
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                if (callback != null) {
                    callback.onResponse(result);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (MediaSignalWrapper.this.needRetry(backupIndex)) {
                    MediaSignalWrapper.this.request(rtcToken, roomId, roomType, clientSessionId, command, MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1], body, isAudience, backupIndex + 1, callback);
                    return;
                }
                if (callback != null) {
                    callback.onFailure(errorCode);
                }
            }
        });
    }

    private List<MediaResourceInfo> parsePublishList(JSONArray jsonArray) {
        ArrayList<MediaResourceInfo> publishMediaInfoList = null;
        if (jsonArray != null) {
            publishMediaInfoList = new ArrayList<MediaResourceInfo>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                try {
                    JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                    MediaResourceInfo publishMediaInfo = new MediaResourceInfo(jsonObject, this.getUserId());
                    publishMediaInfoList.add(publishMediaInfo);
                    continue;
                }
                catch (JSONException e) {
                    FinLog.v(TAG, "e.getMessage() = " + e.getMessage());
                }
            }
            FinLog.v(TAG, "parsePublishList size: " + publishMediaInfoList.size());
        }
        return publishMediaInfoList;
    }

    private JSONObject getResolutionInfo(List<? extends IStreamResource> pubStreamRes) {
        JSONObject result = new JSONObject();
        if (RongRTCUtils.isEmpty(pubStreamRes)) {
            return result;
        }
        try {
            for (IStreamResource iStreamResource : pubStreamRes) {
                if (!(iStreamResource instanceof ILocalVideoStreamResource)) continue;
                ILocalVideoStreamResource videoResource = (ILocalVideoStreamResource)iStreamResource;
                JSONObject info = new JSONObject();
                JSONArray array = new JSONArray();
                info.put("simulcast", videoResource.getStreamType().getValue());
                info.put("resolution", (Object)(videoResource.getWidth() + "X" + videoResource.getHeight()));
                array.put((Object)info);
                result.put(iStreamResource.getStreamId(), (Object)array);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    private JSONObject getExtentInfo(List<? extends IStreamResource> pubStreamRes, String role) {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        try {
            if (RongRTCUtils.isEmpty(pubStreamRes)) {
                return jsonObject;
            }
            int audioScenario = RCRTCParamsType.AudioScenario.DEFAULT.getValue();
            for (IStreamResource iStreamResource : pubStreamRes) {
                if (iStreamResource instanceof RCMicOutputStreamImpl) {
                    audioScenario = ((RCMicOutputStreamImpl)iStreamResource).getAudioScenario().getValue();
                }
                if (!(iStreamResource instanceof ILocalVideoStreamResource)) continue;
                ILocalVideoStreamResource outputStream = (ILocalVideoStreamResource)iStreamResource;
                JSONObject normalStream = new JSONObject();
                normalStream.put("trackId", (Object)outputStream.getStreamId());
                normalStream.put("simulcast", outputStream.getStreamType().getValue());
                normalStream.put("resolution", (Object)(outputStream.getWidth() + "X" + outputStream.getHeight()));
                jsonArray.put((Object)normalStream);
            }
            jsonObject.put("resolutionInfo", (Object)jsonArray);
            jsonObject.put("audioScenario", audioScenario);
            if (!TextUtils.isEmpty((CharSequence)role)) {
                jsonObject.put("role", (Object)role);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    private JSONArray parseSubscribeList(List<? extends IStreamResource> subStreamRes) {
        JSONArray jsonArray = new JSONArray();
        for (IStreamResource iStreamResource : subStreamRes) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("uri", (Object)iStreamResource.getUri());
                if (iStreamResource instanceof IRemoteVideoStreamResource) {
                    jsonObject.put("simulcast", ((IRemoteVideoStreamResource)((Object)iStreamResource)).getStreamType().getValue());
                }
                jsonArray.put((Object)jsonObject);
            }
            catch (JSONException e) {}
        }
        FinLog.i(TAG, "subscribe stream total:" + subStreamRes.size() + " / subscribed:" + jsonArray.length());
        Log.i((String)TAG, (String)("parseSubscribeList () SubscribeList : " + jsonArray.toString()));
        return jsonArray;
    }

    private void retrySendSDPOffer(String roomId, SessionDescription sdp, String clientSessionId, int backupIndex, RTCErrorCode errorCode, List<? extends IStreamResource> pubStreams, List<? extends IStreamResource> subStreams, int roomType, int liveType, String autoMixJSONInfo, String role, IRCRTCResultDataCallback<ExchangeSDPDataResult> callback) {
        if (this.needRetry(backupIndex)) {
            String backupUrl = this.mOrderedMediaServer[backupIndex + 1];
            FinLog.i(TAG, "sendSDPOffer retry with mOrderedMediaServer: " + backupUrl);
            this.sendSDPOffer(roomId, sdp, backupUrl, true, clientSessionId, backupIndex + 1, pubStreams, subStreams, roomType, liveType, autoMixJSONInfo, role, callback);
        } else if (callback != null) {
            callback.onFailed(errorCode);
        }
    }

    private boolean needRetry(int backupIndex) {
        return this.mOrderedMediaServer != null && this.mOrderedMediaServer.length > backupIndex + 1;
    }

    private void parseUDPObfuscation(JSONObject jsonObject) {
        try {
            if (this.mObfuscationKeyListener != null && jsonObject != null && jsonObject.has("udpObfuscationKey")) {
                String udpObfuscationKey = jsonObject.getString("udpObfuscationKey");
                this.mObfuscationKeyListener.onUpdate(udpObfuscationKey);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private Request getRequest(String rtcToken, String roomId, int roomType, String clientSessionId, String command, String mediaServerAddress, JSONObject body) {
        return this.getRequest(rtcToken, roomId, roomType, clientSessionId, command, mediaServerAddress, body, false);
    }

    private Request getRequest(String rtcToken, String roomId, int roomType, String clientSessionId, String command, String mediaServerAddress, JSONObject body, boolean isAudience) {
        return this.getRequestBuilder(rtcToken, roomId, roomType, clientSessionId, command, mediaServerAddress, isAudience).body(body.toString()).build();
    }

    private Request.Builder getRequestBuilder(String rtcToken, String roomId, int roomType, String clientSessionId, String command, String mediaServerAddress, boolean isAudience) {
        return new Request.Builder().url(mediaServerAddress + command).method("POST").header("clientVersion", RCRTCEngine.getVersion()).header("App-Key", this.getAppKey()).header("Token", rtcToken).header("RoomId", roomId).header("clientType", "Android|" + DeviceUtils.getBuildModel() + "|" + Build.VERSION.RELEASE).header("RoomType", String.valueOf(roomType)).header("UserId", this.getUserId()).header(FEATURE_SUPPORT_OBFUSCATION, "XOR").header(HEAD_CLIENT_SESSION_ID, clientSessionId).header(HEAD_REQUEST_ID, String.valueOf(System.currentTimeMillis()));
    }

    public int getMaxStreamCount() {
        if (this.maxStreamCount == 0) {
            return 30;
        }
        return this.maxStreamCount;
    }

    public void subscribeLive(SessionDescription sessionDescription, String mcuUrl, RCRTCAVStreamType avStreamType, List<? extends IStreamResource> allSubStreams, String serverSessionId, String clientSessionId, IRCRTCResultDataCallback<SubscribeLiveDataResult> callback) {
        this.subscribeLive(sessionDescription, mcuUrl, avStreamType, allSubStreams, false, this.getMediaServer(), serverSessionId, clientSessionId, -1, callback);
    }

    private String getUserId() {
        String userId = this.mImSignal.getUserId();
        FinLog.i(TAG, "userId = " + userId);
        return userId;
    }

    private void subscribeLive(final SessionDescription sessionDescription, final String mcuUrl, final RCRTCAVStreamType avStreamType, final List<? extends IStreamResource> allSubStreams, boolean isRetry, final String mediaServerAddress, final String serverSessionId, final String clientSessionId, final int backupIndex, final IRCRTCResultDataCallback<SubscribeLiveDataResult> callback) {
        ReportUtil.libTask(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|mediaUrl|userId|isRetry|sdp", mcuUrl, mediaServerAddress, this.getUserId(), isRetry, sessionDescription.toJsonString());
        JSONObject exchangeSDP = new JSONObject();
        try {
            JSONObject sdpJson = new JSONObject();
            sdpJson.put("type", (Object)sessionDescription.type.name().toLowerCase());
            sdpJson.put("sdp", (Object)sessionDescription.description);
            exchangeSDP.put("sdp", (Object)sdpJson);
            if (!TextUtils.isEmpty((CharSequence)mcuUrl)) {
                exchangeSDP.put("liveUrl", (Object)mcuUrl);
                if (avStreamType.getSimulcast() != -1) {
                    exchangeSDP.put("simulcast", avStreamType.getSimulcast());
                }
                exchangeSDP.put("mediaType", avStreamType.getMediaType());
            }
            if (!RongRTCUtils.isEmpty(allSubStreams)) {
                exchangeSDP.put("subscribeList", (Object)this.parseSubscribeList(allSubStreams));
            }
            FinLog.i(TAG, "subscribeLive sdpInfo: " + exchangeSDP + "   \nuserId:" + this.getUserId());
        }
        catch (JSONException e) {
            e.printStackTrace();
            ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|code|desc", mcuUrl, RTCErrorCode.RongRTCCodeParameterError.getValue(), "JSONException: " + e.getMessage());
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        String token = this.getRtcToken();
        Request.Builder builder = this.getRequestBuilder(token, this.getUserId(), 2, clientSessionId, "/broadcast/subscribe ", mediaServerAddress, true);
        if (!TextUtils.isEmpty((CharSequence)serverSessionId)) {
            builder.header("Session-Id", serverSessionId);
        }
        Request request = builder.body(exchangeSDP.toString()).build();
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                block17: {
                    try {
                        JSONObject jsonObject = new JSONObject(result);
                        int reposeCode = jsonObject.getInt("resultCode");
                        if (reposeCode == 10000) {
                            FinLog.d(MediaSignalWrapper.TAG, "subscribeLive SDP success");
                            MediaSignalWrapper.this.changeMediaServer2ClusterId(mediaServerAddress, jsonObject);
                            List mcuPubMediaInfoList = null;
                            if (jsonObject.has("mcuPublishList")) {
                                mcuPubMediaInfoList = MediaSignalWrapper.this.parsePublishList(jsonObject.optJSONArray("mcuPublishList"));
                            } else {
                                FinLog.e(MediaSignalWrapper.TAG, "subscribeLive: not have <mcuPublishList> Field");
                            }
                            String roomId = jsonObject.optString("roomId");
                            FinLog.d(MediaSignalWrapper.TAG, "subscribeLive: roomId =" + roomId);
                            if (TextUtils.isEmpty((CharSequence)roomId)) {
                                FinLog.e(MediaSignalWrapper.TAG, "subscribeLive response roomId is Null");
                            }
                            JSONObject sdpObject = jsonObject.getJSONObject("sdp");
                            String sdpInfo = sdpObject.getString("sdp");
                            String type = sdpObject.getString("type");
                            SessionDescription.Type descriptionType = SessionDescription.Type.ANSWER;
                            if (!TextUtils.isEmpty((CharSequence)type)) {
                                if (type.equals("answer")) {
                                    descriptionType = SessionDescription.Type.ANSWER;
                                } else if (type.equals("offer")) {
                                    descriptionType = SessionDescription.Type.OFFER;
                                }
                            }
                            SessionDescription remoteDescription = new SessionDescription(descriptionType, sdpInfo);
                            ReportUtil.libRes(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "code|roomId|sdp", 0, roomId, remoteDescription.toJsonString());
                            MediaSignalWrapper.this.parseUDPObfuscation(jsonObject);
                            if (callback != null) {
                                callback.onSuccess(new SubscribeLiveDataResult(remoteDescription, mcuPubMediaInfoList, roomId));
                            }
                        } else {
                            RTCErrorCode errorCode = RTCErrorCode.valueOf(reposeCode);
                            ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|code|desc", mcuUrl, errorCode.getValue(), result);
                            if (callback != null) {
                                callback.onFailed(errorCode);
                            }
                        }
                    }
                    catch (JSONException e) {
                        ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|code|desc", mcuUrl, RTCErrorCode.JsonParseError.getValue(), "JSONException: " + e.getMessage() + " , result: " + result);
                        if (MediaSignalWrapper.this.needRetry(backupIndex)) {
                            FinLog.i(MediaSignalWrapper.TAG, "subscribeLive retry with mOrderedMediaServer: " + MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1]);
                            MediaSignalWrapper.this.subscribeLive(sessionDescription, mcuUrl, avStreamType, allSubStreams, true, MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1], serverSessionId, clientSessionId, backupIndex + 1, callback);
                        } else if (callback != null) {
                            callback.onFailed(RTCErrorCode.JsonParseError);
                        }
                    }
                    catch (Exception e) {
                        ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|code|desc", mcuUrl, RTCErrorCode.UnknownError.getValue(), "Exception: " + e.getMessage() + " , result: " + result);
                        if (callback == null) break block17;
                        callback.onFailed(RTCErrorCode.UnknownError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, 2, "liveUrl|code|desc", mcuUrl, errorCode, "HttpRequest Failed");
                if (MediaSignalWrapper.this.needRetry(backupIndex)) {
                    FinLog.i(MediaSignalWrapper.TAG, "subscribeLive retry with mOrderedMediaServer: " + MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1]);
                    MediaSignalWrapper.this.subscribeLive(sessionDescription, mcuUrl, avStreamType, allSubStreams, true, MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1], serverSessionId, clientSessionId, backupIndex + 1, callback);
                } else if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    private void changeMediaServer2ClusterId(String mediaServerAddress, JSONObject jsonObject) {
        String tmpClusterId = jsonObject.optString("clusterId");
        if (!TextUtils.isEmpty((CharSequence)tmpClusterId)) {
            if (!TextUtils.isEmpty((CharSequence)this.clusterId)) {
                if (this.clusterId.contains(tmpClusterId)) {
                    return;
                }
                this.mOrderedMediaServer[0] = tmpClusterId;
            } else {
                String[] newMediaServers = new String[this.mOrderedMediaServer.length + 1];
                System.arraycopy(this.mOrderedMediaServer, 0, newMediaServers, 1, newMediaServers.length - 1);
                newMediaServers[0] = tmpClusterId;
                this.mOrderedMediaServer = newMediaServers;
            }
            this.clusterId = this.solveAddress();
            FinLog.i(TAG, "Change media server to clusterId: " + this.clusterId);
        } else {
            this.clusterId = mediaServerAddress;
            FinLog.i(TAG, "Change media server to clusterId: " + this.clusterId);
        }
    }

    public void quitLive(final String liveUrl, int roomType, String serverSessionId, String clientSessionId, final IRCRTCResultCallback callback) {
        JSONObject quitInfo;
        String mediaServer;
        block4: {
            mediaServer = this.getMediaServer();
            ReportUtil.libTask(ReportUtil.TAG.LEAVELIVE, "liveUrl|mediaUrl|userId", liveUrl, mediaServer, this.getUserId());
            quitInfo = new JSONObject();
            try {
                if (!TextUtils.isEmpty((CharSequence)liveUrl)) {
                    quitInfo.put("liveUrl", (Object)liveUrl);
                }
            }
            catch (JSONException e) {
                ReportUtil.libError(ReportUtil.TAG.LEAVELIVE, "liveUrl|code|desc", liveUrl, RTCErrorCode.RongRTCCodeParameterError.getValue(), e.getMessage());
                e.printStackTrace();
                if (callback == null) break block4;
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
        }
        String token = this.getRtcToken();
        Request.Builder builder = this.getRequestBuilder(token, this.getUserId(), roomType, clientSessionId, "/broadcast/exit ", mediaServer, true);
        if (!TextUtils.isEmpty((CharSequence)serverSessionId)) {
            builder.header("Session-Id", serverSessionId);
        }
        Request request = builder.body(quitInfo.toString()).build();
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                block6: {
                    try {
                        JSONObject jsonObject = new JSONObject(result);
                        int resultCode = jsonObject.getInt("resultCode");
                        if (resultCode == 10000) {
                            ReportUtil.libRes(ReportUtil.TAG.LEAVELIVE, "code", 0);
                            if (callback != null) {
                                callback.onSuccess();
                            }
                            break block6;
                        }
                        ReportUtil.libError(ReportUtil.TAG.LEAVELIVE, "code|mediaUrl|liveUrl|desc", resultCode, mediaServer, liveUrl, result);
                        if (callback == null) break block6;
                        int errorCode = -1;
                        try {
                            errorCode = resultCode;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        callback.onFailed(RTCErrorCode.valueOf(errorCode));
                    }
                    catch (JSONException e) {
                        ReportUtil.libError(ReportUtil.TAG.LEAVELIVE, "liveUrl|code|desc", liveUrl, RTCErrorCode.JsonParseError.getValue(), "JSONException: " + e.getMessage() + " , result: " + result);
                        if (callback == null) break block6;
                        callback.onFailed(RTCErrorCode.JsonParseError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.LEAVELIVE, "code|mediaUrl|liveUrl|desc", errorCode, mediaServer, liveUrl, "HttpRequest Failed");
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    public void setMCUConfig(final String serverUrl, final String roomId, String sessionId, String configJson, final IRCRTCResultDataCallback<String> callBack) {
        ReportUtil.libTask(ReportUtil.TAG.MCUCONFIGREQUEST, "serverUrl|roomId|sessionId|configJson", serverUrl, roomId, sessionId, configJson);
        Request request = new Request.Builder().url(serverUrl + "/server/mcu/config").method("POST").addHeader("RoomId", roomId).addHeader("UserId", this.getUserId()).addHeader("AppKey", this.getAppKey()).addHeader("SessionId", sessionId).addHeader("Token", this.getRtcToken()).body(configJson).build();
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String s) {
                block7: {
                    ReportUtil.libRes(ReportUtil.TAG.MCU_CONFIG, "roomId|response", roomId, s);
                    try {
                        JSONObject jsonObject = new JSONObject(s);
                        int resultCode = jsonObject.getInt("resultCode");
                        if (resultCode == 10000) {
                            ReportUtil.libRes(ReportUtil.TAG.MCUCONFIGREQUEST, "code", 0);
                            if (callBack != null) {
                                callBack.onSuccess(s);
                            }
                            break block7;
                        }
                        int errorCode = -1;
                        try {
                            errorCode = resultCode;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        RTCErrorCode rtcErrorCode = RTCErrorCode.valueOf(errorCode);
                        ReportUtil.libError(ReportUtil.TAG.MCUCONFIGREQUEST, "serverUrl|code|msg", serverUrl, errorCode, s);
                        if (callBack != null) {
                            callBack.onFailed(rtcErrorCode);
                        }
                    }
                    catch (JSONException e) {
                        ReportUtil.libError(ReportUtil.TAG.MCUCONFIGREQUEST, "serverUrl|code|msg", serverUrl, RTCErrorCode.JsonParseError.getValue(), s);
                        if (callBack == null) break block7;
                        callBack.onFailed(RTCErrorCode.JsonParseError);
                    }
                }
            }

            @Override
            public void onFailure(int i) {
                RTCErrorCode errorCode = RTCErrorCode.valueOf(i);
                ReportUtil.libError(ReportUtil.TAG.MCUCONFIGREQUEST, "serverUrl|code|msg", serverUrl, errorCode.getValue(), errorCode.getReason());
                if (callBack != null) {
                    callBack.onFailed(errorCode);
                }
            }
        });
    }

    public void enableInnerCDN(String serverUrl, final String roomId, String sessionId, String configJson, final IRCRTCResultDataCallback<String> callBack) {
        ReportUtil.libTask(ReportUtil.TAG.MCU_CONFIG, "roomId|configJson", roomId, configJson);
        Request request = new Request.Builder().url(serverUrl + "/server/mcu/config").method("POST").addHeader("RoomId", roomId).addHeader("UserId", this.getUserId()).addHeader("AppKey", this.getAppKey()).addHeader("SessionId", sessionId).addHeader("Token", this.getRtcToken()).body(configJson).build();
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String data) {
                block11: {
                    ReportUtil.libRes(ReportUtil.TAG.MCU_CONFIG, "roomId|response", roomId, data);
                    if (!TextUtils.isEmpty((CharSequence)data)) {
                        try {
                            JSONObject jsonObject = new JSONObject(data);
                            int resultCode = -1;
                            if (jsonObject.has("resultCode")) {
                                resultCode = jsonObject.optInt("resultCode");
                            }
                            if (resultCode == 10000) {
                                if (jsonObject.has("pull_url")) {
                                    String pullUrl = jsonObject.optString("pull_url");
                                    JSONObject objPullUrl = new JSONObject(pullUrl);
                                    if (objPullUrl.has("url")) {
                                        callBack.onSuccess(pullUrl);
                                    } else {
                                        ReportUtil.libError(ReportUtil.TAG.MCU_CONFIG, "code|desc", new Object[]{RTCErrorCode.RongRTCCodeParameterError, "rtmpUrl is empty"});
                                        callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                                    }
                                } else {
                                    ReportUtil.libError(ReportUtil.TAG.MCU_CONFIG, "code|desc", new Object[]{RTCErrorCode.RongRTCCodeParameterError, "pullUrl is empty"});
                                    callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                                }
                                break block11;
                            }
                            String reason = null;
                            if (jsonObject.has("reason")) {
                                reason = jsonObject.optString("reason");
                            }
                            RTCErrorCode errorCode = RTCErrorCode.valueOf(resultCode);
                            ReportUtil.libError(ReportUtil.TAG.MCU_CONFIG, "code|desc", new Object[]{errorCode, reason});
                            callBack.onFailed(errorCode);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            ReportUtil.libError(ReportUtil.TAG.MCU_CONFIG, "code|desc", new Object[]{RTCErrorCode.JsonParseError, e.getMessage()});
                            callBack.onFailed(RTCErrorCode.JsonParseError);
                        }
                    } else {
                        ReportUtil.libError(ReportUtil.TAG.MCU_CONFIG, "code|desc", new Object[]{RTCErrorCode.RongRTCCodeParameterError, "data is empty"});
                        callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.MCU_CONFIG, "code|desc", errorCode, "HttpRequest Failed");
                if (callBack != null) {
                    callBack.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    private String getAppKey() {
        return RTCEngineImpl.getInstance().getAppKey();
    }

    public void reset() {
        mediaServer = null;
        this.clusterId = null;
    }

    public void getCDNUri(String cdnServer, final String roomId, String sessionId, int width, int height, int fps, final IRCRTCResultDataCallback<Object[]> callBack) {
        ReportUtil.libTask(ReportUtil.TAG.GET_CDN_URI, "roomId|cdnServer|userId|w|h|fps", roomId, cdnServer, this.getUserId(), width, height, fps);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cdnServer);
        if (width != 0 && height != 0) {
            stringBuilder.append("?");
            stringBuilder.append("w=").append(width);
            stringBuilder.append("&");
            stringBuilder.append("h=").append(height);
            stringBuilder.append("&");
            stringBuilder.append("fps=").append(fps);
        }
        Request request = new Request.Builder().url(stringBuilder.toString()).method("GET").addHeader("RoomId", roomId).addHeader("UserId", this.getUserId()).addHeader("AppKey", this.getAppKey()).addHeader("SessionId", sessionId).addHeader("Token", this.getRtcToken()).addHeader(HEAD_REQUEST_ID, String.valueOf(System.currentTimeMillis())).build();
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String s) {
                ReportUtil.libRes(ReportUtil.TAG.GET_CDN_URI, "roomId|response", roomId, s);
                try {
                    JSONObject jsonObject = new JSONObject(s);
                    int code = -1;
                    if (jsonObject.has("resultCode")) {
                        code = jsonObject.optInt("resultCode");
                    }
                    if (code == 10000) {
                        String cdnUrl = null;
                        JSONObject urlObj = null;
                        int width = 0;
                        int height = 0;
                        int FPS = 0;
                        if (jsonObject.has("data") && (urlObj = new JSONObject(jsonObject.optString("data"))).has("pull_url")) {
                            cdnUrl = urlObj.optString("pull_url");
                        }
                        if (urlObj == null || TextUtils.isEmpty(cdnUrl)) {
                            ReportUtil.libError(ReportUtil.TAG.GET_CDN_URI, "roomId|desc", roomId, "pull_url is empty");
                            callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                            return;
                        }
                        if (urlObj.has("w")) {
                            width = urlObj.optInt("w");
                        }
                        if (urlObj.has("h")) {
                            height = urlObj.optInt("h");
                        }
                        if (urlObj.has("fps")) {
                            FPS = urlObj.optInt("fps");
                        }
                        Object[] objects = new Object[]{cdnUrl, width, height, FPS};
                        callBack.onSuccess(objects);
                    } else {
                        String error = "";
                        if (jsonObject.has("message")) {
                            error = jsonObject.optString("message");
                        }
                        ReportUtil.libError(ReportUtil.TAG.GET_CDN_URI, "roomId|desc", roomId, error);
                        callBack.onFailed(RTCErrorCode.valueOf(code));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    ReportUtil.libError(ReportUtil.TAG.GET_CDN_URI, "roomId|desc", roomId, e.getMessage());
                    callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                }
            }

            @Override
            public void onFailure(int i) {
                ReportUtil.libError(ReportUtil.TAG.GET_CDN_URI, "roomId|code", roomId, i);
                callBack.onFailed(RTCErrorCode.valueOf(i));
            }
        });
    }

    public void sendModifyResource(String roomId, String sessionId, String configJson, final IRCRTCResultCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.MCU_CLIENT_ACTION, "roomId|configJson", roomId, configJson);
        Request request = new Request.Builder().url(this.getMediaServer() + "/rtc/media/clientaction").method("POST").addHeader("RoomId", roomId).addHeader("UserId", this.getUserId()).addHeader("AppKey", this.getAppKey()).addHeader("SessionId", sessionId).addHeader("Token", this.getRtcToken()).header(HEAD_REQUEST_ID, String.valueOf(System.currentTimeMillis())).body(configJson).build();
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String data) {
                block6: {
                    if (!TextUtils.isEmpty((CharSequence)data)) {
                        try {
                            JSONObject jsonObject = new JSONObject(data);
                            int resultCode = -1;
                            if (jsonObject.has("resultCode")) {
                                resultCode = jsonObject.optInt("resultCode");
                            }
                            if (resultCode == 10000) {
                                callBack.onSuccess();
                                break block6;
                            }
                            RTCErrorCode errorCode = RTCErrorCode.valueOf(resultCode);
                            ReportUtil.libError(ReportUtil.TAG.MCU_CLIENT_ACTION, "code|desc", new Object[]{errorCode, data});
                            callBack.onFailed(errorCode);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            ReportUtil.libError(ReportUtil.TAG.MCU_CLIENT_ACTION, "code|desc", new Object[]{RTCErrorCode.JsonParseError, e.getMessage()});
                            callBack.onFailed(RTCErrorCode.JsonParseError);
                        }
                    } else {
                        ReportUtil.libError(ReportUtil.TAG.MCU_CLIENT_ACTION, "code|desc", new Object[]{RTCErrorCode.RongRTCCodeParameterError, "data is empty"});
                        callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.MCU_CLIENT_ACTION, "code|desc", errorCode, "HttpRequest Failed");
                if (callBack != null) {
                    callBack.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    public void startRTCProbe(SessionDescription sdp, String token, String clientSessionId, final IRCRTCResultDataCallback<SessionDescription> callback) {
        ReportUtil.libTask(ReportUtil.TAG.STARTPROBEMEDIASERVER, "token|sdp", token, sdp.toJsonString());
        JSONObject exchangeSDP = new JSONObject();
        try {
            JSONObject sdpJson = new JSONObject();
            sdpJson.put("type", (Object)sdp.type.name().toLowerCase());
            sdpJson.put("sdp", (Object)sdp.description);
            exchangeSDP.put("sdp", (Object)sdpJson);
            exchangeSDP.put("token", (Object)token);
        }
        catch (JSONException e) {
            e.printStackTrace();
            ReportUtil.libError(ReportUtil.TAG.STARTPROBEMEDIASERVER, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), e.getMessage());
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        Request request = this.getRequest(token, this.getUserId(), 0, clientSessionId, RTC_PROBE_START, this.getMediaServer(), exchangeSDP);
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                block12: {
                    if (!TextUtils.isEmpty((CharSequence)result)) {
                        try {
                            JSONObject jsonObject = new JSONObject(result);
                            int resultCode = jsonObject.optInt("resultCode");
                            if (resultCode != 10000) {
                                ReportUtil.libError(ReportUtil.TAG.STARTPROBEMEDIASERVER, "code|desc", resultCode, "Response resultCode: " + result);
                                if (callback != null) {
                                    callback.onFailed(RTCErrorCode.valueOf(resultCode));
                                }
                                return;
                            }
                            ReportUtil.libRes(ReportUtil.TAG.STARTPROBEMEDIASERVER, "response", result);
                            JSONObject sdpObject = jsonObject.getJSONObject("sdp");
                            String sdpInfo = sdpObject.getString("sdp");
                            String type = sdpObject.getString("type");
                            SessionDescription.Type descriptionType = SessionDescription.Type.ANSWER;
                            if (!TextUtils.isEmpty((CharSequence)type)) {
                                if (type.equals("answer")) {
                                    descriptionType = SessionDescription.Type.ANSWER;
                                } else if (type.equals("offer")) {
                                    descriptionType = SessionDescription.Type.OFFER;
                                }
                            }
                            SessionDescription remoteDescription = new SessionDescription(descriptionType, sdpInfo);
                            if (callback != null) {
                                callback.onSuccess(remoteDescription);
                            }
                            break block12;
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            ReportUtil.libError(ReportUtil.TAG.STARTPROBEMEDIASERVER, "code|desc", new Object[]{RTCErrorCode.JsonParseError, "Parse Response Failed: " + result});
                            if (callback != null) {
                                callback.onFailed(RTCErrorCode.JsonParseError);
                            }
                            break block12;
                        }
                    }
                    ReportUtil.libError(ReportUtil.TAG.STARTPROBEMEDIASERVER, "code|desc", new Object[]{RTCErrorCode.UnknownError, "Response is Empty: " + result});
                    if (callback != null) {
                        callback.onFailed(RTCErrorCode.UnknownError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.STARTPROBEMEDIASERVER, "code|desc", errorCode, "HttpRequest Failed");
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    public void stopRTCProbe(String token, String clientSessionId, final IRCRTCResultCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.STOPPROBEMEDIASERVER, "token", token);
        Request request = this.getRequest(token, this.getUserId(), 0, clientSessionId, RTC_PROBE_STOP, this.getMediaServer(), new JSONObject());
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                block5: {
                    ReportUtil.libRes(ReportUtil.TAG.STOPPROBEMEDIASERVER, "response", result);
                    JSONObject jsonObject = null;
                    try {
                        jsonObject = new JSONObject(result);
                        int resultCode = jsonObject.optInt("resultCode");
                        if (resultCode != 10000) {
                            if (callback != null) {
                                callback.onFailed(RTCErrorCode.valueOf(resultCode));
                            }
                            return;
                        }
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        if (callback == null) break block5;
                        callback.onFailed(RTCErrorCode.JsonParseError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.STOPPROBEMEDIASERVER, "code|desc", errorCode, "HttpRequest Failed");
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    static /* synthetic */ String[] access$002(MediaSignalWrapper x0, String[] x1) {
        x0.mOrderedMediaServer = x1;
        return x1;
    }
}

