/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.filter;

import android.opengl.GLES20;
import com.daasuu.mp4compose.filter.GlFilter;

public class GlPosterizeFilter
extends GlFilter {
    private static final String POSTERIZE_FRAGMENT_SHADER = "precision mediump float; varying vec2 vTextureCoord;\n\nuniform lowp sampler2D sTexture;\nuniform highp float colorLevels;\n\nvoid main()\n{\n   highp vec4 textureColor = texture2D(sTexture, vTextureCoord);\n   \n   gl_FragColor = floor((textureColor * colorLevels) + vec4(0.5)) / colorLevels;\n}";
    private int colorLevels = 10;

    public GlPosterizeFilter() {
        super("attribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\ngl_Position = aPosition;\nvTextureCoord = aTextureCoord.xy;\n}\n", POSTERIZE_FRAGMENT_SHADER);
    }

    public void setColorLevels(int colorLevels) {
        this.colorLevels = colorLevels < 0 ? 0 : (colorLevels > 256 ? 256 : colorLevels);
    }

    @Override
    public void onDraw() {
        GLES20.glUniform1f((int)this.getHandle("colorLevels"), (float)this.colorLevels);
    }
}

