/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import androidx.annotation.NonNull;
import com.taobao.weex.adapter.ClassLoaderAdapter;
import com.taobao.weex.adapter.IDrawableLoader;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.adapter.IWXJsFileLoaderAdapter;
import com.taobao.weex.adapter.IWXJscProcessManager;
import com.taobao.weex.adapter.IWXSoLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.adapter.URIAdapter;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapterFactory;
import com.taobao.weex.performance.IApmGenerator;
import java.util.LinkedList;
import java.util.List;

public class InitConfig {
    private IWXHttpAdapter httpAdapter;
    private IDrawableLoader drawableLoader;
    private IWXImgLoaderAdapter imgAdapter;
    private IWXUserTrackAdapter utAdapter;
    private IWXStorageAdapter storageAdapter;
    private IWXSoLoaderAdapter soLoader;
    private URIAdapter mURIAdapter;
    private IWebSocketAdapterFactory webSocketAdapterFactory;
    private IWXJSExceptionAdapter mJSExceptionAdapter;
    private String framework;
    private ClassLoaderAdapter classLoaderAdapter;
    private IApmGenerator apmGenerater;
    private IWXJsFileLoaderAdapter jsFileLoaderAdapter;
    private IWXJscProcessManager jscProcessManager;
    private List<String> nativeLibraryList;

    public IWXHttpAdapter getHttpAdapter() {
        return this.httpAdapter;
    }

    public IWXImgLoaderAdapter getImgAdapter() {
        return this.imgAdapter;
    }

    public IDrawableLoader getDrawableLoader() {
        return this.drawableLoader;
    }

    public IWXUserTrackAdapter getUtAdapter() {
        return this.utAdapter;
    }

    public IWXSoLoaderAdapter getIWXSoLoaderAdapter() {
        return this.soLoader;
    }

    public String getFramework() {
        return this.framework;
    }

    public IWXStorageAdapter getStorageAdapter() {
        return this.storageAdapter;
    }

    public URIAdapter getURIAdapter() {
        return this.mURIAdapter;
    }

    public IWebSocketAdapterFactory getWebSocketAdapterFactory() {
        return this.webSocketAdapterFactory;
    }

    public ClassLoaderAdapter getClassLoaderAdapter() {
        return this.classLoaderAdapter;
    }

    public IApmGenerator getApmGenerater() {
        return this.apmGenerater;
    }

    public IWXJsFileLoaderAdapter getJsFileLoaderAdapter() {
        return this.jsFileLoaderAdapter;
    }

    public InitConfig setClassLoaderAdapter(ClassLoaderAdapter classLoaderAdapter) {
        this.classLoaderAdapter = classLoaderAdapter;
        return this;
    }

    public IWXJSExceptionAdapter getJSExceptionAdapter() {
        return this.mJSExceptionAdapter;
    }

    public IWXJscProcessManager getJscProcessManager() {
        return this.jscProcessManager;
    }

    @NonNull
    Iterable<String> getNativeLibraryList() {
        if (this.nativeLibraryList == null) {
            this.nativeLibraryList = new LinkedList<String>();
        }
        return this.nativeLibraryList;
    }

    private InitConfig() {
    }

    public static class Builder {
        IWXHttpAdapter httpAdapter;
        IWXImgLoaderAdapter imgAdapter;
        IDrawableLoader drawableLoader;
        IWXUserTrackAdapter utAdapter;
        IWXStorageAdapter storageAdapter;
        IWXSoLoaderAdapter soLoader;
        URIAdapter mURIAdapter;
        IWXJSExceptionAdapter mJSExceptionAdapter;
        String framework;
        IWebSocketAdapterFactory webSocketAdapterFactory;
        ClassLoaderAdapter classLoaderAdapter;
        IApmGenerator apmGenerater;
        private IWXJsFileLoaderAdapter jsFileLoaderAdapter;
        private List<String> nativeLibraryList = new LinkedList<String>();
        IWXJscProcessManager jscProcessManager;

        public IWXJscProcessManager getJscProcessManager() {
            return this.jscProcessManager;
        }

        public Builder setJscProcessManager(IWXJscProcessManager jscProcessManager) {
            this.jscProcessManager = jscProcessManager;
            return this;
        }

        public Builder setHttpAdapter(IWXHttpAdapter httpAdapter) {
            this.httpAdapter = httpAdapter;
            return this;
        }

        public Builder setImgAdapter(IWXImgLoaderAdapter imgAdapter) {
            this.imgAdapter = imgAdapter;
            return this;
        }

        public Builder setDrawableLoader(IDrawableLoader drawableLoader) {
            this.drawableLoader = drawableLoader;
            return this;
        }

        public Builder setUtAdapter(IWXUserTrackAdapter utAdapter) {
            this.utAdapter = utAdapter;
            return this;
        }

        public Builder setStorageAdapter(IWXStorageAdapter storageAdapter) {
            this.storageAdapter = storageAdapter;
            return this;
        }

        public Builder setURIAdapter(URIAdapter URIAdapter2) {
            this.mURIAdapter = URIAdapter2;
            return this;
        }

        public Builder setJSExceptionAdapter(IWXJSExceptionAdapter JSExceptionAdapter2) {
            this.mJSExceptionAdapter = JSExceptionAdapter2;
            return this;
        }

        public Builder setSoLoader(IWXSoLoaderAdapter loader) {
            this.soLoader = loader;
            return this;
        }

        public Builder setFramework(String framework) {
            this.framework = framework;
            return this;
        }

        public Builder setWebSocketAdapterFactory(IWebSocketAdapterFactory factory) {
            this.webSocketAdapterFactory = factory;
            return this;
        }

        public Builder setClassLoaderAdapter(ClassLoaderAdapter classLoaderAdapter) {
            this.classLoaderAdapter = classLoaderAdapter;
            return this;
        }

        public Builder setApmGenerater(IApmGenerator apmGenerater) {
            this.apmGenerater = apmGenerater;
            return this;
        }

        public Builder setJsFileLoaderAdapter(IWXJsFileLoaderAdapter jsFileLoaderAdapter) {
            this.jsFileLoaderAdapter = jsFileLoaderAdapter;
            return this;
        }

        public Builder addNativeLibrary(String name) {
            this.nativeLibraryList.add(name);
            return this;
        }

        public InitConfig build() {
            InitConfig config = new InitConfig();
            config.httpAdapter = this.httpAdapter;
            config.imgAdapter = this.imgAdapter;
            config.drawableLoader = this.drawableLoader;
            config.utAdapter = this.utAdapter;
            config.storageAdapter = this.storageAdapter;
            config.soLoader = this.soLoader;
            config.framework = this.framework;
            config.mURIAdapter = this.mURIAdapter;
            config.webSocketAdapterFactory = this.webSocketAdapterFactory;
            config.mJSExceptionAdapter = this.mJSExceptionAdapter;
            config.classLoaderAdapter = this.classLoaderAdapter;
            config.apmGenerater = this.apmGenerater;
            config.jsFileLoaderAdapter = this.jsFileLoaderAdapter;
            config.jscProcessManager = this.jscProcessManager;
            config.nativeLibraryList = this.nativeLibraryList;
            return config;
        }
    }
}

