/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.wson;

import androidx.collection.LruCache;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Wson {
    public static final boolean WriteMapNullValue = false;
    private static final byte NULL_TYPE = 48;
    private static final byte STRING_TYPE = 115;
    private static final byte BOOLEAN_TYPE_TRUE = 116;
    private static final byte BOOLEAN_TYPE_FALSE = 102;
    private static final byte NUMBER_INT_TYPE = 105;
    private static final byte NUMBER_LONG_TYPE = 108;
    private static final byte NUMBER_BIG_INTEGER_TYPE = 103;
    private static final byte NUMBER_BIG_DECIMAL_TYPE = 101;
    private static final byte NUMBER_DOUBLE_TYPE = 100;
    private static final byte NUMBER_FLOAT_TYPE = 70;
    private static final byte ARRAY_TYPE = 91;
    private static final byte MAP_TYPE = 123;
    private static final boolean IS_NATIVE_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final int GLOBAL_STRING_CACHE_SIZE = 2048;
    private static final ThreadLocal<char[]> localCharsBufferCache = new ThreadLocal();
    private static final String[] globalStringBytesCache = new String[2048];
    private static final String METHOD_PREFIX_GET = "get";
    private static final String METHOD_PREFIX_IS = "is";
    private static LruCache<String, List<Method>> methodsCache = new LruCache(128);
    private static LruCache<String, List<Field>> fieldsCache = new LruCache(128);
    private static LruCache<String, Boolean> specialClass = new LruCache(16);

    public static final Object parse(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            Parser parser = new Parser(data);
            Object object = parser.parse();
            parser.close();
            return object;
        }
        catch (Exception e) {
            WXLogUtils.e("parseWson", e);
            return null;
        }
    }

    public static final byte[] toWson(Object object) {
        if (object == null) {
            return null;
        }
        Builder builder = new Builder();
        byte[] bts = builder.toWson(object);
        builder.close();
        return bts;
    }

    private static final List<Method> getBeanMethod(String key, Class targetClass) {
        ArrayList<Method> methods = (ArrayList<Method>)methodsCache.get((Object)key);
        if (methods == null) {
            Method[] allMethods;
            methods = new ArrayList<Method>();
            for (Method method : allMethods = targetClass.getMethods()) {
                String methodName;
                if (method.getDeclaringClass() == Object.class || (method.getModifiers() & 8) != 0 || !(methodName = method.getName()).startsWith(METHOD_PREFIX_GET) && !methodName.startsWith(METHOD_PREFIX_IS)) continue;
                if (method.getAnnotation(JSONField.class) != null) {
                    throw new UnsupportedOperationException("getBeanMethod JSONField Annotation Not Handled, Use toJSON");
                }
                methods.add(method);
            }
            methodsCache.put((Object)key, methods);
        }
        return methods;
    }

    private static final List<Field> getBeanFields(String key, Class targetClass) {
        ArrayList<Field> fieldList = (ArrayList<Field>)fieldsCache.get((Object)key);
        if (fieldList == null) {
            Field[] fields = targetClass.getFields();
            fieldList = new ArrayList<Field>(fields.length);
            for (Field field : fields) {
                if ((field.getModifiers() & 8) != 0) continue;
                if (field.getAnnotation(JSONField.class) != null) {
                    throw new UnsupportedOperationException("getBeanMethod JSONField Annotation Not Handled, Use toJSON");
                }
                fieldList.add(field);
            }
            fieldsCache.put((Object)key, fieldList);
        }
        return fieldList;
    }

    private static final class Builder {
        private byte[] buffer = bufLocal.get();
        private int position;
        private ArrayList refs;
        private static final ThreadLocal<byte[]> bufLocal = new ThreadLocal();
        private static final ThreadLocal<ArrayList> refsLocal = new ThreadLocal();

        private Builder() {
            if (this.buffer != null) {
                bufLocal.set(null);
            } else {
                this.buffer = new byte[1024];
            }
            this.refs = refsLocal.get();
            if (this.refs != null) {
                refsLocal.set(null);
            } else {
                this.refs = new ArrayList(16);
            }
        }

        private final byte[] toWson(Object object) {
            this.writeObject(object);
            byte[] bts = new byte[this.position];
            System.arraycopy(this.buffer, 0, bts, 0, this.position);
            return bts;
        }

        private final void close() {
            if (this.buffer.length <= 16384) {
                bufLocal.set(this.buffer);
            }
            if (this.refs.isEmpty()) {
                refsLocal.set(this.refs);
            } else {
                this.refs.clear();
            }
            this.refs = null;
            this.buffer = null;
            this.position = 0;
        }

        private final void writeObject(Object object) {
            if (object instanceof CharSequence) {
                this.ensureCapacity(2);
                this.writeByte((byte)115);
                this.writeUTF16String((CharSequence)object);
                return;
            }
            if (object instanceof Map) {
                if (this.refs.contains(object)) {
                    this.ensureCapacity(2);
                    this.writeByte((byte)48);
                    return;
                }
                this.refs.add(object);
                Map map = (Map)object;
                this.writeMap(map);
                this.refs.remove(this.refs.size() - 1);
                return;
            }
            if (object instanceof List) {
                if (this.refs.contains(object)) {
                    this.ensureCapacity(2);
                    this.writeByte((byte)48);
                    return;
                }
                this.refs.add(object);
                this.ensureCapacity(8);
                List list = (List)object;
                this.writeByte((byte)91);
                this.writeUInt(list.size());
                for (Object value : list) {
                    this.writeObject(value);
                }
                this.refs.remove(this.refs.size() - 1);
                return;
            }
            if (object instanceof Number) {
                Number number = (Number)object;
                this.writeNumber(number);
                return;
            }
            if (object instanceof Boolean) {
                this.ensureCapacity(2);
                Boolean value = (Boolean)object;
                if (value.booleanValue()) {
                    this.writeByte((byte)116);
                } else {
                    this.writeByte((byte)102);
                }
                return;
            }
            if (object == null) {
                this.ensureCapacity(2);
                this.writeByte((byte)48);
                return;
            }
            if (object.getClass().isArray()) {
                if (this.refs.contains(object)) {
                    this.ensureCapacity(2);
                    this.writeByte((byte)48);
                    return;
                }
                this.refs.add(object);
                this.ensureCapacity(8);
                int length = Array.getLength(object);
                this.writeByte((byte)91);
                this.writeUInt(length);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(object, i);
                    this.writeObject(value);
                }
                this.refs.remove(this.refs.size() - 1);
                return;
            }
            if (object instanceof Date) {
                this.ensureCapacity(10);
                double date = ((Date)object).getTime();
                this.writeByte((byte)100);
                this.writeDouble(date);
            } else if (object instanceof Calendar) {
                this.ensureCapacity(10);
                double date = ((Calendar)object).getTime().getTime();
                this.writeByte((byte)100);
                this.writeDouble(date);
            } else if (object instanceof Collection) {
                if (this.refs.contains(object)) {
                    this.ensureCapacity(2);
                    this.writeByte((byte)48);
                    return;
                }
                this.refs.add(object);
                this.ensureCapacity(8);
                Collection list = (Collection)object;
                this.writeByte((byte)91);
                this.writeUInt(list.size());
                for (Object value : list) {
                    this.writeObject(value);
                }
                this.refs.remove(this.refs.size() - 1);
            } else {
                if (this.refs.contains(object)) {
                    this.ensureCapacity(2);
                    this.writeByte((byte)48);
                } else {
                    this.refs.add(object);
                    if (object.getClass().isEnum()) {
                        this.writeObject(JSON.toJSONString((Object)object));
                    } else {
                        this.writeAdapterObject(object);
                    }
                    this.refs.remove(this.refs.size() - 1);
                }
                return;
            }
        }

        private final void writeNumber(Number number) {
            this.ensureCapacity(12);
            if (number instanceof Integer) {
                this.writeByte((byte)105);
                this.writeVarInt(number.intValue());
                return;
            }
            if (number instanceof Float) {
                this.writeByte((byte)70);
                this.writeFloat(number.floatValue());
                return;
            }
            if (number instanceof Double) {
                this.writeByte((byte)100);
                this.writeDouble(number.doubleValue());
                return;
            }
            if (number instanceof Long) {
                this.writeByte((byte)108);
                this.writeLong(number.longValue());
                return;
            }
            if (number instanceof Short || number instanceof Byte) {
                this.writeByte((byte)105);
                this.writeVarInt(number.intValue());
                return;
            }
            if (number instanceof BigInteger) {
                this.writeByte((byte)103);
                this.writeUTF16String(number.toString());
                return;
            }
            if (number instanceof BigDecimal) {
                double doubleValue;
                String value = number.toString();
                if (value.equals(Double.toString(doubleValue = number.doubleValue()))) {
                    this.writeByte((byte)100);
                    this.writeDouble(doubleValue);
                } else {
                    this.writeByte((byte)101);
                    this.writeUTF16String(value);
                }
                return;
            }
            this.writeByte((byte)115);
            this.writeUTF16String(number.toString());
        }

        private final void writeMap(Map map) {
            Set entries = map.entrySet();
            int nullValueSize = 0;
            for (Map.Entry entry : entries) {
                if (entry.getValue() != null) continue;
                ++nullValueSize;
            }
            this.ensureCapacity(8);
            this.writeByte((byte)123);
            this.writeUInt(map.size() - nullValueSize);
            for (Map.Entry entry : entries) {
                if (entry.getValue() == null) continue;
                this.writeMapKeyUTF16(entry.getKey().toString());
                this.writeObject(entry.getValue());
            }
        }

        private final void writeByte(byte type) {
            this.buffer[this.position] = type;
            ++this.position;
        }

        private final void writeAdapterObject(Object object) {
            if (specialClass.get((Object)object.getClass().getName()) != null) {
                this.writeObject(JSON.toJSON((Object)object));
                return;
            }
            try {
                this.writeMap(this.toMap(object));
            }
            catch (Exception e) {
                specialClass.put((Object)object.getClass().getName(), (Object)true);
                this.writeObject(JSON.toJSON((Object)object));
            }
        }

        private final Map toMap(Object object) {
            JSONObject map = new JSONObject();
            try {
                Class<?> targetClass = object.getClass();
                String key = targetClass.getName();
                List methods = Wson.getBeanMethod(key, targetClass);
                for (Method method : methods) {
                    StringBuilder builder;
                    Object value;
                    String methodName = method.getName();
                    if (methodName.startsWith(Wson.METHOD_PREFIX_GET)) {
                        value = method.invoke(object, new Object[0]);
                        if (value == null) continue;
                        builder = new StringBuilder(method.getName().substring(3));
                        builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
                        map.put(builder.toString(), value);
                        continue;
                    }
                    if (!methodName.startsWith(Wson.METHOD_PREFIX_IS) || (value = method.invoke(object, new Object[0])) == null) continue;
                    builder = new StringBuilder(method.getName().substring(2));
                    builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
                    map.put(builder.toString(), value);
                }
                List fields = Wson.getBeanFields(key, targetClass);
                for (Field field : fields) {
                    Object value;
                    String fieldName = field.getName();
                    if (map.containsKey(fieldName) || (value = field.get(object)) == null) continue;
                    map.put(fieldName, value);
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            return map;
        }

        private final void writeMapKeyUTF16(String value) {
            this.writeUTF16String(value);
        }

        private final void writeUTF16String(CharSequence value) {
            int length = value.length();
            this.ensureCapacity(length * 2 + 8);
            this.writeUInt(length * 2);
            if (IS_NATIVE_LITTLE_ENDIAN) {
                for (int i = 0; i < length; ++i) {
                    char ch = value.charAt(i);
                    this.buffer[this.position] = (byte)ch;
                    this.buffer[this.position + 1] = (byte)(ch >>> 8);
                    this.position += 2;
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    char ch = value.charAt(i);
                    this.buffer[this.position + 1] = (byte)ch;
                    this.buffer[this.position] = (byte)(ch >>> 8);
                    this.position += 2;
                }
            }
        }

        private final void writeDouble(double value) {
            this.writeLong(Double.doubleToLongBits(value));
        }

        private final void writeFloat(float value) {
            int val = Float.floatToIntBits(value);
            this.buffer[this.position + 3] = (byte)val;
            this.buffer[this.position + 2] = (byte)(val >>> 8);
            this.buffer[this.position + 1] = (byte)(val >>> 16);
            this.buffer[this.position] = (byte)(val >>> 24);
            this.position += 4;
        }

        private final void writeLong(long val) {
            this.buffer[this.position + 7] = (byte)val;
            this.buffer[this.position + 6] = (byte)(val >>> 8);
            this.buffer[this.position + 5] = (byte)(val >>> 16);
            this.buffer[this.position + 4] = (byte)(val >>> 24);
            this.buffer[this.position + 3] = (byte)(val >>> 32);
            this.buffer[this.position + 2] = (byte)(val >>> 40);
            this.buffer[this.position + 1] = (byte)(val >>> 48);
            this.buffer[this.position] = (byte)(val >>> 56);
            this.position += 8;
        }

        private final void writeVarInt(int value) {
            this.writeUInt(value << 1 ^ value >> 31);
        }

        private final void writeUInt(int value) {
            while ((value & 0xFFFFFF80) != 0) {
                this.buffer[this.position] = (byte)(value & 0x7F | 0x80);
                ++this.position;
                value >>>= 7;
            }
            this.buffer[this.position] = (byte)(value & 0x7F);
            ++this.position;
        }

        private final void ensureCapacity(int minCapacity) {
            if ((minCapacity += this.position) - this.buffer.length > 0) {
                int oldCapacity = this.buffer.length;
                int newCapacity = oldCapacity << 1;
                if (newCapacity < 16384) {
                    newCapacity = 16384;
                }
                if (newCapacity - minCapacity < 0) {
                    newCapacity = minCapacity;
                }
                this.buffer = Arrays.copyOf(this.buffer, newCapacity);
            }
        }
    }

    private static final class Parser {
        private int position = 0;
        private byte[] buffer;
        private char[] charsBuffer;

        private Parser(byte[] buffer) {
            this.buffer = buffer;
            this.charsBuffer = (char[])localCharsBufferCache.get();
            if (this.charsBuffer != null) {
                localCharsBufferCache.set(null);
            } else {
                this.charsBuffer = new char[512];
            }
        }

        private final Object parse() {
            return this.readObject();
        }

        private final void close() {
            this.position = 0;
            this.buffer = null;
            if (this.charsBuffer != null) {
                localCharsBufferCache.set(this.charsBuffer);
            }
            this.charsBuffer = null;
        }

        private final Object readObject() {
            byte type = this.readType();
            switch (type) {
                case 115: {
                    return this.readUTF16String();
                }
                case 105: {
                    return this.readVarInt();
                }
                case 70: {
                    return this.readFloat();
                }
                case 123: {
                    return this.readMap();
                }
                case 91: {
                    return this.readArray();
                }
                case 100: {
                    return this.readDouble();
                }
                case 108: {
                    return this.readLong();
                }
                case 103: {
                    return new BigInteger(this.readUTF16String());
                }
                case 101: {
                    return new BigDecimal(this.readUTF16String());
                }
                case 102: {
                    return Boolean.FALSE;
                }
                case 116: {
                    return Boolean.TRUE;
                }
                case 48: {
                    return null;
                }
            }
            throw new RuntimeException("wson unhandled type " + type + " " + this.position + " length " + this.buffer.length);
        }

        private final Object readMap() {
            int size = this.readUInt();
            JSONObject object = new JSONObject();
            for (int i = 0; i < size; ++i) {
                String key = this.readMapKeyUTF16();
                Object value = this.readObject();
                object.put(key, value);
            }
            return object;
        }

        private final Object readArray() {
            int length = this.readUInt();
            JSONArray array = new JSONArray(length);
            for (int i = 0; i < length; ++i) {
                array.add(this.readObject());
            }
            return array;
        }

        private final byte readType() {
            byte type = this.buffer[this.position];
            ++this.position;
            return type;
        }

        private final String readMapKeyUTF16() {
            char ch;
            int i;
            int length = this.readUInt();
            if (this.charsBuffer.length < (length /= 2)) {
                this.charsBuffer = new char[length];
            }
            int hash = 5381;
            if (IS_NATIVE_LITTLE_ENDIAN) {
                for (i = 0; i < length; ++i) {
                    this.charsBuffer[i] = ch = (char)((this.buffer[this.position] & 0xFF) + (this.buffer[this.position + 1] << 8));
                    hash = (hash << 5) + hash + ch;
                    this.position += 2;
                }
            } else {
                for (i = 0; i < length; ++i) {
                    this.charsBuffer[i] = ch = (char)((this.buffer[this.position + 1] & 0xFF) + (this.buffer[this.position] << 8));
                    hash = (hash << 5) + hash + ch;
                    this.position += 2;
                }
            }
            int globalIndex = globalStringBytesCache.length - 1 & hash;
            String cache = globalStringBytesCache[globalIndex];
            if (cache != null && cache.length() == length) {
                boolean isStringEqual = true;
                for (int i2 = 0; i2 < length; ++i2) {
                    if (this.charsBuffer[i2] == cache.charAt(i2)) continue;
                    isStringEqual = false;
                    break;
                }
                if (isStringEqual) {
                    return cache;
                }
            }
            cache = new String(this.charsBuffer, 0, length);
            if (length < 64) {
                globalStringBytesCache[globalIndex] = cache;
            }
            return cache;
        }

        private final String readUTF16String() {
            int length = this.readUInt() / 2;
            if (this.charsBuffer.length < length) {
                this.charsBuffer = new char[length];
            }
            if (IS_NATIVE_LITTLE_ENDIAN) {
                for (int i = 0; i < length; ++i) {
                    char ch;
                    this.charsBuffer[i] = ch = (char)((this.buffer[this.position] & 0xFF) + (this.buffer[this.position + 1] << 8));
                    this.position += 2;
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    char ch;
                    this.charsBuffer[i] = ch = (char)((this.buffer[this.position + 1] & 0xFF) + (this.buffer[this.position] << 8));
                    this.position += 2;
                }
            }
            return new String(this.charsBuffer, 0, length);
        }

        private final int readVarInt() {
            int raw = this.readUInt();
            int num = (raw << 31 >> 31 ^ raw) >> 1;
            return num ^ raw & Integer.MIN_VALUE;
        }

        private final int readUInt() {
            byte b;
            int value = 0;
            int i = 0;
            while (((b = this.buffer[this.position]) & 0x80) != 0) {
                value |= (b & 0x7F) << i;
                ++this.position;
                if ((i += 7) <= 35) continue;
                throw new IllegalArgumentException("Variable length quantity is too long");
            }
            ++this.position;
            return value | b << i;
        }

        private final long readLong() {
            long number = ((long)this.buffer[this.position + 7] & 0xFFL) + (((long)this.buffer[this.position + 6] & 0xFFL) << 8) + (((long)this.buffer[this.position + 5] & 0xFFL) << 16) + (((long)this.buffer[this.position + 4] & 0xFFL) << 24) + (((long)this.buffer[this.position + 3] & 0xFFL) << 32) + (((long)this.buffer[this.position + 2] & 0xFFL) << 40) + (((long)this.buffer[this.position + 1] & 0xFFL) << 48) + ((long)this.buffer[this.position] << 56);
            this.position += 8;
            return number;
        }

        private final Object readDouble() {
            long numberLong;
            double doubleLong;
            double number = Double.longBitsToDouble(this.readLong());
            if (number > 2.147483647E9 && number - (doubleLong = (double)(numberLong = (long)number)) < Double.MIN_NORMAL) {
                return numberLong;
            }
            return number;
        }

        private Object readFloat() {
            int number = (this.buffer[this.position + 3] & 0xFF) + ((this.buffer[this.position + 2] & 0xFF) << 8) + ((this.buffer[this.position + 1] & 0xFF) << 16) + ((this.buffer[this.position] & 0xFF) << 24);
            this.position += 4;
            return Float.valueOf(Float.intBitsToFloat(number));
        }
    }
}

