/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import android.content.Context;
import android.view.Surface;
import cn.rongcloud.rtc.api.RCRTCAudioMixer;
import cn.rongcloud.rtc.api.callback.IRCRTCOnStreamSendListener;
import cn.rongcloud.rtc.api.stream.RCRTCFileVideoOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCSurfaceTextureHelper;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCVideoOutStreamImpl;
import cn.rongcloud.rtc.core.audio.AudioWriteHelper;
import cn.rongcloud.rtc.plugin.PluginUtils;
import cn.rongcloud.rtc.plugin.player.INetPlayer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RCNetFileVideoOutStreamImpl
extends RCVideoOutStreamImpl
implements RCRTCFileVideoOutputStream,
INetPlayer.INetPlayerListener {
    public static final String VIDEO_TAG = "RCNetFileVideoOutStreamImpl";
    private IRCRTCOnStreamSendListener mOnSendListener;
    private String filePath;
    private boolean replace = false;
    private boolean playback = true;
    INetPlayer mPlayer;
    private AudioWriteHelper audioWriteHelper;
    private RCRTCSurfaceTextureHelper.Sink screenFrameSink = new RCRTCSurfaceTextureHelper.Sink(){

        @Override
        public void onTexture(int textureWidth, int textureHeight, int oexTextureId, float[] transformMatrix, int rotation, long timestampNs) {
            if (RCNetFileVideoOutStreamImpl.this.mMediaInfo == null) {
                RCNetFileVideoOutStreamImpl.this.writeTexture(textureWidth, textureHeight, oexTextureId, transformMatrix, rotation, timestampNs);
            } else if (RCNetFileVideoOutStreamImpl.this.mMediaInfo.mWidth > RCNetFileVideoOutStreamImpl.this.mMediaInfo.mHeight) {
                RCNetFileVideoOutStreamImpl.this.writeTexture(textureHeight, textureWidth, oexTextureId, transformMatrix, rotation, timestampNs);
            } else {
                RCNetFileVideoOutStreamImpl.this.writeTexture(textureWidth, textureHeight, oexTextureId, transformMatrix, rotation, timestampNs);
            }
        }
    };
    volatile INetPlayer.MediaInfo mMediaInfo;
    int poolSize = 1;
    private BlockingQueue<Runnable> mQueue = new LinkedBlockingQueue<Runnable>();
    ExecutorService mPlayerThreadExecutor = new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.MILLISECONDS, this.mQueue);

    public RCNetFileVideoOutStreamImpl(Context context, String path, boolean replace, boolean playback, String tag, String userId, RCRTCConfigImpl config, RCMicOutputStreamImpl audioOutputStream) {
        super(tag, userId);
        this.filePath = path;
        this.replace = replace;
        this.playback = playback;
        this.mPlayer = (INetPlayer)PluginUtils.loadPlayerPluginByName("cn.rongcloud.rtc.media.player.api.ImplNetPlayer");
        this.mPlayer.setListener(this);
        this.audioWriteHelper = new AudioWriteHelper(false);
    }

    private boolean isFileProtocol() {
        return !this.filePath.startsWith("http") && !this.filePath.startsWith("rtmp") && !this.filePath.startsWith("rtsp");
    }

    public void setPlayback(boolean playback) {
        this.playback = playback;
    }

    @Override
    public void setOnSendListener(IRCRTCOnStreamSendListener onSendListener) {
        this.mOnSendListener = onSendListener;
    }

    private void handleError() {
        if (this.mOnSendListener != null) {
            this.mOnSendListener.onFailed();
        }
    }

    @Override
    public synchronized void start() {
        this.startDecode();
    }

    private void startDecode() {
        if (this.mOnSendListener != null) {
            this.mOnSendListener.onStart(this);
        }
        INetPlayer.Builder builder = new INetPlayer.Builder();
        RCRTCSurfaceTextureHelper surfaceTextureHelper = this.getTextureHelper();
        if (null == surfaceTextureHelper) {
            return;
        }
        surfaceTextureHelper.setTextureSize(this.getWidth(), this.getHeight());
        Surface surface = new Surface(surfaceTextureHelper.getSurfaceTexture());
        builder.setSurface(surface);
        builder.setUrl(this.filePath);
        if (this.playback) {
            builder.setVolume(1.0f);
        } else {
            builder.setVolume(0.0f);
        }
        this.mPlayer.play(builder);
        surfaceTextureHelper.startListening(this.screenFrameSink);
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.interiorRelease();
    }

    private synchronized void interiorRelease() {
        if (null != this.mPlayer) {
            this.mPlayer.releaseSync();
        }
        this.mQueue.clear();
        this.mPlayerThreadExecutor.shutdown();
        if (null != this.audioWriteHelper) {
            this.audioWriteHelper.release();
            this.audioWriteHelper = null;
        }
    }

    @Override
    public void release() {
        this.interiorRelease();
        super.release();
    }

    @Override
    public void onPrepared(INetPlayer.MediaInfo mediaInfo) {
        this.mMediaInfo = mediaInfo;
    }

    @Override
    public void onPrepared() {
    }

    @Override
    public void onError(int error) {
        this.handleError();
    }

    @Override
    public void onCompletion(int count) {
        if (0 == count) {
            // empty if block
        }
    }

    @Override
    public void onPcm(byte[] audioData, int offsetInBytes, int sizeInBytes, final int sampleRate, final int channelCount, final int audioFormat) {
        final byte[] newBuf = new byte[sizeInBytes];
        System.arraycopy(audioData, offsetInBytes, newBuf, 0, sizeInBytes);
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                RCRTCAudioMixer.Mode mode = RCRTCAudioMixer.Mode.NONE;
                mode = RCNetFileVideoOutStreamImpl.this.replace ? RCRTCAudioMixer.Mode.REPLACE : RCRTCAudioMixer.Mode.MIX;
                AudioWriteHelper helper = RCNetFileVideoOutStreamImpl.this.audioWriteHelper;
                if (null != helper) {
                    helper.write(newBuf, sampleRate, channelCount, audioFormat, 100, mode);
                }
            }
        });
    }
}

