/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.widget.refresh;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.dcloud.android.v4.view.ViewCompat;

public class DCWeexCircleImageView
extends ImageView {
    private static final int KEY_SHADOW_COLOR = 0x5E000000;
    private static final int FILL_SHADOW_COLOR = 0x3D000000;
    private static final float X_OFFSET = 0.0f;
    private static final float Y_OFFSET = 1.0f;
    private static final float SHADOW_RADIUS = 2.5f;
    private static final int SHADOW_ELEVATION = 4;
    private Animation.AnimationListener mListener;
    private int mShadowRadius;

    public DCWeexCircleImageView(Context context, int color2, float radius) {
        super(context);
        ShapeDrawable circle;
        float density = this.getContext().getResources().getDisplayMetrics().density;
        int diameter = (int)(radius * density * 2.0f);
        int shadowYOffset = (int)(density * 1.0f);
        int shadowXOffset = (int)(density * 0.0f);
        this.mShadowRadius = (int)(density * 2.5f);
        if (this.elevationSupported()) {
            circle = new ShapeDrawable((Shape)new OvalShape());
            ViewCompat.setElevation((View)this, (float)(4.0f * density));
        } else {
            OvalShadow oval = new OvalShadow(this.mShadowRadius, diameter);
            circle = new ShapeDrawable((Shape)oval);
            ViewCompat.setLayerType((View)this, (int)1, (Paint)circle.getPaint());
            circle.getPaint().setShadowLayer((float)this.mShadowRadius, (float)shadowXOffset, (float)shadowYOffset, 0x5E000000);
            int padding = this.mShadowRadius;
            this.setPadding(padding, padding, padding, padding);
        }
        circle.getPaint().setColor(color2);
        this.setBackgroundDrawable((Drawable)circle);
    }

    private boolean elevationSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.elevationSupported()) {
            this.setMeasuredDimension(this.getMeasuredWidth() + this.mShadowRadius * 2, this.getMeasuredHeight() + this.mShadowRadius * 2);
        }
    }

    public void setAnimationListener(Animation.AnimationListener listener) {
        this.mListener = listener;
    }

    public void onAnimationStart() {
        super.onAnimationStart();
        if (this.mListener != null) {
            this.mListener.onAnimationStart(this.getAnimation());
        }
    }

    public void onAnimationEnd() {
        super.onAnimationEnd();
        if (this.mListener != null) {
            this.mListener.onAnimationEnd(this.getAnimation());
        }
    }

    public void setBackgroundColorRes(int colorRes) {
        this.setBackgroundColor(this.getContext().getResources().getColor(colorRes));
    }

    public void setBackgroundColor(int color2) {
        if (this.getBackground() instanceof ShapeDrawable) {
            ((ShapeDrawable)this.getBackground()).getPaint().setColor(color2);
        }
    }

    private class OvalShadow
    extends OvalShape {
        private RadialGradient mRadialGradient;
        private Paint mShadowPaint = new Paint();
        private int mCircleDiameter;

        public OvalShadow(int shadowRadius, int circleDiameter) {
            DCWeexCircleImageView.this.mShadowRadius = shadowRadius;
            this.mCircleDiameter = circleDiameter;
            this.mRadialGradient = new RadialGradient((float)(this.mCircleDiameter / 2), (float)(this.mCircleDiameter / 2), (float)DCWeexCircleImageView.this.mShadowRadius, new int[]{0x3D000000, 0}, null, Shader.TileMode.CLAMP);
            this.mShadowPaint.setShader((Shader)this.mRadialGradient);
        }

        public void draw(Canvas canvas, Paint paint) {
            int viewWidth = DCWeexCircleImageView.this.getWidth();
            int viewHeight = DCWeexCircleImageView.this.getHeight();
            canvas.drawCircle((float)(viewWidth / 2), (float)(viewHeight / 2), (float)(this.mCircleDiameter / 2 + DCWeexCircleImageView.this.mShadowRadius), this.mShadowPaint);
            canvas.drawCircle((float)(viewWidth / 2), (float)(viewHeight / 2), (float)(this.mCircleDiameter / 2), paint);
        }
    }
}

