/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.media.player.misc;

import android.annotation.TargetApi;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import android.os.Build;
import cn.rongcloud.rtc.media.player.misc.AndroidMediaFormat;
import cn.rongcloud.rtc.media.player.misc.IMediaFormat;
import cn.rongcloud.rtc.media.player.misc.ITrackInfo;

public class AndroidTrackInfo
implements ITrackInfo {
    private final MediaPlayer.TrackInfo mTrackInfo;

    public static AndroidTrackInfo[] fromMediaPlayer(MediaPlayer mp) {
        if (Build.VERSION.SDK_INT >= 16) {
            return AndroidTrackInfo.fromTrackInfo(mp.getTrackInfo());
        }
        return null;
    }

    private static AndroidTrackInfo[] fromTrackInfo(MediaPlayer.TrackInfo[] trackInfos) {
        if (trackInfos == null) {
            return null;
        }
        AndroidTrackInfo[] androidTrackInfo = new AndroidTrackInfo[trackInfos.length];
        for (int i = 0; i < trackInfos.length; ++i) {
            androidTrackInfo[i] = new AndroidTrackInfo(trackInfos[i]);
        }
        return androidTrackInfo;
    }

    private AndroidTrackInfo(MediaPlayer.TrackInfo trackInfo) {
        this.mTrackInfo = trackInfo;
    }

    @Override
    @TargetApi(value=19)
    public IMediaFormat getFormat() {
        if (this.mTrackInfo == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        MediaFormat mediaFormat = this.mTrackInfo.getFormat();
        if (mediaFormat == null) {
            return null;
        }
        return new AndroidMediaFormat(mediaFormat);
    }

    @Override
    @TargetApi(value=16)
    public String getLanguage() {
        if (this.mTrackInfo == null) {
            return "und";
        }
        return this.mTrackInfo.getLanguage();
    }

    @Override
    @TargetApi(value=16)
    public int getTrackType() {
        if (this.mTrackInfo == null) {
            return 0;
        }
        return this.mTrackInfo.getTrackType();
    }

    @TargetApi(value=16)
    public String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append(this.getClass().getSimpleName());
        out.append('{');
        if (this.mTrackInfo != null) {
            out.append(this.mTrackInfo.toString());
        } else {
            out.append("null");
        }
        out.append('}');
        return out.toString();
    }

    @Override
    @TargetApi(value=16)
    public String getInfoInline() {
        if (this.mTrackInfo != null) {
            return this.mTrackInfo.toString();
        }
        return "null";
    }
}

