/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.stream.view;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import cn.rongcloud.rtc.api.RCRTCVideoStream;
import cn.rongcloud.rtc.api.callback.RCRTCVideoStreamEventListener;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.api.stream.view.RCRTCBaseView;
import cn.rongcloud.rtc.api.stream.view.RCRTCDrawer;
import cn.rongcloud.rtc.api.stream.view.RCRTCRendererEventsListener;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.core.CreateEglCallback;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.EglRenderer;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.FinLog;

public abstract class RCRTCBaseRenderer
implements RCRTCBaseView,
RCRTCDrawer,
RendererCommon.GlDrawer {
    private static final String TAG = "RCRTCBaseRenderer";
    protected final EglRenderer eglRenderer;
    protected RCRTCRendererEventsListener rendererEvents;
    private boolean isFirstFrameRendered;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private int frameRotation = -1;
    private RCRTCVideoStream videoStream;

    public RCRTCBaseRenderer(String resourceName) {
        this.eglRenderer = new EglRenderer(resourceName);
    }

    @Override
    public final void init(EglBase.Context context, RCRTCVideoStream videoStream) {
        FinLog.d(TAG, "[init] ==> context:" + context + ",videoStream:" + videoStream);
        if (videoStream == null) {
            throw new NullPointerException("RCRTCVideoStream is Null");
        }
        this.videoStream = videoStream;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.frameRotation = -1;
        this.eglRenderer.setCreateEglCallback(new CreateEglCallback(){

            @Override
            public void onFailed(Exception e) {
                RCRTCBaseRenderer.this.onCreateEglFailed(e);
            }
        });
        try {
            this.init(context);
            this.eglRenderer.init(context, EglBase.CONFIG_PLAIN, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onCreateEglFailed(e);
        }
    }

    @Override
    public void setRendererEventsListener(RCRTCRendererEventsListener listener) {
        FinLog.d(TAG, "[setRendererEventsListener] ==> StreamId:" + this.getStreamId() + ", listener:" + listener);
        this.rendererEvents = listener;
    }

    @Override
    public void setMirror(boolean mirror) {
        FinLog.d(TAG, "[setMirror] ==> StreamId:" + this.getStreamId() + ", mirror:" + mirror);
        this.eglRenderer.setMirror(mirror);
    }

    @Override
    public void setScalingType(RendererCommon.ScalingType mode) {
        FinLog.d(TAG, "[setScalingType] ==> StreamId:" + this.getStreamId() + ", mode:" + (Object)((Object)mode));
    }

    protected void onFirstFrameRendered(int w, int h) {
        RCRTCRendererEventsListener rendererListener;
        FinLog.d(TAG, "[onFirstFrameRendered] ==>  StreamId:" + this.getStreamId());
        RCRTCVideoStream videoStream = this.videoStream;
        if (videoStream != null) {
            RTCEngineImpl.getInstance().onFirstFrameRendered(videoStream.getUserId(), videoStream.getTag());
            if (videoStream instanceof RCRTCInputStream) {
                RTCEngineImpl.getInstance().onReportFirstFrame((RCRTCInputStream)((Object)videoStream), RCRTCMediaType.VIDEO);
            }
            RTCEngineImpl.getInstance().onFirstFrameRendered(videoStream.getUserId(), videoStream.getTag(), w, h);
        }
        if ((rendererListener = this.rendererEvents) != null) {
            rendererListener.onFirstFrame();
        }
    }

    protected void onFrameSizeChanged(final int videoWidth, final int videoHeight) {
        FinLog.d(TAG, "[onFrameSizeChanged] ==> streamId:" + this.getStreamId() + ", videoWidth:" + videoWidth + ",videoHeight:" + videoHeight);
        this.postCallBackThread(new Runnable(){

            @Override
            public void run() {
                RCRTCVideoStreamEventListener streamEventListener = RCRTCBaseRenderer.this.getSteamEventListener();
                if (streamEventListener == null) {
                    return;
                }
                streamEventListener.onFrameSizeChanged(RCRTCBaseRenderer.this.videoStream, videoWidth, videoHeight);
            }
        });
    }

    private RCRTCVideoStreamEventListener getSteamEventListener() {
        RCRTCVideoStream videoStream = this.videoStream;
        if (videoStream == null) {
            return null;
        }
        return videoStream.getStreamEventListener();
    }

    protected void onFrameRotationChanged(final int rotation) {
        FinLog.d(TAG, "[onFrameRotationChanged] ==> streamId:" + this.getStreamId() + ", rotation:" + rotation);
        this.postCallBackThread(new Runnable(){

            @Override
            public void run() {
                RCRTCVideoStreamEventListener streamEventListener = RCRTCBaseRenderer.this.getSteamEventListener();
                if (streamEventListener == null) {
                    return;
                }
                streamEventListener.onFrameRotationChanged(RCRTCBaseRenderer.this.videoStream, rotation);
            }
        });
    }

    protected void postCallBackThread(Runnable runnable) {
        RTCEngineImpl.getInstance().postCallback(runnable);
    }

    private void onCreateEglFailed(Exception e) {
        FinLog.d(TAG, "[onCreateEglFailed] ==> streamId:" + this.getStreamId() + ", e:" + e);
        RCRTCVideoStream videoStream = this.videoStream;
        if (videoStream != null) {
            RTCEngineImpl.getInstance().onCreateEglFailed(videoStream.getUserId(), videoStream.getTag(), e);
        }
    }

    @Override
    public void onFrame(VideoFrame frame) {
        this.updateFrameDimensionsAndReportEvents(frame);
        this.eglRenderer.onFrame(frame);
    }

    public void setFpsReduction(float fps) {
        FinLog.d(TAG, "[setFpsReduction] ==> fps:" + fps);
        this.eglRenderer.setFpsReduction(fps);
    }

    public void disableFpsReduction() {
        FinLog.d(TAG, "[disableFpsReduction] ==> ");
        this.eglRenderer.disableFpsReduction();
    }

    public void pauseVideo() {
        FinLog.d(TAG, "[pauseVideo] ==>  ");
        this.eglRenderer.pauseVideo();
    }

    public void clearImage() {
        FinLog.d(TAG, "[clearImage] ==>  ");
        this.eglRenderer.clearImage();
    }

    public void createEglSurface(SurfaceTexture texture) {
        FinLog.d(TAG, "[createEglSurface] ==> StreamId:" + this.getStreamId() + ", texture:" + texture);
        this.eglRenderer.createEglSurface(texture);
    }

    public void createEglSurface(Surface surface) {
        FinLog.d(TAG, "[createEglSurface] ==> StreamId:" + this.getStreamId() + ", surface:" + surface);
        this.eglRenderer.createEglSurface(surface);
    }

    public void addFrameListener(EglRenderer.FrameListener listener, float scale, RendererCommon.GlDrawer drawer) {
        FinLog.d(TAG, "[addFrameListener] ==> listener:" + listener + ",scale:" + scale + ",drawer:" + drawer);
        this.eglRenderer.addFrameListener(listener, scale, drawer);
    }

    public void addFrameListener(EglRenderer.FrameListener listener, float scale) {
        FinLog.d(TAG, "[addFrameListener] ==> StreamId:" + this.getStreamId() + ", listener:" + listener + ",scale:" + scale);
        this.eglRenderer.addFrameListener(listener, scale);
    }

    public void removeFrameListener(EglRenderer.FrameListener listener) {
        FinLog.d(TAG, "[removeFrameListener] ==> StreamId:" + this.getStreamId() + ", listener:" + listener);
        this.eglRenderer.removeFrameListener(listener);
    }

    public void setLayoutAspectRatio(float layoutAspectRatio) {
        FinLog.d(TAG, "[setLayoutAspectRatio] ==> StreamId:" + this.getStreamId() + ", layoutAspectRatio:" + layoutAspectRatio);
        this.eglRenderer.setLayoutAspectRatio(layoutAspectRatio);
    }

    public void releaseEglSurface(Runnable completionCallback) {
        FinLog.d(TAG, "[releaseEglSurface] ==>  StreamId:" + this.getStreamId());
        this.eglRenderer.releaseEglSurface(completionCallback);
    }

    private void updateFrameDimensionsAndReportEvents(VideoFrame frame) {
        if (!this.isFirstFrameRendered) {
            this.isFirstFrameRendered = true;
            this.onFirstFrameRendered(frame.getBuffer().getWidth(), frame.getBuffer().getHeight());
        }
        if (this.frameRotation != frame.getRotation()) {
            this.onFrameRotationChanged(frame.getRotation());
        }
        if (this.rotatedFrameWidth != frame.getRotatedWidth() || this.rotatedFrameHeight != frame.getRotatedHeight()) {
            this.onFrameSizeChanged(frame.getBuffer().getWidth(), frame.getBuffer().getHeight());
        }
        this.rotatedFrameWidth = frame.getRotatedWidth();
        this.rotatedFrameHeight = frame.getRotatedHeight();
        this.frameRotation = frame.getRotation();
    }

    @Override
    public void release() {
        FinLog.d(TAG, "[release] ==>  StreamId:" + this.getStreamId());
        this.eglRenderer.release();
    }

    private String getStreamId() {
        if (this.videoStream != null) {
            return this.videoStream.getStreamId();
        }
        return "";
    }
}

