/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.earmonitor;

import android.media.AudioTrack;
import cn.rongcloud.rtc.utils.AudioUtil;
import cn.rongcloud.rtc.utils.FinLog;

class SilentPlayer {
    private static final String TAG = "SilentPlayer";
    private PlayThread playThread;

    SilentPlayer() {
    }

    public synchronized void play() {
        if (this.playThread == null) {
            this.playThread = new PlayThread();
            this.playThread.start();
        }
    }

    public synchronized void stop() {
        if (this.playThread != null) {
            this.playThread.stopThread();
            this.playThread = null;
        }
    }

    private static class PlayThread
    extends Thread {
        private volatile boolean keepAlive = true;

        private PlayThread() {
        }

        @Override
        public void run() {
            byte[] emptyPcmData = new byte[960];
            AudioTrack audioTrack = AudioUtil.createAudioTrack(48000, 2, 2, 3);
            if (audioTrack == null) {
                FinLog.e(SilentPlayer.TAG, "SilentPlayer: failed to create audio track.");
                return;
            }
            audioTrack.play();
            while (this.keepAlive && !this.isInterrupted()) {
                audioTrack.write(emptyPcmData, 0, emptyPcmData.length);
            }
            audioTrack.pause();
            audioTrack.release();
        }

        void stopThread() {
            this.keepAlive = false;
        }
    }
}

