/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCCombineFrameFilter;
import com.tencent.ugc.UGCTransitionProcessor;
import java.util.LinkedList;
import java.util.List;

public class UGCCombineProcessor {
    private final String TAG = "UGCCombineProcessor";
    private final UGCCombineFrameFilter mUGCCombineProcessor;
    private final int mOutputPixelWidth;
    private final int mOutputPixelHeight;
    private final List<j> mScaleRendererList;
    private final List<TXVideoEditConstants.TXAbsoluteRect> mScaleRectList;
    private final e mGLTexturePool;

    public UGCCombineProcessor(int outputPixelWidth, int outputPixelHeight, e glTexturePool) {
        LiteavLog.i("UGCCombineProcessor", "UGCCombineProcessor pixelWidth = " + outputPixelWidth + " pixelHeight = " + outputPixelHeight);
        this.mOutputPixelWidth = outputPixelWidth;
        this.mOutputPixelHeight = outputPixelHeight;
        this.mGLTexturePool = glTexturePool;
        this.mScaleRendererList = new LinkedList<j>();
        this.mScaleRectList = new LinkedList<TXVideoEditConstants.TXAbsoluteRect>();
        this.mUGCCombineProcessor = new UGCCombineFrameFilter(glTexturePool);
    }

    public void release() {
        this.mUGCCombineProcessor.release();
        for (j j2 : this.mScaleRendererList) {
            if (j2 == null) continue;
            j2.a();
        }
        this.mScaleRendererList.clear();
        this.mScaleRectList.clear();
    }

    public PixelFrame processFrame(List<PixelFrame> frameList, List<TXVideoEditConstants.TXAbsoluteRect> rectList) {
        PixelFrame pixelFrame;
        if (frameList == null || frameList.size() == 0) {
            LiteavLog.e("UGCCombineProcessor", "frameList is empty");
            return null;
        }
        this.Retain(frameList);
        LinkedList<UGCTransitionProcessor.TXCCombineFrame> linkedList = new LinkedList<UGCTransitionProcessor.TXCCombineFrame>();
        long l2 = 0L;
        for (int i2 = 0; i2 < frameList.size(); ++i2) {
            pixelFrame = frameList.get(i2);
            if (pixelFrame.getTimestamp() > l2) {
                l2 = pixelFrame.getTimestamp();
            }
            UGCTransitionProcessor.TXCCombineFrame tXCCombineFrame = new UGCTransitionProcessor.TXCCombineFrame();
            new UGCTransitionProcessor.TXCCombineFrame().drawRect = i2 < rectList.size() ? rectList.get(i2) : new TXVideoEditConstants.TXAbsoluteRect();
            tXCCombineFrame.drawInputFrame = this.preScale(pixelFrame, tXCCombineFrame.drawRect, i2);
            linkedList.add(tXCCombineFrame);
        }
        this.mUGCCombineProcessor.setCanvasSize(this.mOutputPixelWidth, this.mOutputPixelHeight);
        this.mUGCCombineProcessor.setCropRect(null);
        d d2 = this.mUGCCombineProcessor.combineFrame(linkedList);
        this.releaseFrameList(linkedList);
        if (d2 == null) {
            return null;
        }
        pixelFrame = d2.a(frameList.get(0).getGLContext());
        d2.release();
        pixelFrame.setTimestamp(l2);
        return pixelFrame;
    }

    private PixelFrame preScale(PixelFrame frameIn, TXVideoEditConstants.TXAbsoluteRect rect, int index) {
        if (this.mScaleRendererList.size() < index + 1) {
            this.mScaleRendererList.add(new j(rect.width, rect.height));
            this.mScaleRectList.add(rect);
        }
        j j2 = this.mScaleRendererList.get(index);
        TXVideoEditConstants.TXAbsoluteRect tXAbsoluteRect = this.mScaleRectList.get(index);
        if (tXAbsoluteRect.width != rect.width || tXAbsoluteRect.height != rect.height) {
            j2.a();
            j2 = new j(rect.width, rect.height);
            this.mScaleRendererList.remove(index);
            this.mScaleRendererList.add(index, j2);
        }
        d d2 = this.mGLTexturePool.a(rect.width, rect.height);
        j2.a(frameIn, GLConstants.GLScaleType.a, d2);
        PixelFrame pixelFrame = d2.a(frameIn.getGLContext());
        pixelFrame.setTimestamp(frameIn.getTimestamp());
        d2.release();
        frameIn.release();
        return pixelFrame;
    }

    private void Retain(List<PixelFrame> frameList) {
        for (PixelFrame pixelFrame : frameList) {
            if (pixelFrame == null) continue;
            pixelFrame.retain();
        }
    }

    private void releaseFrameList(List<UGCTransitionProcessor.TXCCombineFrame> combineFrameList) {
        for (UGCTransitionProcessor.TXCCombineFrame tXCCombineFrame : combineFrameList) {
            if (tXCCombineFrame.drawInputFrame == null) continue;
            tXCCombineFrame.drawInputFrame.release();
        }
    }
}

