/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.transitions;

import android.opengl.GLES20;
import com.tencent.liteav.videobase.a.b;
import com.tencent.liteav.videobase.frame.e;

public class TXCGPUTransitionFilterBase
extends b {
    public final int mType;
    private int mProgressPosition;
    private int mRatioPosition;
    protected static final String TRANSITION_BASE_VERTEX = "attribute vec2 position; \nvarying mediump vec2 _uv;\n  \nvoid main() \n{ \n    gl_Position = vec4(position,0,1); \n    vec2 uv = position * 0.5 + 0.5;\n    _uv = vec2(uv.x,1.0 - uv.y);\n}";
    protected static final String FRAG_PUBLIC_DECLARE = "precision mediump float;\nvarying mediump vec2 _uv;\nuniform sampler2D inputImageTexture;\nuniform float progress;\nuniform float ratio;";
    protected static final String FRAG_GET_FROM_COLOR = "vec4 getFromColor(in vec2 uv){\n    vec2 fromTexture = vec2(uv.x,1.0 - uv.y);\n    vec4 fromColor = texture2D(inputImageTexture,fromTexture);\n    return fromColor;\n}";
    protected static final String FRAG_GET_TO_COLOR = "vec4 getToColor(in vec2 uv){\n    vec2 toTexture = vec2(uv.x,1.0-uv.y);\n    vec4 toColor = texture2D(inputImageTexture,toTexture);\n    return toColor;\n}";
    protected static final String FRAG_MAIN = "void main() {\n    gl_FragColor = transition(_uv);\n}";

    public void setProgressForTransition(float progress) {
        TXCGPUTransitionFilterBase tXCGPUTransitionFilterBase = this;
        tXCGPUTransitionFilterBase.setFloatOnDraw(tXCGPUTransitionFilterBase.mProgressPosition, progress);
    }

    public TXCGPUTransitionFilterBase(String vertex, String fragment, int type) {
        super(vertex, fragment);
        this.mType = type;
    }

    @Override
    public void onInit(e texturePool) {
        super.onInit(texturePool);
        this.mProgressPosition = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"progress");
        this.mRatioPosition = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"ratio");
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        if (height != 0) {
            TXCGPUTransitionFilterBase tXCGPUTransitionFilterBase = this;
            tXCGPUTransitionFilterBase.setFloatOnDraw(tXCGPUTransitionFilterBase.mRatioPosition, (float)width * 1.0f / (float)height);
        }
    }
}

