/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.datereport;

import com.tencent.liteav.base.datareport.Event4XReporter;
import com.tencent.liteav.base.system.LiteavSystemInfo;

public class UGCDataReport {
    private static UGCDataReport sInstance;
    private final Event4XReporter mDAUReporter;
    private String mNetType = Integer.toString(LiteavSystemInfo.getNetworkType());
    private String mDevId = LiteavSystemInfo.getDeviceUuid();
    private String mDevUUID = LiteavSystemInfo.getDeviceUuid();
    private String mPkgName = LiteavSystemInfo.getAppPackageName();
    private String mAppName = LiteavSystemInfo.getAppName() + ":" + this.mPkgName;
    private String mSystemVersion = String.valueOf(LiteavSystemInfo.getSystemOSVersionInt());

    public static synchronized void reportDAU(int eventId) {
        UGCDataReport.getInstance().reportDAUImpl(eventId, 0, "");
    }

    public static synchronized void reportDAU(int eventId, int errCode, String errInfo) {
        UGCDataReport.getInstance().reportDAUImpl(eventId, errCode, errInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static UGCDataReport getInstance() {
        if (sInstance != null) return sInstance;
        Class<UGCDataReport> clazz = UGCDataReport.class;
        synchronized (UGCDataReport.class) {
            if (sInstance != null) return sInstance;
            sInstance = new UGCDataReport();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private UGCDataReport() {
        this.mDAUReporter = new Event4XReporter(49999, 1004, "", true, 1);
    }

    private void reportDAUImpl(int eventId, int errCode, String errInfo) {
        this.setCommonInfo();
        this.mDAUReporter.reportDau(eventId, errCode, errInfo);
    }

    private void setCommonInfo() {
        if (this.mNetType != null) {
            this.mDAUReporter.setCommonStringValue("net_type", this.mNetType);
        }
        if (this.mDevId != null) {
            this.mDAUReporter.setCommonStringValue("dev_id", this.mDevId);
        }
        if (this.mDevUUID != null) {
            this.mDAUReporter.setCommonStringValue("dev_uuid", this.mDevUUID);
        }
        if (this.mAppName != null) {
            this.mDAUReporter.setCommonStringValue("app_name", this.mAppName);
        }
        if (this.mSystemVersion != null) {
            this.mDAUReporter.setCommonStringValue("sys_version", this.mSystemVersion);
        }
    }
}

