/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services;

import com.ksyun.ks3.services.Ks3ClientConfiguration;
import com.loopj.android.http.SyncHttpClient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SyncHttpClientFactory {
    private static SyncHttpClient instance;

    private SyncHttpClientFactory() {
    }

    static SyncHttpClient getInstance() {
        if (instance == null) {
            instance = new SyncHttpClient();
        }
        return instance;
    }

    static SyncHttpClient getInstance(Ks3ClientConfiguration configuration) {
        if (instance == null) {
            instance = new SyncHttpClient();
            instance.setConnectTimeout(configuration.getConnectionTimeout());
            instance.setTimeout(configuration.getSocketTimeout());
            instance.setUserAgent(configuration.getUserAgent());
            instance.setMaxConnections(configuration.getMaxConnections());
            instance.setMaxRetriesAndTimeout(configuration.getMaxRetrytime(), configuration.getRetryTimeOut());
            if (configuration.getProxyUsername() != null && configuration.getProxyPort() > 0) {
                instance.setProxy(configuration.getProxyHost(), configuration.getProxyPort(), configuration.getProxyUsername(), configuration.getProxyPassword());
            }
            instance.setSSLSocketFactory(configuration.getSSLSocketFactory());
        }
        return instance;
    }

    private static ExecutorService getDefaultThreadPool() {
        return Executors.newCachedThreadPool();
    }
}

