/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.content.Context;
import android.content.SharedPreferences;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.FinLog;

public class RongRTCSessionManager {
    private final String TAG = "RongRTCSessionManager";
    private static final String RONGRTC_SETTIONS = "RONGRTC_SETTIONS";
    private static SharedPreferences sharedPreferences;
    private static final RongRTCSessionManager sessionManager;

    public static RongRTCSessionManager getInstance() {
        return sessionManager;
    }

    public synchronized void init(Context context) {
        if (sharedPreferences == null) {
            sharedPreferences = context.getSharedPreferences(RONGRTC_SETTIONS, 0);
        }
    }

    public String put(String key, String value) {
        this.inspect();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.commit();
        return value;
    }

    public long put(String key, Long value) {
        this.inspect();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(key, value.longValue());
        editor.commit();
        return value;
    }

    public boolean put(String key, Boolean value) {
        this.inspect();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(key, value.booleanValue());
        editor.commit();
        return value;
    }

    public String getString(String key) {
        this.inspect();
        FinLog.v("RongRTCSessionManager", "getString with key == " + key + "  &result == " + sharedPreferences.getString(key, ""));
        return sharedPreferences.getString(key, "");
    }

    public Boolean getBoolean(String key) {
        this.inspect();
        return sharedPreferences.getBoolean(key, false);
    }

    public Long getLong(String key) {
        this.inspect();
        return sharedPreferences.getLong(key, 0L);
    }

    public void putInt(String key, int value) {
        this.inspect();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public void putString(String key, String value) {
        this.inspect();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public void putFloat(String key, float value) {
        this.inspect();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putFloat(key, value);
        editor.commit();
    }

    public void putBool(String key, boolean value) {
        this.inspect();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public int getInt(String key, int defaultValue) {
        this.inspect();
        return sharedPreferences.getInt(key, defaultValue);
    }

    public String getString(String key, String defaultValue) {
        this.inspect();
        return sharedPreferences.getString(key, defaultValue);
    }

    public float getFloat(String key, float defaultValue) {
        this.inspect();
        return sharedPreferences.getFloat(key, defaultValue);
    }

    public boolean getBool(String key, boolean defaultValue) {
        this.inspect();
        return sharedPreferences.getBoolean(key, defaultValue);
    }

    public void clear() {
        sharedPreferences.edit().clear();
        sharedPreferences.edit().commit();
    }

    private void inspect() {
        if (sharedPreferences == null && RTCEngineImpl.getInstance().getContext() != null) {
            sharedPreferences = RTCEngineImpl.getInstance().getContext().getSharedPreferences(RONGRTC_SETTIONS, 0);
        }
    }

    static {
        sessionManager = new RongRTCSessionManager();
    }
}

