/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.stream;

import android.graphics.SurfaceTexture;
import cn.rongcloud.rtc.api.RCRTCVideoStream;
import cn.rongcloud.rtc.api.stream.view.RCRTCBaseView;
import cn.rongcloud.rtc.api.stream.view.RCRTCRender;
import cn.rongcloud.rtc.api.stream.view.RCRTCRendererEventsListener;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.core.VideoFrame;
import java.util.concurrent.CountDownLatch;

public class RCRTCTextureView
implements RCRTCBaseView {
    private final Object layoutLock = new Object();
    private boolean isInitialized;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private int frameRotation;
    private TextureRendererEvents textureRendererEvents;
    private RCRTCRender renderer;
    private boolean mirrorHasSet = false;
    private SurfaceTexture texture;

    @Override
    public void setRendererEventsListener(RCRTCRendererEventsListener listener) {
        this.renderer.setRendererEventsListener(listener);
    }

    @Override
    public void setMirror(boolean mirror) {
        this.renderer.setMirror(mirror);
        this.mirrorHasSet = true;
    }

    public void setMirrorInternal(boolean mirror) {
        if (!this.mirrorHasSet) {
            this.renderer.setMirror(mirror);
        }
    }

    @Override
    public void setScalingType(RendererCommon.ScalingType mode) {
        this.renderer.setScalingType(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        Object object = this.layoutLock;
        synchronized (object) {
            if ((this.rotatedFrameWidth != videoWidth || this.rotatedFrameHeight != videoHeight || this.frameRotation != rotation) && this.texture != null) {
                this.rotatedFrameWidth = videoWidth;
                this.rotatedFrameHeight = videoHeight;
                this.frameRotation = rotation;
                this.texture.setDefaultBufferSize(this.rotatedFrameWidth, this.rotatedFrameHeight);
            }
        }
        if (this.textureRendererEvents != null) {
            this.textureRendererEvents.onFrameSizeChanged(this.rotatedFrameWidth, this.rotatedFrameHeight, this.frameRotation);
        }
    }

    @Override
    public void release() {
        this.renderer.release();
        this.isInitialized = false;
    }

    public RCRTCTextureView(String name) {
        this.renderer = new RCRTCRender(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(EglBase.Context context, RCRTCVideoStream videoStream) {
        ThreadUtils.checkIsOnMainThread();
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        Object object = this.layoutLock;
        synchronized (object) {
            this.rotatedFrameWidth = 0;
            this.rotatedFrameHeight = 0;
            this.frameRotation = -1;
        }
        this.renderer.init(context, videoStream);
    }

    @Deprecated
    public void registerTextureRendererEvents(TextureRendererEvents textureRendererEvents) {
        this.textureRendererEvents = textureRendererEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.texture == null) {
                return;
            }
        }
        this.onFrameResolutionChanged(frame.getRotatedWidth(), frame.getRotatedHeight(), frame.getRotation());
        this.renderer.onFrame(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceCreated(SurfaceTexture texture) {
        ThreadUtils.checkIsOnMainThread();
        Object object = this.layoutLock;
        synchronized (object) {
            this.texture = texture;
        }
        this.renderer.createEglSurface(texture);
    }

    public void surfaceDestroyed() {
        ThreadUtils.checkIsOnMainThread();
        final CountDownLatch completionLatch = new CountDownLatch(1);
        this.renderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                completionLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(completionLatch);
    }

    @Deprecated
    public static interface TextureRendererEvents {
        public void onFrameSizeChanged(int var1, int var2, int var3);
    }
}

