/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.opengl.Matrix;
import android.util.Log;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCVideoOutputFrameListener;
import cn.rongcloud.rtc.api.callback.IRCRTCVideoSource;
import cn.rongcloud.rtc.api.stream.RCRTCCameraOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCTextureView;
import cn.rongcloud.rtc.api.stream.RCRTCVideoFrameType;
import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.api.stream.RCRTCVideoView;
import cn.rongcloud.rtc.api.stream.view.RCRTCBaseView;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCRect;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCVideoFrame;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.config.RCConfigDefaultValues;
import cn.rongcloud.rtc.center.config.RCVideoConfigImpl;
import cn.rongcloud.rtc.center.stream.RCDefaultStream;
import cn.rongcloud.rtc.center.stream.RCTinyVideoOutStream;
import cn.rongcloud.rtc.center.stream.RCVideoOutStreamImpl;
import cn.rongcloud.rtc.core.CameraVideoCapturer;
import cn.rongcloud.rtc.core.JavaRGBABuffer;
import cn.rongcloud.rtc.core.NV21Buffer;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.TextureBufferImpl;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoSourceObserver;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.module.camera.CameraManager;
import cn.rongcloud.rtc.plugin.FaceBeautifierPlugin;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.TempFile;
import java.util.Map;

public class RCCameraOutputStreamImpl
extends RCVideoOutStreamImpl
implements RCRTCCameraOutputStream,
RCDefaultStream {
    private static final String TAG = "RCCameraOutputStreamImpl";
    protected RCRTCVideoStreamConfig tinyVideoStreamConfig = RCRTCVideoStreamConfig.Builder.create().setMinRate(RCConfigDefaultValues.VIDEO_RESOLUTION_TINY.getMinBitRate()).setMaxRate(RCConfigDefaultValues.VIDEO_RESOLUTION_TINY.getMaxBitRate()).setVideoFps(RCConfigDefaultValues.VIDEO_FPS).setVideoResolution(RCConfigDefaultValues.VIDEO_RESOLUTION_TINY).build();
    private CameraManager mCameraManager;
    private boolean mPreviewMirror = true;
    private boolean mEncoderMirror = false;
    private IRCRTCVideoOutputFrameListener mVideoFrameListener;
    private RCRTCVideoFrame mVideoFrame;
    private NV21Buffer nv21Buffer;
    private RCTinyVideoOutStream mTinyVideoOutStream;
    private FaceBeautifierPlugin mBeautyPlugin;
    private RCRTCVideoFrameType frameType = RCRTCVideoFrameType.NV21;
    private TempFile tempFile;

    public RCCameraOutputStreamImpl(String userId, CameraManager cameraManager) {
        super("RongCloudRTC", userId);
        this.mCameraManager = cameraManager;
        this.mCameraManager.setCaptureObserver(this);
        this.setResourceState(RCRTCResourceState.DISABLED);
    }

    public void setBeautyPlugin(FaceBeautifierPlugin beautyPlugin) {
        this.mBeautyPlugin = beautyPlugin;
    }

    @Override
    public void startCamera(final IRCRTCResultDataCallback<Boolean> cameraCallback) {
        ReportUtil.appTask(ReportUtil.TAG.STARTCAPTURE, "cameraId", -1);
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager == null) {
            ReportUtil.appError(ReportUtil.TAG.STARTCAPTURE, RTCErrorCode.CAMERA_IS_RELEASED);
            RTCEngineImpl.getInstance().onFailedCallback(RTCErrorCode.CAMERA_IS_RELEASED, cameraCallback);
            return;
        }
        cameraManager.startCamera(this.getHeight(), this.getWidth(), this.getVideoFps().getFps(), new IRCRTCResultDataCallback<Boolean>(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.STARTCAPTURE, errorCode);
                RTCEngineImpl.getInstance().onFailedCallback(errorCode, cameraCallback);
            }

            @Override
            public void onSuccess(Boolean isFrontCamera) {
                ReportUtil.appRes(ReportUtil.TAG.STARTCAPTURE, "isFront", isFrontCamera);
                RCCameraOutputStreamImpl.this.interiorSetPreviewMirror(isFrontCamera);
                RTCEngineImpl.getInstance().sendModifyResourceToMediaServer(false);
                RTCEngineImpl.getInstance().modifyResource(RCCameraOutputStreamImpl.this, false);
                RTCEngineImpl.getInstance().onSuccessCallback(isFrontCamera, cameraCallback);
            }
        });
        if (this.mBeautyPlugin != null) {
            this.mBeautyPlugin.start();
        }
    }

    @Override
    public synchronized void mute(boolean mute) {
        super.mute(mute);
        RCTinyVideoOutStream tinyVideoOutStream = this.mTinyVideoOutStream;
        if (tinyVideoOutStream != null) {
            tinyVideoOutStream.mute(mute);
        }
    }

    @Override
    public void startCamera(int cameraId, boolean mirror, final IRCRTCResultDataCallback<Boolean> cameraCallback) {
        ReportUtil.appTask(ReportUtil.TAG.STARTCAPTURE, "cameraId|mirror", cameraId, mirror);
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager == null) {
            ReportUtil.appError(ReportUtil.TAG.STARTCAPTURE, RTCErrorCode.CAMERA_IS_RELEASED);
            RTCEngineImpl.getInstance().onFailedCallback(RTCErrorCode.CAMERA_IS_RELEASED, cameraCallback);
            return;
        }
        this.setPreviewMirror(mirror);
        cameraManager.startCamera(cameraId, this.getHeight(), this.getWidth(), this.getVideoFps().getFps(), new IRCRTCResultDataCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean isFrontCamera) {
                ReportUtil.appRes(ReportUtil.TAG.STARTCAPTURE, "isFront", isFrontCamera);
                RTCEngineImpl.getInstance().onSuccessCallback(isFrontCamera, cameraCallback);
                RCCameraOutputStreamImpl.this.interiorSetPreviewMirror(isFrontCamera);
                RTCEngineImpl.getInstance().sendModifyResourceToMediaServer(false);
                RTCEngineImpl.getInstance().modifyResource(RCCameraOutputStreamImpl.this, false);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.STARTCAPTURE, errorCode);
                RTCEngineImpl.getInstance().onFailedCallback(errorCode, cameraCallback);
            }
        });
        if (this.mBeautyPlugin != null) {
            this.mBeautyPlugin.start();
        }
    }

    @Override
    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler handler) {
        ReportUtil.appTask(ReportUtil.TAG.SWITCHCAMERA, "cameraId", -1);
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            cameraManager.switchCamera(this.createCameraSwitchHandler(handler));
        } else {
            ReportUtil.appError(ReportUtil.TAG.SWITCHCAMERA, RTCErrorCode.CAMERA_IS_RELEASED);
            if (handler != null) {
                RTCEngineImpl.getInstance().postCallback(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCameraSwitchError(RTCErrorCode.CAMERA_IS_RELEASED.getReason());
                    }
                });
            }
        }
    }

    @Override
    public void switchCamera(int cameraId, boolean mirror, final CameraVideoCapturer.CameraSwitchHandler handler) {
        ReportUtil.appTask(ReportUtil.TAG.SWITCHCAMERA, "cameraId", -1);
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            cameraManager.switchCamera(cameraId, mirror, this.createCameraSwitchHandler(handler));
        } else {
            ReportUtil.appError(ReportUtil.TAG.SWITCHCAMERA, RTCErrorCode.CAMERA_IS_RELEASED);
            if (handler != null) {
                RTCEngineImpl.getInstance().postCallback(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCameraSwitchError(RTCErrorCode.CAMERA_IS_RELEASED.getReason());
                    }
                });
            }
        }
    }

    private CameraVideoCapturer.CameraSwitchHandler createCameraSwitchHandler(final CameraVideoCapturer.CameraSwitchHandler handler) {
        return new CameraVideoCapturer.CameraSwitchHandler(){

            @Override
            public void onCameraSwitchDone(final boolean isFrontCamera) {
                ReportUtil.appRes(ReportUtil.TAG.SWITCHCAMERA, "code|isFront", 0, isFrontCamera);
                if (handler != null) {
                    RTCEngineImpl.getInstance().postCallback(new Runnable(){

                        @Override
                        public void run() {
                            handler.onCameraSwitchDone(isFrontCamera);
                        }
                    });
                }
                RCCameraOutputStreamImpl.this.interiorSetPreviewMirror(isFrontCamera);
            }

            @Override
            public void onCameraSwitchError(final String errorDescription) {
                ReportUtil.appError(ReportUtil.TAG.SWITCHCAMERA, "code|desc", RTCErrorCode.UnknownError.getValue(), errorDescription);
                if (handler != null) {
                    RTCEngineImpl.getInstance().postCallback(new Runnable(){

                        @Override
                        public void run() {
                            handler.onCameraSwitchError(errorDescription);
                        }
                    });
                }
            }
        };
    }

    @Override
    public void stopCamera() {
        this.stopCamera(null);
    }

    @Override
    public void stopCamera(IRCRTCResultCallback cameraCallback) {
        ReportUtil.appTask(ReportUtil.TAG.STOPCAPTURE, "disable", true);
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            cameraManager.stopCamera(cameraCallback);
            RTCEngineImpl.getInstance().sendModifyResourceToMediaServer(true);
            RTCEngineImpl.getInstance().modifyResource(this, true);
            ReportUtil.appRes(ReportUtil.TAG.STOPCAPTURE, "code", 0);
        } else {
            if (cameraCallback != null) {
                cameraCallback.onFailed(RTCErrorCode.CAMERA_IS_RELEASED);
            }
            ReportUtil.appError(ReportUtil.TAG.STOPCAPTURE, "code|desc", RTCErrorCode.CAMERA_IS_RELEASED.getValue(), RTCErrorCode.CAMERA_IS_RELEASED.getReason());
        }
        if (this.mBeautyPlugin != null) {
            this.mBeautyPlugin.stop();
        }
    }

    @Override
    public void setVideoFrameListener(IRCRTCVideoOutputFrameListener videoFrameListener) {
        this.mVideoFrameListener = videoFrameListener;
    }

    @Override
    public boolean setWatermark(Bitmap logoIcon, RCRTCRect rect) {
        boolean ret = super.setWatermark(logoIcon, rect);
        return ret;
    }

    @Override
    public synchronized void setVideoView(RCRTCBaseView videoView) {
        super.setVideoView(videoView);
        this.interiorSetPreviewMirror(this.mPreviewMirror);
    }

    private void interiorSetPreviewMirror(boolean mirror) {
        RCRTCBaseView videoView = this.mVideoView;
        if (videoView instanceof RCRTCVideoView) {
            ((RCRTCVideoView)videoView).setMirrorInternal(mirror && this.mPreviewMirror);
        } else if (videoView instanceof RCRTCTextureView) {
            ((RCRTCTextureView)videoView).setMirrorInternal(mirror && this.mPreviewMirror);
        } else if (videoView != null) {
            videoView.setMirror(mirror && this.mPreviewMirror);
        }
    }

    @Override
    public boolean isPreviewMirror() {
        return this.mPreviewMirror;
    }

    @Override
    public void setPreviewMirror(boolean mirror) {
        ReportUtil.appStatus(ReportUtil.TAG.SETCAMERAPREVIEWMIRROR, "mirror", mirror);
        this.mPreviewMirror = mirror;
        this.interiorSetPreviewMirror(mirror);
    }

    @Override
    public boolean isEncoderMirror() {
        return this.mEncoderMirror;
    }

    @Override
    public void setEncoderMirror(boolean mirror) {
        this.mEncoderMirror = mirror;
    }

    @Override
    public void setVideoConfig(RCRTCVideoStreamConfig config) {
        RCRTCParamsType.RCRTCVideoResolution currentResolution = this.videoStreamConfig.getVideoResolution();
        RCRTCParamsType.RCRTCVideoFps currentFps = this.videoStreamConfig.getVideoFps();
        if (config == null || this.videoStreamConfig.equalsEx(config)) {
            String msg = "RCRTCVideoStreamConfig is null or is the same with previous settings";
            ReportUtil.appError(ReportUtil.TAG.SETVIDEOCONFIG, "config", msg);
            return;
        }
        super.setVideoConfig(config);
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null && this.isCapturing() && (currentResolution.getHeight() < this.getHeight() || currentResolution.getWidth() < this.getWidth()) || currentFps != this.getVideoFps()) {
            cameraManager.restartCamera(this.getHeight(), this.getWidth(), this.getVideoFps().getFps());
        }
        RTCEngineImpl.getInstance().changeVideoSize();
    }

    public boolean isCapturing() {
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            return cameraManager.isCapturing();
        }
        return false;
    }

    @Override
    public void setCameraDisplayOrientation(int orientation) {
        ReportUtil.appTask(ReportUtil.TAG.SETCAMERADISPLAYORIENTATION, "orientation", orientation);
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            cameraManager.setCameraDisplayOrientation(orientation);
            ReportUtil.appRes(ReportUtil.TAG.SETCAMERADISPLAYORIENTATION, "code", 0);
        } else {
            ReportUtil.appError(ReportUtil.TAG.SETCAMERADISPLAYORIENTATION, RTCErrorCode.CAMERA_IS_RELEASED);
        }
    }

    @Override
    public void setFrameOrientation(int orientation) {
        ReportUtil.appTask(ReportUtil.TAG.SETFRAMEORIENTATION, "orientation", orientation);
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            cameraManager.setFrameOrientation(orientation);
            ReportUtil.appRes(ReportUtil.TAG.SETFRAMEORIENTATION, "code", 0);
        } else {
            ReportUtil.appError(ReportUtil.TAG.SETFRAMEORIENTATION, RTCErrorCode.CAMERA_IS_RELEASED);
        }
    }

    @Override
    public final void setSource(IRCRTCVideoSource source) {
    }

    @Override
    public boolean isFrontCamera() {
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            return cameraManager.isFrontCamera();
        }
        return false;
    }

    @Override
    public void enableTinyStream(boolean enable) {
        ReportUtil.appOperate(ReportUtil.TAG.ENABLETINYSTREAM, "enbale", enable);
        RTCEngineImpl.getInstance().setEnableTinyStream(enable);
    }

    @Override
    public boolean setTinyVideoConfig(RCRTCVideoStreamConfig config) {
        ReportUtil.libStatus(ReportUtil.TAG.SETTINYVIDEOCONFIG, "config", config == null ? "null" : ((RCVideoConfigImpl)config).formatLogString());
        RCRTCParamsType.RCRTCVideoResolution currentResolution = this.tinyVideoStreamConfig.getVideoResolution();
        if (config == null || config.getVideoResolution() == currentResolution && config.getVideoFps() == this.videoStreamConfig.getVideoFps()) {
            String msg = "RCRTCVideoStreamConfig is null or is the same with previous settings";
            ReportUtil.libError(ReportUtil.TAG.SETTINYVIDEOCONFIG, "config", msg);
            return false;
        }
        this.tinyVideoStreamConfig = config;
        if (this.mTinyVideoOutStream != null) {
            this.mTinyVideoOutStream.setVideoConfig(config);
        }
        return true;
    }

    @Override
    public RCRTCVideoStreamConfig getTinyVideoConfig() {
        return this.tinyVideoStreamConfig;
    }

    @Override
    public boolean isCameraFocusSupported() {
        CameraManager caameraManager = this.mCameraManager;
        if (caameraManager != null) {
            return caameraManager.isCameraFocusSupported();
        }
        return false;
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            return cameraManager.isCameraExposurePositionSupported();
        }
        return false;
    }

    @Override
    public boolean setCameraExposurePositionInPreview(float x, float y) {
        ReportUtil.appTask(ReportUtil.TAG.SETCAMERAEXPOSUREPOSITIONINPREVIEW, "x|y", Float.valueOf(x), Float.valueOf(y));
        boolean flag = false;
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            flag = cameraManager.setCameraExposurePositionInPreview(x, y);
        }
        if (flag) {
            ReportUtil.appRes(ReportUtil.TAG.SETCAMERAEXPOSUREPOSITIONINPREVIEW, "code", 0);
        } else {
            ReportUtil.appError(ReportUtil.TAG.SETCAMERAEXPOSUREPOSITIONINPREVIEW, RTCErrorCode.CAMERA_IS_RELEASED);
        }
        return flag;
    }

    @Override
    public boolean setCameraFocusPositionInPreview(float x, float y) {
        ReportUtil.appTask(ReportUtil.TAG.SETCAMERAFOCUSPOSITIONINPREVIEW, "x|y", Float.valueOf(x), Float.valueOf(y));
        boolean flag = false;
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            flag = cameraManager.setCameraFocusPositionInPreview(x, y);
        }
        if (flag) {
            ReportUtil.appRes(ReportUtil.TAG.SETCAMERAFOCUSPOSITIONINPREVIEW, "code", 0);
        } else {
            ReportUtil.appError(ReportUtil.TAG.SETCAMERAFOCUSPOSITIONINPREVIEW, RTCErrorCode.CAMERA_IS_RELEASED);
        }
        return flag;
    }

    @Override
    public boolean isCameraTorchSupported() {
        CameraManager cameraManager = this.mCameraManager;
        return cameraManager != null && cameraManager.isCameraTorchSupported();
    }

    @Override
    public boolean isCameraZoomSupported() {
        CameraManager cameraManager = this.mCameraManager;
        return cameraManager != null && cameraManager.isCameraZoomSupported();
    }

    @Override
    public float getCameraMaxZoomFactor() {
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            return cameraManager.getCameraMaxZoomFactor();
        }
        return -1.0f;
    }

    @Override
    public boolean setCustomizedCameraParameter(Map<String, String> parameter) {
        CameraManager cameraManager = this.mCameraManager;
        return cameraManager != null && cameraManager.setCameraParameter(parameter);
    }

    @Override
    public boolean enableCameraTorch(boolean enable) {
        ReportUtil.appOperate(ReportUtil.TAG.SETCAMERAPARAMS, "key|value", "flash-mode", enable);
        CameraManager cameraManager = this.mCameraManager;
        return cameraManager != null && cameraManager.enableCameraTorch(enable);
    }

    @Override
    public boolean setCameraZoomFactor(float zoomFactor) {
        ReportUtil.appOperate(ReportUtil.TAG.SETCAMERAPARAMS, "key|value", "zoom", Float.valueOf(zoomFactor));
        CameraManager cameraManager = this.mCameraManager;
        return cameraManager != null && cameraManager.setCameraZoomFactor(zoomFactor);
    }

    @Override
    public boolean isPreserved() {
        return true;
    }

    @Override
    public void release() {
        super.release();
        this.resetStream();
        if (this.mCameraManager != null) {
            this.mCameraManager.release();
            this.mCameraManager = null;
        }
        this.track = null;
    }

    @Override
    public void resetStream() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.mVideoFrameListener = null;
        this.mTinyVideoOutStream = null;
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            cameraManager.stopCamera(null);
        }
    }

    public void switchToAudienceResetStream() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.mTinyVideoOutStream = null;
        this.mVideoFrameListener = null;
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            cameraManager.stopCamera(null);
        }
    }

    @Override
    public void onCapturerStarted(boolean success) {
        super.onCapturerStarted(success);
        RCTinyVideoOutStream tinyVideo = this.mTinyVideoOutStream;
        if (tinyVideo != null) {
            tinyVideo.onCapturerStarted(success);
        }
    }

    @Override
    public void onCapturerStopped() {
        super.onCapturerStopped();
        RCTinyVideoOutStream tinyVideo = this.mTinyVideoOutStream;
        if (tinyVideo != null) {
            tinyVideo.onCapturerStopped();
        }
    }

    @Override
    public void onFrameCaptured(VideoFrame frame) {
        frame.setMirror(this.mEncoderMirror);
        this.onProcessVideoFrame(this.mVideoFrameListener, frame);
        VideoSourceObserver observer = this.mVideoObserver;
        if (observer != null) {
            observer.onFrameCaptured(frame);
        }
    }

    private void onProcessVideoFrame(IRCRTCVideoOutputFrameListener videoFrameListener, VideoFrame frame) {
        if (videoFrameListener == null && this.mBeautyPlugin == null) {
            return;
        }
        if (frame.getBuffer() instanceof TextureBufferImpl) {
            this.frameType = RCRTCVideoFrameType.OES;
            this.processTextureFrameBuffer(videoFrameListener, (TextureBufferImpl)frame.getBuffer(), frame.getRotation(), frame.getTimestampNs());
        } else if (frame.getBuffer() instanceof NV21Buffer) {
            this.frameType = RCRTCVideoFrameType.NV21;
            VideoFrame.Buffer processBuffer = this.processByteFrameBuffer(videoFrameListener, (NV21Buffer)frame.getBuffer(), frame.getRotation(), frame.getTimestampNs());
            frame.setBuffer(processBuffer);
        }
    }

    private void processTextureFrameBuffer(IRCRTCVideoOutputFrameListener listener, TextureBufferImpl textureBuffer, int rotation, long timeStamp) {
        if (textureBuffer == null) {
            FinLog.e(TAG, "TextureBufferImpl is empty !");
            return;
        }
        if (this.mVideoFrame == null) {
            this.mVideoFrame = new RCRTCVideoFrame();
        }
        if (this.frameType == RCRTCVideoFrameType.TEXTURE2D) {
            int rgbTextureId = this.oes2rgbTexture(textureBuffer.getWidth(), textureBuffer.getHeight(), textureBuffer.getTextureId(), textureBuffer.getOriginalMatrix());
            this.mVideoFrame.setTextureId(rgbTextureId);
            this.mVideoFrame.setTextureType(RCRTCVideoFrame.Type.RGB);
        } else if (this.frameType == RCRTCVideoFrameType.OES) {
            this.mVideoFrame.setTextureId(textureBuffer.getTextureId());
            this.mVideoFrame.setTextureType(RCRTCVideoFrame.Type.OES);
        }
        this.mVideoFrame.setWidth(textureBuffer.getWidth());
        this.mVideoFrame.setHeight(textureBuffer.getHeight());
        this.mVideoFrame.setRotation(rotation);
        this.mVideoFrame.setTimestamp(timeStamp);
        this.mVideoFrame.setTransformMatrix(textureBuffer.getOriginalMatrix());
        RCRTCVideoFrame tmpVideoFrame = this.otherProcessFrame(this.mVideoFrame, this.frameType, listener);
        if (tmpVideoFrame != null) {
            if (tmpVideoFrame.getTextureType() == RCRTCVideoFrame.Type.RGB) {
                Matrix.setIdentityM((float[])textureBuffer.getOriginalMatrix(), (int)0);
                textureBuffer.setTransformMatrix(RendererCommon.convertMatrixToAndroidGraphicsMatrix(textureBuffer.getOriginalMatrix()));
                textureBuffer.setType(VideoFrame.TextureBuffer.Type.RGB);
            } else {
                textureBuffer.setType(VideoFrame.TextureBuffer.Type.OES);
            }
            textureBuffer.setTextureId(tmpVideoFrame.getTextureId());
        }
    }

    @SuppressLint(value={"LongLogTag"})
    private VideoFrame.Buffer processByteFrameBuffer(IRCRTCVideoOutputFrameListener listener, NV21Buffer nv21Buffer, int rotation, long timeStamp) {
        if (nv21Buffer == null) {
            FinLog.e(TAG, "NV21Buffer is empty !");
            return null;
        }
        if (this.mVideoFrame == null) {
            this.mVideoFrame = new RCRTCVideoFrame();
        }
        this.mVideoFrame.setTextureId(-1);
        if (this.frameType == RCRTCVideoFrameType.NV21) {
            this.mVideoFrame.setData(nv21Buffer.getData());
            this.mVideoFrame.setWidth(nv21Buffer.getWidth());
            this.mVideoFrame.setHeight(nv21Buffer.getHeight());
            this.mVideoFrame.setRotation(rotation);
            this.mVideoFrame.setTimestamp(timeStamp);
            RCRTCVideoFrame tmpVideoFrame = this.otherProcessFrame(this.mVideoFrame, RCRTCVideoFrameType.NV21, listener);
            if (tmpVideoFrame != null) {
                nv21Buffer.setData(tmpVideoFrame.getData());
            }
            return nv21Buffer;
        }
        if (this.frameType == RCRTCVideoFrameType.I420) {
            VideoFrame.I420Buffer i420Buffer = nv21Buffer.toI420();
            this.mVideoFrame.setData(i420Buffer.getData());
            this.mVideoFrame.setWidth(nv21Buffer.getWidth());
            this.mVideoFrame.setHeight(nv21Buffer.getHeight());
            this.mVideoFrame.setRotation(rotation);
            this.mVideoFrame.setTimestamp(timeStamp);
            RCRTCVideoFrame tmpVideoFrame = this.otherProcessFrame(this.mVideoFrame, RCRTCVideoFrameType.I420, listener);
            if (tmpVideoFrame != null) {
                i420Buffer.updateData(tmpVideoFrame.getData());
                nv21Buffer.release();
            } else {
                i420Buffer.release();
                Log.w((String)TAG, (String)"processByteFrameBuffer: process result is null");
            }
            return i420Buffer;
        }
        if (this.frameType == RCRTCVideoFrameType.RGBA) {
            JavaRGBABuffer javaRGBABuffer = nv21Buffer.toRGBA();
            nv21Buffer.release();
            this.mVideoFrame.setData(javaRGBABuffer.getData());
            this.mVideoFrame.setWidth(nv21Buffer.getWidth());
            this.mVideoFrame.setHeight(nv21Buffer.getHeight());
            this.mVideoFrame.setRotation(rotation);
            this.mVideoFrame.setTimestamp(timeStamp);
            RCRTCVideoFrame tmpVideoFrame = this.otherProcessFrame(this.mVideoFrame, RCRTCVideoFrameType.RGBA, listener);
            JavaRGBABuffer processedBuf = JavaRGBABuffer.wrapFromData(tmpVideoFrame.getWidth(), tmpVideoFrame.getHeight(), tmpVideoFrame.getData());
            VideoFrame.I420Buffer processedI420Buf = processedBuf.toI420();
            javaRGBABuffer.release();
            processedBuf.release();
            return processedI420Buf;
        }
        return null;
    }

    @SuppressLint(value={"LongLogTag"})
    private RCRTCVideoFrame otherProcessFrame(RCRTCVideoFrame videoFrame, RCRTCVideoFrameType type, IRCRTCVideoOutputFrameListener listener) {
        if (this.mBeautyPlugin != null) {
            this.mBeautyPlugin.processFrame(videoFrame, type, this.isFrontCamera() ? 1 : 0);
        }
        if (listener != null || this.getStreamEventListener() != null) {
            RCRTCVideoFrame resultFrame;
            if (type == RCRTCVideoFrameType.OES && videoFrame.getTextureType() == RCRTCVideoFrame.Type.OES) {
                int rgbTextureId = this.oes2rgbTexture(videoFrame.getWidth(), videoFrame.getHeight(), videoFrame.getTextureId(), videoFrame.getTransformMatrix());
                videoFrame.setTextureId(rgbTextureId);
                videoFrame.setTextureType(RCRTCVideoFrame.Type.RGB);
            }
            if (listener != null) {
                return listener.processVideoFrame(videoFrame);
            }
            if (this.getStreamEventListener() != null && (resultFrame = this.getStreamEventListener().onCaptureFrame(this, videoFrame)) != null) {
                videoFrame = resultFrame;
            }
        }
        return videoFrame;
    }

    private RCRTCVideoStreamConfig genTinyStreamConfig() {
        if (this.tinyVideoStreamConfig == null) {
            RCRTCParamsType.RCRTCVideoResolution tinyResolution = this.ginTinyResolution(this.videoStreamConfig.getVideoResolution());
            return RCRTCVideoStreamConfig.Builder.create().setVideoResolution(tinyResolution).setMaxRate(tinyResolution.getMaxBitRate()).setMinRate(tinyResolution.getMinBitRate()).build();
        }
        return this.tinyVideoStreamConfig;
    }

    private RCRTCParamsType.RCRTCVideoResolution ginTinyResolution(RCRTCParamsType.RCRTCVideoResolution resolution) {
        switch (resolution) {
            case RESOLUTION_144_256: 
            case RESOLUTION_180_320: 
            case RESOLUTION_360_640: 
            case RESOLUTION_480_848: 
            case RESOLUTION_720_1280: 
            case RESOLUTION_1080_1920: {
                return RCRTCParamsType.RCRTCVideoResolution.RESOLUTION_144_256;
            }
            case RESOLUTION_180_240: 
            case RESOLUTION_240_320: 
            case RESOLUTION_360_480: 
            case RESOLUTION_480_640: 
            case RESOLUTION_480_720: 
            case RESOLUTION_720_960: {
                return RCRTCParamsType.RCRTCVideoResolution.RESOLUTION_180_240;
            }
            case RESOLUTION_180_180: 
            case RESOLUTION_240_240: 
            case RESOLUTION_360_360: 
            case RESOLUTION_480_480: {
                return RCRTCParamsType.RCRTCVideoResolution.RESOLUTION_180_180;
            }
        }
        return RCRTCParamsType.RCRTCVideoResolution.RESOLUTION_144_176;
    }

    public RCTinyVideoOutStream getTinyVideoOutStream() {
        return this.mTinyVideoOutStream;
    }

    public void setTinyVideoOutStream(RCTinyVideoOutStream tinyVideoOutStream) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.mTinyVideoOutStream = tinyVideoOutStream;
        if (this.mTinyVideoOutStream != null) {
            this.mTinyVideoOutStream.setResolution(this.genTinyStreamConfig().getVideoResolution());
        }
    }

    @Override
    public void onPreEncodeFrame(VideoFrame frame) {
        RCTinyVideoOutStream tinyVideo = this.mTinyVideoOutStream;
        if (tinyVideo != null) {
            tinyVideo.onFrameCaptured(frame);
        }
        super.onPreEncodeFrame(frame);
    }
}

