/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import android.content.Context;
import android.media.AudioTrack;
import android.os.Build;
import cn.rongcloud.rtc.api.callback.IRCRTCOnStreamSendListener;
import cn.rongcloud.rtc.api.stream.RCRTCFileVideoOutputStream;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCVideoOutStreamImpl;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.custom.MediaAudioDecoder;
import cn.rongcloud.rtc.custom.MediaVideoDecoder;
import cn.rongcloud.rtc.custom.OnFrameAvailableListener;
import cn.rongcloud.rtc.custom.OnPcmAvailableListener;
import cn.rongcloud.rtc.utils.AudioBufferStream;
import cn.rongcloud.rtc.utils.AudioUtil;
import cn.rongcloud.rtc.utils.TimeCorrector;
import java.nio.ByteBuffer;

public class RCFileVideoOutStreamImpl
extends RCVideoOutStreamImpl
implements RCRTCFileVideoOutputStream,
OnFrameAvailableListener,
OnPcmAvailableListener,
OnAudioBufferAvailableListener {
    public static final String VIDEO_TAG = "RongRTCFileVideo";
    private static final int TIME_INTERVAL_MILLIS = 10;
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_START = 2;
    private static final int STATE_RELEASED = 3;
    private MediaVideoDecoder mVideoDecoder;
    private MediaAudioDecoder mAudioDecoder;
    private AudioTrack mAudioTrack;
    private AudioBufferStream mAudioBufferStream;
    private IRCRTCOnStreamSendListener mOnSendListener;
    private String filePath;
    private boolean replace = false;
    private long currentTimestamp;
    private int mState = 0;
    private boolean playback = true;
    private RCMicOutputStreamImpl mDefaultAudioStream;

    public RCFileVideoOutStreamImpl(Context context, String path, boolean replace, boolean playback, String tag, String userId, RCRTCConfigImpl config, RCMicOutputStreamImpl audioOutputStream) {
        super(tag, userId);
        this.filePath = path;
        this.replace = replace;
        this.playback = playback;
        this.mDefaultAudioStream = audioOutputStream;
        this.init(context, replace, config);
    }

    private void init(Context context, boolean replace, RCRTCConfigImpl config) {
        this.replace = replace;
        this.initAudio(context, config);
        this.initVideo(context);
        this.mState = 1;
    }

    private void initVideo(Context context) {
        this.mVideoDecoder = MediaVideoDecoder.create();
        this.mVideoDecoder.init(this.filePath, context);
        this.mVideoDecoder.setFrameListener(this);
    }

    private void initAudio(Context context, RCRTCConfigImpl config) {
        MediaAudioDecoder audioDecoder = new MediaAudioDecoder();
        if (!audioDecoder.init(this.filePath, context)) {
            this.handleError();
            return;
        }
        AudioBufferStream audioBufferStream = new AudioBufferStream(audioDecoder.getSampleRate(), audioDecoder.getChannelCount(), audioDecoder.getAudioFormat(), config.getAudioSampleRate(), config.isStereo() ? 2 : 1, 2);
        audioBufferStream.setOnAudioReadListener(new AudioBufferStream.OnAudioReadListener(){

            @Override
            public void onAudioRead(long currentTimeMillis) {
                RCFileVideoOutStreamImpl.this.currentTimestamp = currentTimeMillis;
            }
        });
        this.mDefaultAudioStream.registerAudioBufferListener(this);
        audioDecoder.setPcmAvailableListener(this);
        this.mAudioDecoder = audioDecoder;
        this.mAudioBufferStream = audioBufferStream;
        this.mAudioTrack = AudioUtil.createAudioTrack(this.mAudioDecoder.getMediaFormat(), 0);
    }

    @Override
    public void onFrame(byte[] bytes, int width, int height, int rotation, long presentationTimeMs) {
        try {
            if (this.mState == 3) {
                return;
            }
            long diff = presentationTimeMs - this.currentTimestamp;
            if (diff >= -25L && diff <= 25L) {
                this.writeYuvData(bytes, width, height, rotation);
            } else {
                if (diff < -25L) {
                    return;
                }
                Thread.sleep(diff);
                this.writeYuvData(bytes, width, height, rotation);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void onFrameEnd() {
        if (this.mAudioDecoder == null) {
            this.interiorRelease();
        }
    }

    @Override
    public void onPcm(byte[] data, long presentationTimeUs) {
        AudioTrack audioTrack;
        AudioBufferStream audioBufferStream = this.mAudioBufferStream;
        if (audioBufferStream != null) {
            audioBufferStream.write(data);
        }
        if ((audioTrack = this.mAudioTrack) != null && this.playback) {
            try {
                if (Build.VERSION.SDK_INT >= 21) {
                    audioTrack.write(ByteBuffer.wrap(data), data.length, 1);
                } else {
                    audioTrack.write(data, 0, data.length);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onPcmEnd() {
        this.interiorRelease();
    }

    @Override
    public void onOneLoopEnd() {
    }

    @Override
    public void onAudioBuffer(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
        AudioBufferStream audioBufferStream = this.mAudioBufferStream;
        if (audioBufferStream == null) {
            return;
        }
        byte[] data = audioBufferStream.read(sizeInBytes / (channelCount * 2));
        if (data == null) {
            return;
        }
        if (this.replace) {
            byteBuffer.clear();
            byteBuffer.put(data);
        } else {
            AudioUtil.mixAsShort(data, byteBuffer);
        }
    }

    public void setPlayback(boolean playback) {
        this.playback = playback;
    }

    @Override
    public void setOnSendListener(IRCRTCOnStreamSendListener onSendListener) {
        this.mOnSendListener = onSendListener;
    }

    private void handleError() {
        if (this.mOnSendListener != null) {
            this.mOnSendListener.onFailed();
        }
    }

    @Override
    public synchronized void start() {
        super.start();
        this.startDecode();
    }

    private void startDecode() {
        if (this.mState != 1) {
            this.handleError();
            return;
        }
        this.mState = 2;
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.start();
        }
        if (this.mAudioDecoder != null) {
            this.mAudioDecoder.start();
        } else {
            new Thread(){

                @Override
                public void run() {
                    TimeCorrector timeCorrector = new TimeCorrector(10L);
                    while (!2.interrupted() && RCFileVideoOutStreamImpl.this.mState == 2) {
                        RCFileVideoOutStreamImpl.this.currentTimestamp = timeCorrector.waitToNextInterval();
                    }
                }
            }.start();
        }
        if (this.mOnSendListener != null) {
            this.mOnSendListener.onStart(this);
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.interiorRelease();
    }

    private synchronized void interiorRelease() {
        if (this.mState == 3 || this.mState == 0) {
            return;
        }
        this.mState = 3;
        if (this.mOnSendListener != null) {
            this.mOnSendListener.onComplete(this);
            this.mOnSendListener = null;
        }
        this.mDefaultAudioStream.unregisterAudioBufferListener(this);
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.stop();
            this.mVideoDecoder = null;
        }
        if (this.mAudioDecoder != null) {
            this.mAudioDecoder.stop();
            this.mAudioDecoder.release();
            this.mAudioDecoder = null;
        }
        if (this.mAudioTrack != null) {
            this.mAudioTrack.pause();
            this.mAudioTrack.flush();
            this.mAudioTrack.release();
        }
        if (this.mAudioBufferStream != null) {
            this.mAudioBufferStream.release();
            this.mAudioBufferStream = null;
        }
    }

    @Override
    public void release() {
        this.interiorRelease();
        super.release();
    }
}

