/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCMixConfig;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.stream.RCRTCLiveInfo;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.ReportUtil;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class RCRTCLiveInfoImpl
implements RCRTCLiveInfo,
Parcelable {
    private static final int CDN_PUSHURL_LIMIT = 5;
    private static final String TAG = "RongRTCLiveInfo";
    private final String roomId;
    private final String liveUrl;
    private final String userId;
    private final String configUrl;
    private CopyOnWriteArrayList<String> mPubStreamUrls;
    public static final Parcelable.Creator<RCRTCLiveInfoImpl> CREATOR = new Parcelable.Creator<RCRTCLiveInfoImpl>(){

        public RCRTCLiveInfoImpl createFromParcel(Parcel source) {
            return new RCRTCLiveInfoImpl(source);
        }

        public RCRTCLiveInfoImpl[] newArray(int size) {
            return new RCRTCLiveInfoImpl[size];
        }
    };

    public RCRTCLiveInfoImpl(String roomId, String liveUrl, String userId, String configUrl) {
        this.roomId = roomId;
        this.liveUrl = liveUrl;
        this.userId = userId;
        this.configUrl = configUrl;
        this.mPubStreamUrls = new CopyOnWriteArrayList();
    }

    @Override
    public String getRoomId() {
        return this.roomId;
    }

    @Override
    public String getLiveUrl() {
        return this.liveUrl;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public String getConfigUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.configUrl) && !this.configUrl.startsWith("http")) {
            return "http://" + this.configUrl;
        }
        return this.configUrl;
    }

    @Override
    public void addPublishStreamUrl(String url, IRCRTCResultDataCallback<String[]> callBack) {
        this.onSetPubStreamUrl(url, true, callBack);
    }

    @Override
    public void enableInnerCDN(boolean enable, final IRCRTCResultCallback callBack) {
        String json = null;
        try {
            JSONObject obj_output = new JSONObject();
            obj_output.putOpt("inCDNModel", (Object)(enable ? 1 : 2));
            JSONObject jsonObject = new JSONObject();
            jsonObject.putOpt("output", (Object)obj_output);
            jsonObject.putOpt("version", (Object)2);
            json = jsonObject.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            ReportUtil.appError(ReportUtil.TAG.ENABLE_INNER_CDN, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), e.getMessage());
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        ReportUtil.appTask(ReportUtil.TAG.ENABLE_INNER_CDN, "roomId|json", this.roomId, json);
        if (TextUtils.isEmpty((CharSequence)json)) {
            ReportUtil.appError(ReportUtil.TAG.ENABLE_INNER_CDN, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), RTCErrorCode.RongRTCCodeParameterError.getReason());
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        RTCEngineImpl.getInstance().sendMessage(5035, this.getConfigUrl(), json, enable, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.ENABLE_INNER_CDN, "roomId", RCRTCLiveInfoImpl.this.roomId);
                if (callBack != null) {
                    callBack.onSuccess();
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.ENABLE_INNER_CDN, "code|desc", errorCode.getValue(), errorCode.getReason());
                if (callBack != null) {
                    callBack.onFailed(errorCode);
                }
            }
        });
    }

    @Override
    public void removePublishStreamUrl(String url, IRCRTCResultDataCallback<String[]> callBack) {
        this.onSetPubStreamUrl(url, false, callBack);
    }

    private void onSetPubStreamUrl(final String url, final boolean isAdd, final IRCRTCResultDataCallback<String[]> callBack) {
        ReportUtil.TAG tag;
        ReportUtil.TAG tAG = tag = isAdd ? ReportUtil.TAG.ADDPUBLISHSTREAMURL : ReportUtil.TAG.REMOVEPUBLISHSTREAMURL;
        if (TextUtils.isEmpty((CharSequence)url)) {
            ReportUtil.appError(tag, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "PubStreamUrl is Null");
            if (callBack != null) {
                callBack.onFailed(this.copyPublishStreamUrlArray(), RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        ReportUtil.appTask(tag, "url", url);
        if (isAdd) {
            if (this.mPubStreamUrls.size() >= 5) {
                ReportUtil.appError(tag, RTCErrorCode.RongRTCCodeCDNCountReachToLimit);
                if (callBack != null) {
                    callBack.onFailed(this.copyPublishStreamUrlArray(), RTCErrorCode.RongRTCCodeCDNCountReachToLimit);
                }
                return;
            }
            this.mPubStreamUrls.add(url);
        } else {
            if (!this.mPubStreamUrls.contains(url)) {
                ReportUtil.appRes(tag, "code|desc", 0, "removePublishStreamUrl Success");
                if (callBack != null) {
                    callBack.onSuccess(this.copyPublishStreamUrlArray());
                }
                return;
            }
            this.mPubStreamUrls.remove(url);
        }
        ArrayList<RCRTCMixConfig.MediaConfig.CDNPushUrl> cdnPushUrls = new ArrayList<RCRTCMixConfig.MediaConfig.CDNPushUrl>(this.mPubStreamUrls.size());
        for (String pUrl : this.mPubStreamUrls) {
            cdnPushUrls.add(new RCRTCMixConfig.MediaConfig.CDNPushUrl(pUrl));
        }
        RCRTCMixConfig config = new RCRTCMixConfig(cdnPushUrls);
        String configJson = new Gson().toJson((Object)config);
        ReportUtil.appStatus(tag, "cdnConfig", configJson);
        this.onRequestMCUConfig(tag, configJson, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(tag, "code|desc", 0, tag.getTag() + " Success");
                if (callBack != null) {
                    callBack.onSuccess(RCRTCLiveInfoImpl.this.copyPublishStreamUrlArray());
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                if (isAdd) {
                    RCRTCLiveInfoImpl.this.mPubStreamUrls.remove(url);
                } else {
                    RCRTCLiveInfoImpl.this.mPubStreamUrls.add(url);
                }
                ReportUtil.appError(tag, errorCode);
                if (callBack != null) {
                    callBack.onFailed(RCRTCLiveInfoImpl.this.copyPublishStreamUrlArray(), errorCode);
                }
            }
        });
    }

    public String[] copyPublishStreamUrlArray() {
        String[] urls = new String[this.mPubStreamUrls.size()];
        return this.mPubStreamUrls.toArray(urls);
    }

    @Override
    public void setMixConfig(RCRTCMixConfig mixConfig, final IRCRTCResultCallback callBack) {
        if (mixConfig == null) {
            ReportUtil.appError(ReportUtil.TAG.SETMIXCONFIG, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "mixConfig or rtcRoom or rtcRoom.getSessionId() is Null");
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        String configJson = new Gson().toJson((Object)mixConfig);
        ReportUtil.appTask(ReportUtil.TAG.SETMIXCONFIG, "roomId|configUrl|config", this.roomId, this.configUrl, configJson);
        this.onRequestMCUConfig(ReportUtil.TAG.SETMIXCONFIG, configJson, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                if (callBack != null) {
                    callBack.onSuccess();
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                if (callBack != null) {
                    callBack.onFailed(errorCode);
                }
            }
        });
    }

    private void onRequestMCUConfig(final ReportUtil.TAG tag, String configJson, final IRCRTCResultCallback callBack) {
        RTCEngineImpl.getInstance().sendMessage(5020, this.getConfigUrl(), configJson, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(tag, RCRTCLiveInfoImpl.this.roomId);
                if (callBack != null) {
                    callBack.onSuccess();
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.SETMIXCONFIG, "code|desc", errorCode.getValue(), errorCode.getReason());
                if (callBack != null) {
                    callBack.onFailed(errorCode);
                }
            }
        });
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.roomId);
        dest.writeString(this.liveUrl);
        dest.writeString(this.userId);
        dest.writeString(this.configUrl);
        dest.writeStringList(this.mPubStreamUrls);
    }

    protected RCRTCLiveInfoImpl(Parcel in) {
        this.roomId = in.readString();
        this.liveUrl = in.readString();
        this.userId = in.readString();
        this.configUrl = in.readString();
        in.readStringList(this.mPubStreamUrls);
    }
}

