/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.center.stream.RCCameraOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCVideoOutStreamImpl;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.RongRTCUtils;

public class RCTinyVideoOutStream
extends RCVideoOutStreamImpl {
    public static final CharSequence TINY = "_tiny";
    private static final int TINT_BASE_SIDE = 132;
    private int mWidth;
    private int mHeight;
    private int minBitrate = 30;
    private int maxBitrate = 120;
    private RCRTCParamsType.RCRTCVideoResolution resolution;

    public RCTinyVideoOutStream(String userId) {
        super("RongCloudRTC" + TINY, userId);
        this.configTinyVideoResolution();
        this.mStreamType = RCRTCStreamType.TINY;
    }

    public void setResolution(RCRTCParamsType.RCRTCVideoResolution resolution) {
        this.mWidth = resolution.getWidth();
        this.mHeight = resolution.getHeight();
        this.minBitrate = resolution.getMinBitRate();
        this.maxBitrate = resolution.getMaxBitRate();
    }

    public RCRTCParamsType.RCRTCVideoResolution getResolution() {
        return this.resolution;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getMinBitrate() {
        return this.minBitrate;
    }

    @Override
    public int getMaxBitrate() {
        return this.maxBitrate;
    }

    private void configTinyVideoResolution() {
        RCCameraOutputStreamImpl videoStream = (RCCameraOutputStreamImpl)RTCEngineImpl.getInstance().getDefaultVideoStream();
        if (videoStream.getWidth() < 132 || videoStream.getHeight() < 132) {
            this.mWidth = videoStream.getWidth();
            this.mHeight = videoStream.getHeight();
        }
        int baseSide = Math.min(videoStream.getWidth(), videoStream.getHeight());
        double scale = RongRTCUtils.div(132.0, baseSide);
        double tempScaleSide = Math.floor(scale * (double)Math.max(videoStream.getWidth(), videoStream.getHeight()));
        int scaleSide = (int)tempScaleSide >> 2 << 2;
        this.mWidth = 132;
        this.mHeight = scaleSide;
    }
}

