/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.MediaCodecUtils;
import cn.rongcloud.rtc.core.MediaCodecUtilsProxy;
import cn.rongcloud.rtc.core.VideoCodecType;
import java.util.ArrayList;

public class HardwareCodecHelper {
    private static final String TAG = "HardwareCodecHelper";

    public static String getDefaultH264Encoder() {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        VideoCodecType type = VideoCodecType.valueOf("H264");
        MediaCodecInfo info = HardwareCodecHelper.findEncoderCodecForType(type, true);
        if (info == null) {
            return null;
        }
        String codecName = info.getName();
        return codecName;
    }

    public static String getDefaultH264Decoder() {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        VideoCodecType type = VideoCodecType.valueOf("H264");
        MediaCodecInfo info = HardwareCodecHelper.findDecoderCodecForType(type, false);
        if (info == null) {
            return null;
        }
        String codecName = info.getName();
        return codecName;
    }

    private static MediaCodecInfo findEncoderCodecForType(VideoCodecType type, boolean isEncode) {
        ArrayList<MediaCodecInfo> codecInfoList = new ArrayList<MediaCodecInfo>();
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", e);
            }
            if (info == null || !info.isEncoder()) continue;
            Logging.d(TAG, info.getName());
            if (!HardwareCodecHelper.isSupportedCodec(info, type, isEncode)) continue;
            codecInfoList.add(info);
        }
        if (codecInfoList.size() == 0) {
            return null;
        }
        return (MediaCodecInfo)codecInfoList.get(0);
    }

    private static MediaCodecInfo findDecoderCodecForType(VideoCodecType type, boolean isEncode) {
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", e);
            }
            if (info == null || info.isEncoder()) continue;
            Logging.d(TAG, info.getName());
            if (!HardwareCodecHelper.isSupportedCodec(info, type, isEncode)) continue;
            return info;
        }
        return null;
    }

    private static boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type, boolean isEncode) {
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, info.getCapabilitiesForType(type.mimeType())) == null) {
            return false;
        }
        return HardwareCodecHelper.isHardwareSupportedInCurrentSdk(info, type, isEncode);
    }

    private static boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo info, VideoCodecType type, boolean isEncode) {
        switch (type) {
            case VP8: {
                return HardwareCodecHelper.isHardwareSupportedInCurrentSdkVp8(info);
            }
            case VP9: {
                return HardwareCodecHelper.isHardwareSupportedInCurrentSdkVp9(info);
            }
            case H264: {
                return HardwareCodecHelper.isHardwareSupportedInCurrentSdkH264(info, isEncode);
            }
        }
        return false;
    }

    private static boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo info) {
        String name = info.getName();
        return name.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || name.startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21;
    }

    private static boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo info) {
        String name = info.getName();
        return (name.startsWith("OMX.qcom.") || name.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
    }

    private static boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo info, boolean isEncode) {
        MediaCodecUtilsProxy mediaCodecUtilsProxy = new MediaCodecUtilsProxy();
        if (mediaCodecUtilsProxy.getHWExceptionList().contains(Build.MODEL)) {
            return false;
        }
        String name = info.getName();
        for (String prefix : mediaCodecUtilsProxy.getH264SupportCpuPrefixList(isEncode)) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

