/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.os.Message;
import cn.rongcloud.rtc.RongRTCMessageRouter;
import cn.rongcloud.rtc.center.stream.RCCameraOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCScreenShareOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCStreamImpl;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.audio.AudioMixer;
import cn.rongcloud.rtc.engine.AbstractBaseState;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.UnInitState;
import cn.rongcloud.rtc.monitor.NetworkConnectChangedReceiver;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.IWebRTCCore;
import io.rong.imlib.IRongCoreListener;
import io.rong.imlib.ModuleManager;

public class DisconnectingState
extends AbstractBaseState {
    private static final String TAG = "DisconnectingState";

    public DisconnectingState(RTCEngineImpl engine) {
        super(engine);
    }

    @Override
    public void enter() {
        super.enter();
        this.closePeerConnection();
    }

    private void closePeerConnection() {
        IWebRTCCore rtcCore = this.mEngine.mRTCCore;
        if (rtcCore != null) {
            rtcCore.closePeerConnection();
        }
    }

    @Override
    protected boolean handleMessage(Message msg, MsgObjectWraper obj) {
        switch (msg.what) {
            case 1010: {
                this.mEngine.deferMessage(msg);
                break;
            }
            case 1011: 
            case 10000: {
                if (msg.what == 1011) {
                    this.mEngine.mUnInitState.imSignOut();
                }
                this.unInit();
                this.mEngine.transitionTo(this.mEngine.mUnInitState);
                if (msg.what != 1011) break;
                RongRTCUtils.localUserKicked((IRongCoreListener.ConnectionStatusListener.ConnectionStatus)obj.getData(0), (String)obj.getData(1));
                break;
            }
            default: {
                this.mEngine.deferMessage(msg);
                this.mEngine.transitionTo(this.mEngine.mIdleState);
            }
        }
        return true;
    }

    private void unInit() {
        RCScreenShareOutputStreamImpl screenShareOutputStream;
        ReportUtil.libTask(ReportUtil.TAG.RELEASERTCENGINE, "", "");
        this.mEngine.unInitFaceBeautyPlugin();
        this.mEngine.unInitVoiceBeautyPlugin();
        ReportUtil.libStatus(ReportUtil.TAG.RELEASERTCENGINE, "step", "unInitPlugins");
        UnInitState uninitState = this.mEngine.mUnInitState;
        uninitState.mCallInited = false;
        RongRTCMessageRouter messageRouter = uninitState.mMessageRouter;
        if (messageRouter != null) {
            ModuleManager.removeMessageRouter((ModuleManager.MessageRouter)messageRouter);
            uninitState.mMessageRouter = null;
        }
        ReportUtil.libStatus(ReportUtil.TAG.RELEASERTCENGINE, "step", "removeMessageRouter");
        if (uninitState.signalEventListener != null) {
            SignalManager.getInstance().setRTCRoomEventListener(null);
            uninitState.signalEventListener = null;
        }
        NetworkConnectChangedReceiver networkConnectChangedReceiver = uninitState.networkConnectChangedReceiver;
        Context context = this.mEngine.mContext;
        if (context != null && networkConnectChangedReceiver != null) {
            try {
                context.unregisterReceiver((BroadcastReceiver)networkConnectChangedReceiver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            uninitState.networkConnectChangedReceiver = null;
        }
        ReportUtil.libStatus(ReportUtil.TAG.RELEASERTCENGINE, "step", "unregisterReceiver");
        RCMicOutputStreamImpl defaultAudioStream = this.mEngine.mDefaultAudioStream;
        if (defaultAudioStream != null) {
            defaultAudioStream.release();
            this.mEngine.mDefaultAudioStream = null;
        }
        ReportUtil.libStatus(ReportUtil.TAG.RELEASERTCENGINE, "step", "AudioStreamRelease");
        AudioMixer.getInstance().setDefaultAudioStream(null);
        RCCameraOutputStreamImpl defaultVideoStream = this.mEngine.mDefaultVideoStream;
        if (defaultVideoStream != null) {
            ((RCStreamImpl)defaultVideoStream).release();
            this.mEngine.mDefaultVideoStream = null;
        }
        if ((screenShareOutputStream = this.mEngine.screenShareOutputStream) != null) {
            screenShareOutputStream.release();
            this.mEngine.screenShareOutputStream = null;
        }
        ReportUtil.libStatus(ReportUtil.TAG.RELEASERTCENGINE, "step", "VideoStreamRelease");
        IWebRTCCore rtcCore = this.mEngine.mRTCCore;
        if (rtcCore != null) {
            rtcCore.release();
            this.mEngine.mRTCCore = null;
        }
        ReportUtil.libStatus(ReportUtil.TAG.RELEASERTCENGINE, "step", "WebRTCCoreRelease");
        EglBase eglBase = this.mEngine.mEglBase;
        if (eglBase != null) {
            eglBase.detachCurrent();
            eglBase.release();
            this.mEngine.mEglBase = null;
            this.mEngine.mEglContext = null;
        }
        ReportUtil.libStatus(ReportUtil.TAG.RELEASERTCENGINE, "step", "eglBaseRelease");
        this.mEngine.mContext = null;
        ReportUtil.libRes(ReportUtil.TAG.RELEASERTCENGINE, "code", 0);
    }

    @Override
    public String getName() {
        return TAG;
    }
}

