/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.media.http;

import android.net.Uri;
import android.os.Build;
import android.security.NetworkSecurityPolicy;
import android.text.TextUtils;
import cn.rongcloud.rtc.media.http.Headers;
import cn.rongcloud.rtc.media.http.Response;

public class Request {
    private String url;
    private String method;
    private Headers headers;
    private String requestBody;
    private Response response;
    private boolean valid = true;

    public String url() {
        return this.url;
    }

    public String method() {
        return this.method;
    }

    public Response response() {
        return this.response;
    }

    public String body() {
        return this.requestBody;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getRequestHeaders() {
        String sessionId = "Client-Session-Id";
        String requestId = "Request-Id";
        String session = this.headers.get(sessionId);
        String id = this.headers.get(requestId);
        StringBuilder builder = new StringBuilder();
        builder.append(sessionId).append("=").append(TextUtils.isEmpty((CharSequence)session) ? "" : session);
        builder.append(",");
        builder.append(requestId).append("=").append(TextUtils.isEmpty((CharSequence)id) ? "" : id);
        return builder.toString();
    }

    public static class Builder {
        private String url;
        private String method = "GET";
        private Headers headers = new Headers();
        private String requestBody;
        private Response response;

        public Builder url(String url) {
            Uri uri;
            boolean cleartextTrafficPermitted;
            if (url == null) {
                throw new NullPointerException("url == null");
            }
            if (Build.VERSION.SDK_INT >= 23 && !(cleartextTrafficPermitted = NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted()) && TextUtils.equals((CharSequence)(uri = Uri.parse((String)url)).getScheme(), (CharSequence)"http")) {
                url = uri.buildUpon().scheme("https").build().toString();
            }
            this.url = url;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder body(String body) {
            this.requestBody = body;
            return this;
        }

        public Builder header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.add(key, value);
            return this;
        }

        public Request build() {
            Request request = new Request();
            request.url = this.url;
            request.method = this.method;
            request.headers = this.headers;
            request.requestBody = this.requestBody;
            request.response = this.response;
            return request;
        }
    }
}

