/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.signal;

import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.base.RTCErrorCode;
import io.rong.imlib.IRongCoreCallback;
import io.rong.imlib.IRongCoreEnum;
import java.util.concurrent.locks.LockSupport;

public class SyncIMResultCallback<T>
extends IRongCoreCallback.ResultCallback<T> {
    private AsyncResult.TemporaryResult mRes = AsyncResult.create();
    private Thread mThread;
    private IRCRTCResultCallback mCallback;
    private boolean mIsSync = true;

    public SyncIMResultCallback(IRCRTCResultCallback mCallback, boolean isSync) {
        this.mCallback = mCallback;
        this.mIsSync = isSync;
        if (this.mIsSync) {
            this.mThread = Thread.currentThread();
        }
    }

    public void onSuccess(T t) {
        if (this.mCallback != null) {
            this.mCallback.onSuccess();
        }
        if (this.mIsSync) {
            LockSupport.unpark(this.mThread);
        }
    }

    public void onError(IRongCoreEnum.CoreErrorCode coreErrorCode) {
        RTCErrorCode rtcErrorCode = RTCErrorCode.valueOf(coreErrorCode.getValue());
        this.mRes.setAndNotify(rtcErrorCode);
        if (this.mCallback != null) {
            this.mCallback.onFailed(rtcErrorCode);
        }
        if (this.mIsSync) {
            LockSupport.unpark(this.mThread);
        }
    }

    public AsyncResult getResult() {
        if (this.mIsSync) {
            LockSupport.park();
        }
        return this.mRes.getResult();
    }
}

