/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import cn.rongcloud.rtc.core.audio.AudioResample;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class AudioBufferStream {
    private static final int MAX_BUFFER_SIZE = 4;
    private int outSampleRate;
    private int outChannelCount;
    private long currentSampleTime = 0L;
    private LinkedBlockingDeque<ByteBuffer> inputBufferQueue = new LinkedBlockingDeque(4);
    private LinkedBlockingDeque<ByteBuffer> outputBufferQueue = new LinkedBlockingDeque(4);
    private OnAudioReadListener mOnAudioReadListener = null;
    private AudioResample mAudioResample;
    private AtomicBoolean released = new AtomicBoolean(false);

    public AudioBufferStream(int inSampleRate, int inChannelCount, int inAudioFormat, int outSampleRate, int outChannelCount, int outAudioFormat) {
        this.outSampleRate = outSampleRate;
        this.outChannelCount = outChannelCount;
        for (int i = 0; i < 4; ++i) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(outSampleRate * outChannelCount * 2 / 2);
            this.inputBufferQueue.add(byteBuffer);
        }
        this.mAudioResample = new AudioResample(inSampleRate, inChannelCount, inAudioFormat, outSampleRate, outChannelCount, outAudioFormat);
    }

    public AudioBufferStream(int inSampleRate, int inChannelCount, int outSampleRate, int outChannelCount) {
        this(inSampleRate, inChannelCount, 2, outSampleRate, outChannelCount, 2);
    }

    public void setOnAudioReadListener(OnAudioReadListener listener) {
        this.mOnAudioReadListener = listener;
    }

    public byte[] read(int frames) {
        if (this.outputBufferQueue.isEmpty()) {
            return null;
        }
        return this.read(frames, true);
    }

    private byte[] read(int frames, boolean callOutSide) {
        int frameSize = this.outChannelCount * 2;
        byte[] data = new byte[frames * frameSize];
        try {
            ByteBuffer buffer = this.obtainBuffer(this.outputBufferQueue, false);
            if (buffer == null) {
                return null;
            }
            if (buffer.remaining() > data.length) {
                buffer.get(data, 0, data.length);
                this.enqueueBufferFirst(this.outputBufferQueue, buffer);
            } else {
                int len = buffer.remaining();
                buffer.get(data, 0, len);
                this.enqueueBufferLast(this.inputBufferQueue, buffer);
                int lastFrames = (data.length - len) / frameSize;
                byte[] lastData = this.read(lastFrames, false);
                if (lastData == null) {
                    return null;
                }
                System.arraycopy(lastData, 0, data, len, lastData.length);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        if (callOutSide && this.mOnAudioReadListener != null) {
            int timeMillis = frames * 1000 / this.outSampleRate;
            this.currentSampleTime += (long)timeMillis;
            this.mOnAudioReadListener.onAudioRead(this.currentSampleTime);
        }
        return data;
    }

    public void write(ByteBuffer data, int dataSize) {
    }

    public void write(byte[] data) {
        try {
            if (this.released.get()) {
                return;
            }
            if ((data = this.mAudioResample.resample(data)) == null) {
                return;
            }
            int offset = 0;
            while (offset < data.length) {
                ByteBuffer byteBuffer = this.obtainBuffer(this.inputBufferQueue, true);
                if (byteBuffer == null) {
                    return;
                }
                byteBuffer.clear();
                if (data.length - offset > byteBuffer.capacity()) {
                    byteBuffer.put(data, offset, byteBuffer.capacity());
                    offset += byteBuffer.capacity();
                } else {
                    byteBuffer.put(data, offset, data.length - offset);
                    offset += data.length - offset;
                }
                byteBuffer.flip();
                this.enqueueBufferLast(this.outputBufferQueue, byteBuffer);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    public void write(byte[] data, boolean block) {
        try {
            if (this.released.get()) {
                return;
            }
            if ((data = this.mAudioResample.resample(data)) == null) {
                return;
            }
            int offset = 0;
            while (offset < data.length) {
                ByteBuffer byteBuffer = this.obtainBuffer(this.inputBufferQueue, block);
                if (byteBuffer == null) {
                    return;
                }
                byteBuffer.clear();
                if (data.length - offset > byteBuffer.capacity()) {
                    byteBuffer.put(data, offset, byteBuffer.capacity());
                    offset += byteBuffer.capacity();
                } else {
                    byteBuffer.put(data, offset, data.length - offset);
                    offset += data.length - offset;
                }
                byteBuffer.flip();
                this.enqueueBufferLast(this.outputBufferQueue, byteBuffer);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    private ByteBuffer obtainBuffer(LinkedBlockingDeque<ByteBuffer> blockingDeque, boolean block) throws InterruptedException {
        ByteBuffer byteBuffer;
        while ((byteBuffer = blockingDeque.poll(100L, TimeUnit.MILLISECONDS)) == null && !this.released.get() && block) {
        }
        return byteBuffer;
    }

    private void enqueueBufferLast(LinkedBlockingDeque<ByteBuffer> blockingDeque, ByteBuffer byteBuffer) throws InterruptedException {
        while (!blockingDeque.offer(byteBuffer, 100L, TimeUnit.MILLISECONDS) && !this.released.get()) {
        }
    }

    private void enqueueBufferFirst(LinkedBlockingDeque<ByteBuffer> blockingDeque, ByteBuffer byteBuffer) throws InterruptedException {
        while (!blockingDeque.offerFirst(byteBuffer, 1000L, TimeUnit.MILLISECONDS) && !this.released.get()) {
        }
    }

    public void release() {
        this.released.set(true);
        this.inputBufferQueue.clear();
        this.outputBufferQueue.clear();
        this.mAudioResample.destroy();
    }

    public static interface OnAudioReadListener {
        public void onAudioRead(long var1);
    }
}

