/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.media.AudioTrack;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class AudioUtil {
    private static float dBPerStep = 0.25f;
    private static float dBConvert = -dBPerStep / 20.0f;
    private static final String KEY_PCM_ENCODING = "pcm-encoding";

    private AudioUtil() {
    }

    public static float linearToLog(int volume) {
        return volume == 0 ? 0.0f : (float)Math.pow(10.0, dBConvert * (float)(100 - volume));
    }

    public static void mixAsShort(byte[] audioData1, ByteBuffer audioData2) {
        audioData2.position(0);
        audioData2.limit(audioData2.capacity());
        ShortBuffer sAudioData1 = ByteBuffer.wrap(audioData1).order(ByteOrder.nativeOrder()).asShortBuffer();
        ShortBuffer sAudioData2 = audioData2.order(ByteOrder.nativeOrder()).asShortBuffer();
        for (int i = 0; i < sAudioData1.capacity(); ++i) {
            short data2;
            short data1 = sAudioData1.get(i);
            long data = (long)(data1 + (data2 = sAudioData2.get(i))) - (long)(data1 * data2 >> 16);
            if (data > 32767L) {
                data = 32767L;
            }
            if (data < -32768L) {
                data = -32768L;
            }
            sAudioData2.put(i, (short)data);
        }
    }

    public static void append(byte[] audioData1, float weight, ByteBuffer audioData2) {
        audioData2.position(0);
        audioData2.limit(audioData2.capacity());
        ShortBuffer sAudioData1 = ByteBuffer.wrap(audioData1).order(ByteOrder.nativeOrder()).asShortBuffer();
        ShortBuffer sAudioData2 = audioData2.order(ByteOrder.nativeOrder()).asShortBuffer();
        for (int i = 0; i < sAudioData1.capacity(); ++i) {
            sAudioData2.put(i, (short)((float)sAudioData1.get(i) * weight + (float)sAudioData2.get(i)));
        }
    }

    public static void mixAsByte(byte[] audioData1, ByteBuffer audioData2) {
        for (int i = 0; i < audioData2.capacity(); ++i) {
            audioData2.put(i, (byte)((audioData2.get(i) + audioData1[i]) / 2));
        }
    }

    public static void adjustVolumeAsByte(byte[] bytes, float vol) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        for (int i = 0; i < buffer.capacity(); ++i) {
            buffer.put(i, (byte)Math.max(-128.0f, Math.min(127.0f, (float)buffer.get(i) * vol)));
        }
    }

    public static void adjustVolumeAsByte(ByteBuffer buffer, float vol) {
        for (int i = 0; i < buffer.capacity(); ++i) {
            buffer.put(i, (byte)Math.max(-128.0f, Math.min(127.0f, (float)buffer.get(i) * vol)));
        }
    }

    public static void adjustVolumeAsShort(byte[] bytes, float vol) {
        ShortBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder()).asShortBuffer();
        for (int i = 0; i < buffer.capacity(); ++i) {
            buffer.put(i, (short)Math.max(-32768.0f, Math.min(32767.0f, (float)buffer.get(i) * vol)));
        }
    }

    public static void adjustVolumeAsShort(ByteBuffer byteBuffer, float vol) {
        byteBuffer.position(0);
        byteBuffer.limit(byteBuffer.capacity());
        ShortBuffer buffer = byteBuffer.order(ByteOrder.nativeOrder()).asShortBuffer();
        for (int i = 0; i < buffer.capacity(); ++i) {
            buffer.put(i, (short)Math.max(-32768.0f, Math.min(32767.0f, (float)buffer.get(i) * vol)));
        }
    }

    public static AudioTrack createAudioTrack(int sampleRate, int channelCount, int audioFormat, int streamType) {
        int channelConfig = channelCount == 1 ? 4 : 12;
        int bufferSizeInBytes = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat);
        AudioTrack audioTrack = new AudioTrack(streamType, sampleRate, channelConfig, audioFormat, bufferSizeInBytes, 1);
        try {
            audioTrack.play();
            return audioTrack;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AudioTrack createAudioTrack(MediaFormat mediaFormat, int streamType) {
        if (mediaFormat == null || !mediaFormat.containsKey("sample-rate") || !mediaFormat.containsKey("channel-count")) {
            return null;
        }
        int sampleRate = mediaFormat.getInteger("sample-rate");
        int channelCount = mediaFormat.getInteger("channel-count");
        int audioFormat = 2;
        if (mediaFormat.containsKey(KEY_PCM_ENCODING)) {
            audioFormat = mediaFormat.getInteger(KEY_PCM_ENCODING);
        }
        return AudioUtil.createAudioTrack(sampleRate, channelCount, audioFormat, streamType);
    }

    public static int durationOfMediaFile(String path) {
        try {
            MediaPlayer mediaPlayer = new MediaPlayer();
            mediaPlayer.setDataSource(path);
            mediaPlayer.prepare();
            return mediaPlayer.getDuration();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static int bytesPerSample(int audioFormat) {
        switch (audioFormat) {
            case 3: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException("not supported audio format: " + audioFormat);
    }
}

