/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.annotation.SuppressLint;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import com.liulishuo.filedownloader.PauseAllMarker;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.i.IFileDownloadIPCService;
import com.liulishuo.filedownloader.services.FDServiceSeparateHandler;
import com.liulishuo.filedownloader.services.FDServiceSharedHandler;
import com.liulishuo.filedownloader.services.FileDownloadManager;
import com.liulishuo.filedownloader.services.ForegroundServiceConfig;
import com.liulishuo.filedownloader.services.IFileDownloadServiceHandler;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.lang.ref.WeakReference;

@SuppressLint(value={"Registered"})
public class FileDownloadService
extends Service {
    private IFileDownloadServiceHandler handler;
    private PauseAllMarker pauseAllMarker;

    public void onCreate() {
        super.onCreate();
        FileDownloadHelper.holdContext((Context)this);
        try {
            FileDownloadUtils.setMinProgressStep(FileDownloadProperties.getImpl().downloadMinProgressStep);
            FileDownloadUtils.setMinProgressTime(FileDownloadProperties.getImpl().downloadMinProgressTime);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        FileDownloadManager manager = new FileDownloadManager();
        this.handler = FileDownloadProperties.getImpl().processNonSeparate ? new FDServiceSharedHandler(new WeakReference<FileDownloadService>(this), manager) : new FDServiceSeparateHandler(new WeakReference<FileDownloadService>(this), manager);
        PauseAllMarker.clearMarker();
        this.pauseAllMarker = new PauseAllMarker((IFileDownloadIPCService)((Object)this.handler));
        this.pauseAllMarker.startPauseAllLooperCheck();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.handler.onStartCommand(intent, flags, startId);
        this.inspectRunServiceForeground(intent);
        return 1;
    }

    private void inspectRunServiceForeground(Intent intent) {
        if (intent == null) {
            return;
        }
        boolean isForeground = intent.getBooleanExtra("is_foreground", false);
        if (isForeground) {
            ForegroundServiceConfig config = CustomComponentHolder.getImpl().getForegroundConfigInstance();
            if (config.isNeedRecreateChannelId() && Build.VERSION.SDK_INT >= 26) {
                NotificationChannel notificationChannel = new NotificationChannel(config.getNotificationChannelId(), (CharSequence)config.getNotificationChannelName(), 2);
                NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
                if (notificationManager == null) {
                    return;
                }
                notificationManager.createNotificationChannel(notificationChannel);
            }
            this.startForeground(config.getNotificationId(), config.getNotification((Context)this));
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d((Object)this, "run service foreground with config: %s", config);
            }
        }
    }

    public void onDestroy() {
        this.pauseAllMarker.stopPauseAllLooperCheck();
        this.stopForeground(true);
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return this.handler.onBind(intent);
    }

    public static class SeparateProcessService
    extends FileDownloadService {
    }

    public static class SharedMainProcessService
    extends FileDownloadService {
    }
}

