/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.subtitle;

import com.tencent.thumbplayer.core.common.TPMediaTrackInfo;
import com.tencent.thumbplayer.core.common.TPNativeLibraryLoader;
import com.tencent.thumbplayer.core.common.TPSubtitleFrameWrapper;
import com.tencent.thumbplayer.core.player.TPNativePlayerUtils;
import com.tencent.thumbplayer.core.subtitle.ITPSubtitleParserCallback;
import com.tencent.thumbplayer.core.subtitle.TPNativeSubtitleRenderParams;
import java.util.Map;

public class TPSubtitleParser {
    public static final int TP_SUBTITLE_OUTPUT_TEXT = 0;
    public static final int TP_SUBTITLE_OUTPUT_RGBA = 1;
    private String mUrl = null;
    private Map<String, String> mHttpHeader = null;
    private int mOutputType = 0;
    private ITPSubtitleParserCallback mCallback = null;
    private boolean mInited = false;
    private boolean mIsLibLoaded = false;
    private long mNativeContext = 0L;

    private native int _subtitleCreate(String var1, Object var2, int var3);

    private native int _subtitleCreateWithUrlHttpHeader(String var1, Object[] var2, Object var3, int var4);

    private native void _subtitleLoadAsync();

    private native void _subtitleStartAsync();

    private native void _subtitlePauseAsync();

    private native void _subtitleStop();

    private native void _subtitleDelete();

    private native String _subtitleGetText(long var1, int var3);

    private native void _subtitleSetRenderParams(TPNativeSubtitleRenderParams var1);

    private native TPSubtitleFrameWrapper _subtitleGetFrame(long var1);

    private native int _subtitleGetTrackCount();

    private native String _subtitleGetTrackName(int var1);

    private native int _subtitleSelectTrackAsync(int var1, long var2);

    private void loadLibrary() {
        try {
            TPNativeLibraryLoader.loadLibIfNeeded(null);
            this.mIsLibLoaded = true;
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            unsupportedOperationException.printStackTrace();
            this.mIsLibLoaded = false;
            return;
        }
    }

    public TPSubtitleParser(String string, ITPSubtitleParserCallback iTPSubtitleParserCallback) {
        this.loadLibrary();
        this.mUrl = string;
        this.mCallback = iTPSubtitleParserCallback;
    }

    public TPSubtitleParser(String string, Map<String, String> map, ITPSubtitleParserCallback iTPSubtitleParserCallback) {
        this.loadLibrary();
        this.mUrl = string;
        this.mHttpHeader = map;
        this.mCallback = iTPSubtitleParserCallback;
    }

    public TPSubtitleParser(String string, ITPSubtitleParserCallback iTPSubtitleParserCallback, int n2) {
        this.loadLibrary();
        this.mUrl = string;
        this.mCallback = iTPSubtitleParserCallback;
        this.mOutputType = n2;
    }

    public TPSubtitleParser(String string, Map<String, String> map, ITPSubtitleParserCallback iTPSubtitleParserCallback, int n2) {
        this.loadLibrary();
        this.mUrl = string;
        this.mHttpHeader = map;
        this.mCallback = iTPSubtitleParserCallback;
        this.mOutputType = n2;
    }

    public void init() {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (this.mInited) {
            throw new IllegalStateException("Failed to init due to invalid state.");
        }
        this.mInited = true;
        if (this.mUrl != null && this.mCallback != null) {
            TPSubtitleParser tPSubtitleParser = this;
            tPSubtitleParser._subtitleCreateWithUrlHttpHeader(tPSubtitleParser.mUrl, TPNativePlayerUtils.tpMapStringToStringArray(this.mHttpHeader), this.mCallback, this.mOutputType);
        }
    }

    public void unInit() {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            return;
        }
        this.mInited = false;
        this._subtitleDelete();
    }

    public void startAsync() {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            throw new IllegalStateException("Failed to startAsync due to invalid state.");
        }
        this._subtitleStartAsync();
    }

    public void pauseAsync() {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            throw new IllegalStateException("Failed to pauseAsync due to invalid state.");
        }
        this._subtitlePauseAsync();
    }

    public void loadAsync() {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            throw new IllegalStateException("Failed to loadAsync due to invalid state.");
        }
        this._subtitleLoadAsync();
    }

    public void stop() {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            throw new IllegalStateException("Failed to stop due to invalid state.");
        }
        this._subtitleStop();
    }

    public TPMediaTrackInfo[] getTrackInfo() {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            throw new IllegalStateException("Failed to getTrackInfo due to invalid state.");
        }
        TPMediaTrackInfo[] tPMediaTrackInfoArray = null;
        int n2 = this._subtitleGetTrackCount();
        if (n2 > 0) {
            tPMediaTrackInfoArray = new TPMediaTrackInfo[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                TPMediaTrackInfo tPMediaTrackInfo = new TPMediaTrackInfo();
                new TPMediaTrackInfo().trackType = 3;
                tPMediaTrackInfo.trackName = this._subtitleGetTrackName(i2);
                tPMediaTrackInfoArray[i2] = tPMediaTrackInfo;
            }
        }
        return tPMediaTrackInfoArray;
    }

    public int selectTrackAsync(int n2, long l2) {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            throw new IllegalStateException("Failed to selectTrackAsync due to invalid state.");
        }
        return this._subtitleSelectTrackAsync(n2, l2);
    }

    public int selectTracksAsync(int[] nArray, long l2) {
        return 0;
    }

    public String getSubtitleText(long l2, int n2) {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            throw new IllegalStateException("Failed to getSubtitleText due to invalid state.");
        }
        return this._subtitleGetText(l2, n2);
    }

    public void setRenderParams(TPNativeSubtitleRenderParams tPNativeSubtitleRenderParams) {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            throw new IllegalStateException("Failed to setRenderParams due to invalid state.");
        }
        this._subtitleSetRenderParams(tPNativeSubtitleRenderParams);
    }

    public TPSubtitleFrameWrapper getSubtitleFrame(long l2) {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            throw new IllegalStateException("Failed to getSubtitleFrame due to invalid state.");
        }
        return this._subtitleGetFrame(l2);
    }
}

