/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import com.tencent.liteav.base.annotations.JNINamespace;

@JNINamespace(value="liteav::ugc")
public class UGCAVSyncer {
    protected long mNativeUGCAVSyncer = UGCAVSyncer.nativeCreate();

    protected void finalize() throws Throwable {
        if (this.mNativeUGCAVSyncer != 0L) {
            UGCAVSyncer.nativeDestroy(this.mNativeUGCAVSyncer);
            this.mNativeUGCAVSyncer = 0L;
        }
    }

    public void start() {
        if (this.mNativeUGCAVSyncer != 0L) {
            UGCAVSyncer.nativeStart(this.mNativeUGCAVSyncer);
        }
    }

    public void stop() {
        if (this.mNativeUGCAVSyncer != 0L) {
            UGCAVSyncer.nativeStop(this.mNativeUGCAVSyncer);
        }
    }

    public void resetClock() {
        if (this.mNativeUGCAVSyncer != 0L) {
            UGCAVSyncer.nativeResetClock(this.mNativeUGCAVSyncer);
        }
    }

    public void setSyncMode(SyncMode syncMode) {
        if (this.mNativeUGCAVSyncer != 0L) {
            UGCAVSyncer.nativeSetSyncMode(this.mNativeUGCAVSyncer, syncMode.getNativeValue());
        }
    }

    public SkipMode syncAudio(long ptsMs) {
        if (this.mNativeUGCAVSyncer == 0L) {
            return SkipMode.NOOP;
        }
        return SkipMode.valueOf(UGCAVSyncer.nativeSyncAudio(this.mNativeUGCAVSyncer, ptsMs));
    }

    public SkipMode syncVideo(long ptsMs) {
        if (this.mNativeUGCAVSyncer == 0L) {
            return SkipMode.NOOP;
        }
        return SkipMode.valueOf(UGCAVSyncer.nativeSyncVideo(this.mNativeUGCAVSyncer, ptsMs));
    }

    public void setAudioEos() {
        if (this.mNativeUGCAVSyncer != 0L) {
            UGCAVSyncer.nativeSetAudioEos(this.mNativeUGCAVSyncer);
        }
    }

    public void setVideoEos() {
        if (this.mNativeUGCAVSyncer != 0L) {
            UGCAVSyncer.nativeSetVideoEos(this.mNativeUGCAVSyncer);
        }
    }

    public void setAudioExist(boolean isExist) {
        if (this.mNativeUGCAVSyncer != 0L) {
            UGCAVSyncer.nativeSetAudioExist(this.mNativeUGCAVSyncer, isExist);
        }
    }

    public void setVideoExist(boolean isExist) {
        if (this.mNativeUGCAVSyncer != 0L) {
            UGCAVSyncer.nativeSetVideoExist(this.mNativeUGCAVSyncer, isExist);
        }
    }

    private static native long nativeCreate();

    private static native void nativeDestroy(long var0);

    private static native void nativeStart(long var0);

    private static native void nativeStop(long var0);

    private static native void nativeResetClock(long var0);

    private static native void nativeSetSyncMode(long var0, int var2);

    private static native int nativeSyncAudio(long var0, long var2);

    private static native int nativeSyncVideo(long var0, long var2);

    private static native void nativeSetAudioEos(long var0);

    private static native void nativeSetVideoEos(long var0);

    private static native void nativeSetAudioExist(long var0, boolean var2);

    private static native void nativeSetVideoExist(long var0, boolean var2);

    public static enum SyncMode {
        OFF(0),
        CLOCK_MASTER(1),
        AUDIO_MASTER(2),
        VIDEO_MASTER(3),
        INTERLEAVE_OUTPUT_WITHOUT_SKIP(4);

        private final int mNativeValue;

        private SyncMode(int value) {
            this.mNativeValue = value;
        }

        public final int getNativeValue() {
            return this.mNativeValue;
        }
    }

    public static enum SkipMode {
        NOOP(0),
        SKIP_CURRENT_FRAME(1);

        private final int mNativeValue;

        private SkipMode(int value) {
            this.mNativeValue = value;
        }

        public static SkipMode valueOf(int value) {
            if (value == 1) {
                return SKIP_CURRENT_FRAME;
            }
            return NOOP;
        }

        public final int getNativeValue() {
            return this.mNativeValue;
        }
    }
}

