/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.RecentEmoji;
import com.vanniktech.emoji.emoji.Emoji;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public final class RecentEmojiManager
implements RecentEmoji {
    private static final String PREFERENCE_NAME = "emoji-recent-manager";
    private static final String TIME_DELIMITER = ";";
    private static final String EMOJI_DELIMITER = "~";
    private static final String RECENT_EMOJIS = "recent-emojis";
    static final int EMOJI_GUESS_SIZE = 5;
    static final int MAX_RECENTS = 40;
    @NonNull
    private EmojiList emojiList = new EmojiList(0);
    @NonNull
    private final SharedPreferences sharedPreferences;

    public RecentEmojiManager(@NonNull Context context) {
        this.sharedPreferences = context.getApplicationContext().getSharedPreferences(PREFERENCE_NAME, 0);
    }

    @Override
    @NonNull
    public Collection<Emoji> getRecentEmojis() {
        if (this.emojiList.size() == 0) {
            String savedRecentEmojis = this.sharedPreferences.getString(RECENT_EMOJIS, "");
            if (savedRecentEmojis.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(savedRecentEmojis, EMOJI_DELIMITER);
                this.emojiList = new EmojiList(stringTokenizer.countTokens());
                while (stringTokenizer.hasMoreTokens()) {
                    Emoji emoji;
                    String token = stringTokenizer.nextToken();
                    String[] parts = token.split(TIME_DELIMITER);
                    if (parts.length != 2 || (emoji = EmojiManager.getInstance().findEmoji(parts[0])) == null || emoji.getLength() != parts[0].length()) continue;
                    long timestamp = Long.parseLong(parts[1]);
                    this.emojiList.add(emoji, timestamp);
                }
            } else {
                this.emojiList = new EmojiList(0);
            }
        }
        return this.emojiList.getEmojis();
    }

    @Override
    public void addEmoji(@NonNull Emoji emoji) {
        this.emojiList.add(emoji);
    }

    @Override
    public void persist() {
        if (this.emojiList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder(this.emojiList.size() * 5);
            for (int i = 0; i < this.emojiList.size(); ++i) {
                Data data = this.emojiList.get(i);
                stringBuilder.append(data.emoji.getUnicode()).append(TIME_DELIMITER).append(data.timestamp).append(EMOJI_DELIMITER);
            }
            stringBuilder.setLength(stringBuilder.length() - EMOJI_DELIMITER.length());
            this.sharedPreferences.edit().putString(RECENT_EMOJIS, stringBuilder.toString()).apply();
        }
    }

    static class Data {
        final Emoji emoji;
        final long timestamp;

        Data(Emoji emoji, long timestamp) {
            this.emoji = emoji;
            this.timestamp = timestamp;
        }
    }

    static class EmojiList {
        static final Comparator<Data> COMPARATOR = new Comparator<Data>(){

            @Override
            public int compare(Data lhs, Data rhs) {
                return Long.valueOf(rhs.timestamp).compareTo(lhs.timestamp);
            }
        };
        @NonNull
        final List<Data> emojis;

        EmojiList(int size) {
            this.emojis = new ArrayList<Data>(size);
        }

        void add(Emoji emoji) {
            this.add(emoji, System.currentTimeMillis());
        }

        void add(Emoji emoji, long timestamp) {
            Iterator<Data> iterator = this.emojis.iterator();
            Emoji emojiBase = emoji.getBase();
            while (iterator.hasNext()) {
                Data data = iterator.next();
                if (!data.emoji.getBase().equals(emojiBase)) continue;
                iterator.remove();
            }
            this.emojis.add(0, new Data(emoji, timestamp));
            if (this.emojis.size() > 40) {
                this.emojis.remove(40);
            }
        }

        Collection<Emoji> getEmojis() {
            Collections.sort(this.emojis, COMPARATOR);
            ArrayList<Emoji> sortedEmojis = new ArrayList<Emoji>(this.emojis.size());
            for (Data data : this.emojis) {
                sortedEmojis.add(data.emoji);
            }
            return sortedEmojis;
        }

        int size() {
            return this.emojis.size();
        }

        Data get(int index) {
            return this.emojis.get(index);
        }
    }
}

