/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2;

import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.egl.f;
import com.tencent.liteav.videobase.frame.FrameMetaData;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.a;
import com.tencent.liteav.videobase.videobase.c;

@JNINamespace(value="liteav::video")
public class FrameTransformer
implements c.a {
    private final String mTAG = "FrameTransformer_" + this.hashCode();
    private final b mThrottlers = new b();
    private EGLCore mEGLCore = null;
    private final GLConstants.PixelFormatType mPixelFormatType;
    private final GLConstants.PixelBufferType mPixelBufferType;
    private c mVideoFrameConverter;
    private j mPixelFrameRender;
    private e mGLTexturePool;
    private int mWidth = 0;
    private int mHeight = 0;
    private Rotation mRenderRotation = Rotation.a;
    private boolean mIsHorizontalMirror = false;
    private boolean mIsVerticalMirror = false;
    private long mNativeHandler;

    public FrameTransformer(GLConstants.PixelFormatType pixelFormatType, GLConstants.PixelBufferType pixelBufferType, long nativeHandler) {
        this.mPixelFormatType = pixelFormatType;
        this.mPixelBufferType = pixelBufferType;
        this.mNativeHandler = nativeHandler;
    }

    public void release() {
        LiteavLog.i(this.mTAG, "release");
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.mNativeHandler = 0L;
        this.uninitializedEGL();
    }

    public void setRenderRotation(Rotation rotation) {
        if (this.mRenderRotation != rotation) {
            LiteavLog.i(this.mTAG, "setRenderRotation ".concat(String.valueOf((Object)rotation)));
        }
        this.mRenderRotation = rotation;
    }

    public void setHorizontalMirror(boolean mirror) {
        if (this.mIsHorizontalMirror != mirror) {
            LiteavLog.i(this.mTAG, "setHorizontalMirror ".concat(String.valueOf(mirror)));
        }
        this.mIsHorizontalMirror = mirror;
    }

    public void setVerticalMirror(boolean mirror) {
        if (this.mIsVerticalMirror != mirror) {
            LiteavLog.i(this.mTAG, "setVerticalMirror ".concat(String.valueOf(mirror)));
        }
        this.mIsVerticalMirror = mirror;
    }

    public void renderFrame(PixelFrame renderFrame) {
        PixelFrame pixelFrame = new PixelFrame(renderFrame);
        this.applyRenderParams(pixelFrame);
        if (this.isNeedRecreateEGL(pixelFrame)) {
            if (this.mWidth != pixelFrame.getWidth() || this.mHeight != pixelFrame.getHeight()) {
                this.mWidth = pixelFrame.getWidth();
                this.mHeight = pixelFrame.getHeight();
            }
            this.uninitializedEGL();
            FrameTransformer frameTransformer = this;
            frameTransformer.initializeEGL(frameTransformer.mWidth, this.mHeight, pixelFrame.getGLContext());
        }
        if (this.mEGLCore == null) {
            return;
        }
        try {
            this.mEGLCore.makeCurrent();
        }
        catch (f f2) {
            LiteavLog.e(this.mThrottlers.a("make"), this.mTAG, "customRenderFrame makeCurrent error ".concat(String.valueOf(f2)), new Object[0]);
        }
        d d2 = this.mGLTexturePool.a(this.mWidth, this.mHeight);
        if (this.mPixelFrameRender != null) {
            this.mPixelFrameRender.a(pixelFrame, GLConstants.GLScaleType.a, d2);
        }
        if (this.mVideoFrameConverter != null) {
            this.mVideoFrameConverter.a(pixelFrame.getTimestamp(), d2);
        }
        d2.release();
    }

    private void initializeEGL(int width, int height, Object sharedContext) {
        if (this.mEGLCore != null) {
            return;
        }
        try {
            LiteavLog.i(this.mThrottlers.a("initGL"), this.mTAG, "egl init %d*%d", width, height);
            this.mEGLCore = new EGLCore();
            this.mEGLCore.initialize(sharedContext, null, width, height);
            this.mEGLCore.makeCurrent();
        }
        catch (f f2) {
            LiteavLog.e(this.mThrottlers.a("initError"), this.mTAG, "egl initialize failed.", f2);
            this.mEGLCore = null;
        }
        if (this.mEGLCore != null) {
            if (this.mPixelFrameRender == null) {
                this.mPixelFrameRender = new j(width, height);
            }
            this.mGLTexturePool = new e();
            this.initTransformer();
        }
    }

    private void uninitializedEGL() {
        if (this.mEGLCore == null) {
            return;
        }
        try {
            this.mEGLCore.makeCurrent();
        }
        catch (f f2) {
            LiteavLog.e(this.mThrottlers.a("make"), this.mTAG, "uninitializedEGL makeCurrent error ".concat(String.valueOf(f2)), new Object[0]);
        }
        LiteavLog.i(this.mThrottlers.a("uninitGL"), this.mTAG, "egl uninitializedEGL", new Object[0]);
        if (this.mPixelFrameRender != null) {
            this.mPixelFrameRender.a();
            this.mPixelFrameRender = null;
        }
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.a();
            this.mGLTexturePool.b();
            this.mGLTexturePool = null;
        }
        this.destroyTransformer();
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    private void initTransformer() {
        if (this.mVideoFrameConverter == null) {
            this.mVideoFrameConverter = new c();
            this.mVideoFrameConverter.a(new a(this.mWidth, this.mHeight), this.mPixelBufferType, this.mPixelFormatType, 0, this);
            this.mVideoFrameConverter.a(this.mGLTexturePool);
        }
    }

    private void destroyTransformer() {
        if (this.mVideoFrameConverter != null) {
            this.mVideoFrameConverter.a(0, this);
            this.mVideoFrameConverter.a();
            this.mVideoFrameConverter = null;
        }
    }

    private void applyRenderParams(PixelFrame pixelFrame) {
        FrameMetaData frameMetaData = pixelFrame.getMetaData();
        if (frameMetaData != null) {
            this.mRenderRotation = frameMetaData.getRenderRotation();
            this.mIsHorizontalMirror = frameMetaData.isRenderMirrorHorizontal();
            this.mIsVerticalMirror = frameMetaData.isRenderMirrorVertical();
        }
        PixelFrame pixelFrame2 = pixelFrame;
        pixelFrame2.setRotation(Rotation.a((pixelFrame2.getRotation().mValue + this.mRenderRotation.mValue) % 360));
        if (this.mIsHorizontalMirror) {
            PixelFrame pixelFrame3 = pixelFrame;
            pixelFrame3.setMirrorHorizontal(!pixelFrame3.isMirrorHorizontal());
        }
        if (this.mIsVerticalMirror) {
            PixelFrame pixelFrame4 = pixelFrame;
            pixelFrame4.setMirrorVertical(!pixelFrame4.isMirrorVertical());
        }
        if (this.mRenderRotation == Rotation.b || this.mRenderRotation == Rotation.d) {
            pixelFrame.swapWidthHeight();
        }
    }

    private boolean isNeedRecreateEGL(@NonNull PixelFrame renderFrame) {
        return this.mEGLCore == null || renderFrame.getWidth() != this.mWidth || renderFrame.getHeight() != this.mHeight || renderFrame.getGLContext() != null && !CommonUtil.equals(renderFrame.getGLContext(), this.mEGLCore.getSharedContext());
    }

    @Override
    public void onFrameConverted(int identity, PixelFrame pixelFrame) {
        if (this.mNativeHandler != 0L) {
            FrameTransformer frameTransformer = this;
            frameTransformer.nativeOnFrameConverted(frameTransformer.mNativeHandler, pixelFrame);
        }
    }

    private native void nativeOnFrameConverted(long var1, PixelFrame var3);
}

