/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.a;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.preprocessor.BeautyProcessor;
import com.tencent.liteav.videoproducer.preprocessor.VideoPreprocessor;
import com.tencent.liteav.videoproducer.preprocessor.ah;
import com.tencent.ugc.videoprocessor.VideoEffectProcessor;
import com.tencent.ugc.videoprocessor.VideoTransitionProcessor;
import com.tencent.ugc.videoprocessor.WatermarkProcessor;
import java.nio.FloatBuffer;

public class VideoProcessManager {
    private static final String TAG = "VideoProcessManager";
    private Context mContext;
    private IVideoProcessorListener mListener;
    private final VideoEffectProcessor mVideoEffectProcessor;
    private final VideoTransitionProcessor mTransitionProcessor;
    private final WatermarkProcessor mWatermarkProcessor;
    private e mGLTexturePool;
    private VideoPreprocessor mVideoPreprocessor;
    private BeautyProcessor mBeautyProcessor;
    private IVideoReporter mReporter;
    private FloatBuffer mNormalCubeVerticesBuffer;
    private FloatBuffer mNormalTextureCoordsBuffer;
    private boolean mNeedProcess = false;
    private static final int IDENTITY = 100;
    private boolean mIsPreprocessorRegister = false;

    public VideoProcessManager(Context context, boolean isEnterpriseProEnabled, @NonNull IVideoReporter reporter) {
        this.mContext = context;
        this.mReporter = reporter;
        this.mBeautyProcessor = new BeautyProcessor(this.mContext, isEnterpriseProEnabled, this.mReporter);
        this.mVideoPreprocessor = new VideoPreprocessor(this.mContext, this.mBeautyProcessor, reporter);
        this.mVideoEffectProcessor = new VideoEffectProcessor(this.mContext);
        this.mTransitionProcessor = new VideoTransitionProcessor(this.mContext);
        this.mWatermarkProcessor = new WatermarkProcessor();
        this.mBeautyProcessor.setPerformanceMode(isEnterpriseProEnabled);
        this.mNormalCubeVerticesBuffer = OpenGlUtils.createNormalCubeVerticesBuffer();
        this.mNormalTextureCoordsBuffer = OpenGlUtils.createTextureCoordsBuffer(Rotation.a, false, false);
    }

    public void initialize(e texturePool, int width, int height, ah listener) {
        this.mGLTexturePool = texturePool;
        this.mVideoPreprocessor.initialize();
        this.mVideoPreprocessor.setSourceType(CaptureSourceInterface.SourceType.e);
        this.mWatermarkProcessor.initialize(this.mGLTexturePool, width, height);
        a a2 = new a(width, height);
        this.mVideoPreprocessor.registerVideoProcessedListener(100, a2, GLConstants.PixelBufferType.b, GLConstants.PixelFormatType.f, false, listener);
        this.mIsPreprocessorRegister = true;
        this.mTransitionProcessor.init(this.mGLTexturePool);
    }

    public void reInitFilter(e texturePool, int width, int height, ah listener) {
        this.mGLTexturePool = texturePool;
        this.mWatermarkProcessor.initialize(this.mGLTexturePool, width, height);
        this.mTransitionProcessor.init(this.mGLTexturePool);
        if (!this.mIsPreprocessorRegister) {
            a a2 = new a(width, height);
            this.mVideoPreprocessor.registerVideoProcessedListener(100, a2, GLConstants.PixelBufferType.b, GLConstants.PixelFormatType.f, false, listener);
            this.mIsPreprocessorRegister = true;
        }
    }

    public void processByVideoEffect(PixelFrame pixelFrame) {
        PixelFrame pixelFrame2 = this.processByVideoEffectInner(pixelFrame);
        if (pixelFrame2 != null && this.mListener != null) {
            this.mListener.didProcessFrame(pixelFrame2);
            pixelFrame2.release();
        }
    }

    private PixelFrame processByVideoEffectInner(PixelFrame pixelFrame) {
        PixelFrame pixelFrame2;
        PixelFrame pixelFrame3 = pixelFrame;
        pixelFrame3.retain();
        if (this.mVideoEffectProcessor != null && this.mVideoEffectProcessor.getCurrentMotionType(pixelFrame3.getTimestamp()) == 1) {
            pixelFrame2 = this.applyTransitionFilterChain(pixelFrame3);
            if (pixelFrame2 != null) {
                pixelFrame3.release();
                pixelFrame3 = pixelFrame2;
            }
            if ((pixelFrame2 = this.applyMotionFilterChain(pixelFrame3)) != null) {
                pixelFrame3.release();
                pixelFrame3 = pixelFrame2;
            }
        } else {
            pixelFrame2 = this.applyMotionFilterChain(pixelFrame3);
            if (pixelFrame2 != null) {
                pixelFrame3.release();
                pixelFrame3 = pixelFrame2;
            }
            if ((pixelFrame2 = this.applyTransitionFilterChain(pixelFrame3)) != null) {
                pixelFrame3.release();
                pixelFrame3 = pixelFrame2;
            }
        }
        if ((pixelFrame2 = this.mWatermarkProcessor.process(pixelFrame3, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer)) != null) {
            pixelFrame3.release();
            pixelFrame3 = pixelFrame2;
        }
        return pixelFrame3;
    }

    public void unInitialize(ah preprocessListener) {
        if (this.mVideoEffectProcessor != null) {
            this.mVideoEffectProcessor.destroy();
        }
        if (this.mTransitionProcessor != null) {
            this.mTransitionProcessor.destroy();
        }
        if (this.mIsPreprocessorRegister) {
            this.mVideoPreprocessor.unregisterVideoProcessedListener(100, preprocessListener);
            this.mIsPreprocessorRegister = false;
        }
    }

    public void destroyFilter(ah listener) {
        this.unInitialize(listener);
        if (this.mVideoPreprocessor != null) {
            this.mVideoPreprocessor.uninitialize();
            this.mVideoPreprocessor = null;
        }
    }

    public void setListener(IVideoProcessorListener listener) {
        this.mListener = listener;
    }

    public void processFrame(PixelFrame frame) {
        GLES20.glFinish();
        if (frame == null) {
            return;
        }
        int n2 = -1;
        if (this.mListener != null) {
            n2 = this.mListener.customProcessFrame(frame);
        }
        if (n2 > 0) {
            frame = new PixelFrame(frame);
            frame.setTextureId(n2);
        }
        if (this.mVideoPreprocessor == null || !this.mNeedProcess) {
            if (this.mListener != null) {
                this.mListener.didProcessFrame(frame);
            }
        } else {
            if (this.mWatermarkProcessor != null) {
                this.mVideoPreprocessor.setGaussianBlurLevel(this.mWatermarkProcessor.getBlurLevel() * 4.0f);
            } else {
                this.mVideoPreprocessor.setGaussianBlurLevel(0.0f);
            }
            this.mVideoPreprocessor.processFrame(frame);
        }
        if (n2 > 0) {
            frame.release();
        }
    }

    private PixelFrame applyMotionFilterChain(PixelFrame frame) {
        if (this.mVideoEffectProcessor != null) {
            return this.mVideoEffectProcessor.processFrame(frame, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer, this.mGLTexturePool);
        }
        return null;
    }

    private PixelFrame applyTransitionFilterChain(PixelFrame frame) {
        if (this.mTransitionProcessor == null) {
            return null;
        }
        return this.mTransitionProcessor.applyTransitionFilter(frame, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
    }

    public WatermarkProcessor getWatermarkProcessor() {
        this.mNeedProcess = true;
        return this.mWatermarkProcessor;
    }

    public VideoEffectProcessor getEffectProcessor() {
        this.mNeedProcess = true;
        return this.mVideoEffectProcessor;
    }

    public VideoTransitionProcessor getTransitionProcessor() {
        this.mNeedProcess = true;
        return this.mTransitionProcessor;
    }

    public void setBeautyFilter(int beautyLevel, int whiteningLevel) {
        this.mNeedProcess = true;
        BeautyProcessor beautyProcessor = this.mVideoPreprocessor.getBeautyProcessor();
        if (beautyProcessor != null) {
            beautyProcessor.setBeautyLevel(beautyLevel);
            beautyProcessor.setWhitenessLevel(whiteningLevel);
        }
    }

    public void setSpecialRatio(float specialRatio) {
        this.mNeedProcess = true;
        this.mVideoPreprocessor.setFilterMixLevel(specialRatio);
    }

    public void setFilter(Bitmap leftBitmap, float leftIntensity, Bitmap rightBitmap, float rightIntensity, float leftRatio) {
        this.mNeedProcess = true;
        this.mVideoPreprocessor.setFilterGroupImages(leftRatio, leftBitmap, leftIntensity, rightBitmap, rightIntensity);
    }

    public void setScaleType(GLConstants.GLScaleType scaleType) {
        if (scaleType == GLConstants.GLScaleType.b) {
            this.mWatermarkProcessor.setRenderMode(2);
        }
    }

    public void setOutputSize(int width, int height) {
        if (this.mWatermarkProcessor != null) {
            this.mWatermarkProcessor.setRenderTargetSize(width, height);
        }
    }

    public static interface IVideoProcessorListener {
        public void didProcessFrame(PixelFrame var1);

        public int customProcessFrame(PixelFrame var1);
    }
}

