/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center;

import android.os.Handler;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCLocalUser;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.RCRTCRoomConfig;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCRoomEventsListener;
import cn.rongcloud.rtc.api.stream.RCRTCCDNInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RCRTCSubscribeState;
import cn.rongcloud.rtc.center.RCLocalUserImpl;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomEventListenerWrapper;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.module.ping.RTCPingManager;
import cn.rongcloud.rtc.proxy.message.messagebeans.CDNResourceInfo;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import io.rong.imlib.IRongCoreCallback;
import io.rong.imlib.model.MessageContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class RCRoomImpl
implements RCRTCRoom {
    public static final String RONG_RTC_UUID = "RongRTC_uuid";
    private Map<String, RCRTCRemoteUser> remoteUsers = new LinkedHashMap<String, RCRTCRemoteUser>();
    private RCLocalUserImpl mLocalUser;
    private RCRTCRoomType roomType;
    private String sessionId;
    private String clientSessionId;
    private RCRoomEventListenerWrapper eventsListener;
    private static final String TAG = "RCRoomImpl";
    private String roomId;
    private String rtcToken;
    private RTCPingManager mPingManager;
    private Map<String, String> mOtherRoomIdsMap;
    private RCRTCRemoteUser virtualLiveUser;
    private CDNResourceInfo mCDNResourceInfo;
    private RCRTCRoomConfig mRoomConfig;

    public RCRoomImpl(String roomId, RCRTCRoomConfig roomConfig, RCLocalUserImpl localUser, Map<String, RCRTCRemoteUser> remoteUsers, String sessionId, String rtcToken, RTCPingManager rtcPingManager, Handler callbackHandler, ArrayList<String> otherRoomIds) {
        if (remoteUsers != null) {
            this.remoteUsers.putAll(remoteUsers);
        }
        this.roomId = roomId;
        this.mLocalUser = localUser;
        this.sessionId = sessionId;
        this.roomType = roomConfig.getRoomType();
        this.clientSessionId = UUID.randomUUID().toString();
        this.rtcToken = rtcToken;
        this.mPingManager = rtcPingManager;
        this.eventsListener = new RCRoomEventListenerWrapper(roomId, callbackHandler);
        this.mRoomConfig = roomConfig;
        this.mOtherRoomIdsMap = new ConcurrentHashMap<String, String>();
        if (otherRoomIds != null && otherRoomIds.size() > 0) {
            for (String id : otherRoomIds) {
                this.mOtherRoomIdsMap.put(id, id);
            }
        }
    }

    @Override
    public void setRemoteAudioDataListener(IRCRTCAudioDataListener listener) {
        ((RCMicOutputStreamImpl)this.mLocalUser.getDefaultAudioStream()).setRemoteAudioPCMBufferListener(listener);
    }

    @Override
    public List<String> getOtherRoomIds() {
        ArrayList<String> list = new ArrayList<String>(this.mOtherRoomIdsMap.keySet().size());
        if (this.mOtherRoomIdsMap.size() > 0) {
            list.addAll(this.mOtherRoomIdsMap.keySet());
        }
        FinLog.d(TAG, "getOtherRoomIds : " + list.size());
        return list;
    }

    public void addRemoteUser(RCRTCRemoteUser remoteUser) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.remoteUsers.put(remoteUser.getUserId(), remoteUser);
    }

    public RCRTCRemoteUser removeRemoteUser(String userId) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        RCRemoteUserImpl user = (RCRemoteUserImpl)this.remoteUsers.remove(userId);
        if (user != null) {
            user.release();
        }
        return user;
    }

    @Override
    public RCRTCLocalUser getLocalUser() {
        return this.mLocalUser;
    }

    public String getRtcToken() {
        return this.rtcToken;
    }

    @Override
    public String getRoomId() {
        return this.roomId;
    }

    @Override
    public List<RCRTCRemoteUser> getRemoteUsers() {
        ArrayList<RCRTCRemoteUser> rcRemoteUsers = new ArrayList<RCRTCRemoteUser>();
        rcRemoteUsers.addAll(this.remoteUsers.values());
        return rcRemoteUsers;
    }

    @Override
    public RCRTCRemoteUser getRemoteUser(String userId) {
        return this.remoteUsers.get(userId);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public void muteAllRemoteAudio(boolean mute) {
        ReportUtil.appStatus(ReportUtil.TAG.MUTEALLREMOTEAUDIO, "mute", mute);
        ((RCMicOutputStreamImpl)this.mLocalUser.getDefaultAudioStream()).muteAllRemoteAudio(mute);
    }

    @Override
    public void setRoomAttributeValue(String value, String key, MessageContent message, IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().setAttributeValue(this.roomId, RCAttributeType.ROOM, key, value, message, callback);
    }

    @Override
    public void setRoomAttribute(String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().setAttributeValue(this.roomId, RCAttributeType.ROOM, key, value, message, callback);
    }

    @Override
    public void deleteRoomAttributes(List<String> attributeKeys, MessageContent message, IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().deleteAttributes(this.roomId, RCAttributeType.ROOM, attributeKeys, message, callback);
    }

    @Override
    public void getRoomAttributes(List<String> attributeKeys, IRCRTCResultDataCallback<Map<String, String>> callback) {
        RTCEngineImpl.getInstance().getAttributes(this.roomId, RCAttributeType.ROOM, attributeKeys, callback);
    }

    @Override
    public void registerRoomListener(IRCRTCRoomEventsListener eventsListener) {
        RCRoomEventListenerWrapper listener = this.eventsListener;
        if (listener != null) {
            listener.setEventsListener(eventsListener);
        }
    }

    @Override
    public void unregisterRoomListener() {
        RCRoomEventListenerWrapper eventsListener = this.eventsListener;
        if (eventsListener != null) {
            eventsListener.setEventsListener(null);
        }
    }

    @Override
    public void sendMessage(MessageContent messageContent, IRongCoreCallback.ISendMessageCallback callback) {
        RTCEngineImpl.getInstance().sendIMSignal(messageContent, callback);
    }

    public RCRTCRoomType getRoomType() {
        return this.roomType;
    }

    public String getClientSessionId() {
        return this.clientSessionId;
    }

    public void release() {
        for (RCRTCRemoteUser remoteUser : this.remoteUsers.values()) {
            ((RCRemoteUserImpl)remoteUser).release();
        }
        ((RCMicOutputStreamImpl)this.mLocalUser.getDefaultAudioStream()).setRemoteAudioPCMBufferListener(null);
        this.remoteUsers.clear();
        this.mLocalUser = null;
        if (this.mPingManager != null) {
            this.mPingManager.stopPing();
        }
        this.mPingManager = null;
        if (this.eventsListener != null) {
            this.eventsListener.release();
        }
        this.eventsListener = null;
        if (this.mOtherRoomIdsMap != null) {
            this.mOtherRoomIdsMap.clear();
        }
        if (this.getVirtualLiveUser() != null) {
            ((RCRemoteUserImpl)this.getVirtualLiveUser()).release();
            ((RCRemoteUserImpl)this.getVirtualLiveUser()).setCDNInputStream(null);
            this.setVirtualLiveUser(null);
        }
        this.mCDNResourceInfo = null;
    }

    public void switchToAudienceRelease() {
        for (RCRTCRemoteUser remoteUser : this.remoteUsers.values()) {
            ((RCRemoteUserImpl)remoteUser).release();
        }
        this.remoteUsers.clear();
        if (this.mPingManager != null) {
            this.mPingManager.stopPing();
        }
        this.mPingManager = null;
        if (this.mOtherRoomIdsMap != null) {
            this.mOtherRoomIdsMap.clear();
        }
    }

    public void switchToBroadcaster() {
        for (RCRTCRemoteUser remoteUser : this.remoteUsers.values()) {
            ((RCRemoteUserImpl)remoteUser).release();
        }
        this.remoteUsers.clear();
        if (this.mPingManager != null) {
            this.mPingManager.stopPing();
        }
        this.mPingManager = null;
        if (this.mOtherRoomIdsMap != null) {
            this.mOtherRoomIdsMap.clear();
        }
    }

    public RTCPingManager getPingManager() {
        return this.mPingManager;
    }

    public IRCRTCRoomEventsListener getEventsListener() {
        return this.eventsListener;
    }

    public void addOtherRoomId(String otherRoomId) {
        if (TextUtils.isEmpty((CharSequence)otherRoomId)) {
            FinLog.e(TAG, "addOtherRoomId.error .otherRoomId is empty.");
            return;
        }
        this.mOtherRoomIdsMap.put(otherRoomId, otherRoomId);
    }

    public void removeOtherRoomId(String otherRoomId) {
        if (this.mOtherRoomIdsMap != null && this.mOtherRoomIdsMap.size() > 0 && !TextUtils.isEmpty((CharSequence)otherRoomId)) {
            FinLog.d(TAG, "removeOtherRoomId. otherRoomId : " + otherRoomId);
            this.mOtherRoomIdsMap.remove(otherRoomId);
        } else {
            FinLog.e(TAG, "removeOtherRoomId.error . empty");
        }
    }

    public void setVirtualLiveUser(RCRTCRemoteUser virtualLiveUser) {
        if (virtualLiveUser == null) {
            FinLog.d(TAG, "release VirtualLiveUser");
        } else {
            FinLog.d(TAG, "setVirtualLiveUser: UserId=" + virtualLiveUser.getUserId());
        }
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.virtualLiveUser = virtualLiveUser;
    }

    public RCRTCRemoteUser getVirtualLiveUser() {
        return this.virtualLiveUser;
    }

    @Override
    public List<RCRTCInputStream> getLiveStreams() {
        RCRTCRemoteUser mcuUser = this.virtualLiveUser;
        if (mcuUser == null) {
            return Collections.emptyList();
        }
        return mcuUser.getStreams();
    }

    @Override
    public RCRTCCDNInputStream getCDNStream() {
        RCRTCCDNInputStream CDNStream = null;
        if (this.virtualLiveUser != null) {
            CDNStream = ((RCRemoteUserImpl)this.virtualLiveUser).getCDNInputStream();
        }
        return CDNStream;
    }

    public List<IStreamResource> getAllSubscribedStreams() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        List<RCRTCRemoteUser> remoteUsers = this.getRemoteUsers();
        ArrayList<IStreamResource> subList = new ArrayList<IStreamResource>();
        for (RCRTCRemoteUser remoteUser : remoteUsers) {
            this.getSubscribedStreams(subList, remoteUser.getStreams());
        }
        if (this.virtualLiveUser != null) {
            List<RCRTCInputStream> streams = this.virtualLiveUser.getStreams();
            this.getSubscribedStreams(subList, streams);
            RCRTCCDNInputStream CDNStream = this.getCDNStream();
            if (CDNStream != null && ((RCInputStreamImpl)((Object)CDNStream)).getSubscribeState() == RCRTCSubscribeState.SUBSCRIBED) {
                subList.add(CDNStream);
            }
        }
        return subList;
    }

    private void getSubscribedStreams(ArrayList<IStreamResource> subList, List<RCRTCInputStream> targetStreams) {
        if (RongRTCUtils.isEmpty(targetStreams)) {
            return;
        }
        for (RCRTCInputStream stream : targetStreams) {
            RCInputStreamImpl inputStream = (RCInputStreamImpl)stream;
            if (inputStream.getSubscribeState() != RCRTCSubscribeState.SUBSCRIBED) continue;
            subList.add(inputStream);
        }
    }

    public CDNResourceInfo getCDNResourceInfo() {
        return this.mCDNResourceInfo;
    }

    public void setCDNResourceInfo(CDNResourceInfo mCDNResourceInfo) {
        this.mCDNResourceInfo = mCDNResourceInfo;
    }

    public void updateCDNResourceInfo(String roomId, String pullUrl) {
        ReportUtil.libStatus(ReportUtil.TAG.PLAYER_STATE, "roomId|updateCDNResourceInfo : ", roomId, pullUrl);
        if (this.getCDNResourceInfo() != null) {
            this.getCDNResourceInfo().updateInfo(pullUrl);
        } else {
            CDNResourceInfo cdnResourceInfo = new CDNResourceInfo(pullUrl);
            this.setCDNResourceInfo(cdnResourceInfo);
        }
    }

    public void refreshData(String roomId, RCRTCRoomConfig config, Map<String, RCRTCRemoteUser> remoteUsers, String sessionId, String rtcToken, RTCPingManager rtcPingManager, ArrayList<String> otherRoomIds) {
        if (remoteUsers != null) {
            this.remoteUsers.clear();
            this.remoteUsers.putAll(remoteUsers);
        }
        this.roomId = roomId;
        this.sessionId = sessionId;
        this.roomType = config.getRoomType();
        this.clientSessionId = UUID.randomUUID().toString();
        this.rtcToken = rtcToken;
        this.mPingManager = rtcPingManager;
        this.mRoomConfig = config;
        this.mOtherRoomIdsMap = new ConcurrentHashMap<String, String>();
        if (otherRoomIds != null && otherRoomIds.size() > 0) {
            for (String id : otherRoomIds) {
                this.mOtherRoomIdsMap.put(id, id);
            }
        }
    }

    public RCRTCRoomConfig getRoomConfig() {
        return this.mRoomConfig;
    }
}

