/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.webview;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.WXWeb;
import com.taobao.weex.ui.view.IWebView;
import com.taobao.weex.utils.WXResourceUtils;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaWebview;
import io.dcloud.common.adapter.ui.webview.WebViewFactory;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.feature.weex.WeexInstanceMgr;
import io.dcloud.feature.weex.adapter.webview.DCWXWebView;
import io.dcloud.feature.weex.adapter.webview.IDCWebView;
import java.util.HashMap;
import java.util.Map;

@Component(lazyload=false)
public class WXDCWeb
extends WXWeb {
    private JSONObject mWebStyles;
    IDCWebView mDCWebView;

    public WXDCWeb(WXSDKInstance instance, WXVContainer parent, boolean isLazy, BasicComponentData basicComponentData) {
        super(instance, parent, isLazy, basicComponentData);
    }

    @Override
    protected void createWebView() {
        Object ob;
        String origin = null;
        try {
            String bundleUrl = WXSDKManager.getInstance().getSDKInstance(this.getInstanceId()).getBundleUrl();
            Uri uri = Uri.parse((String)bundleUrl);
            String scheme = uri.getScheme();
            String authority = uri.getAuthority();
            if (!TextUtils.isEmpty((CharSequence)scheme) && !TextUtils.isEmpty((CharSequence)authority)) {
                origin = scheme + "://" + authority;
            }
        }
        catch (Exception bundleUrl) {
            // empty catch block
        }
        if (WebViewFactory.isIsOtherInitSuccess() && (ob = PlatformUtil.newInstance((String)"io.dcloud.feature.x5.DCWXX5WebView", (Class[])new Class[]{Context.class, String.class, WXDCWeb.class}, (Object[])new Object[]{this.getInstance().getUIContext(), origin, this})) != null && ob instanceof IWebView) {
            this.mDCWebView = (IDCWebView)ob;
            this.mWebView = this.mDCWebView;
        }
        if (this.mWebView == null) {
            this.mDCWebView = new DCWXWebView(this.getInstance().getUIContext(), origin, this);
            this.mWebView = this.mDCWebView;
        }
    }

    @Override
    protected View initComponentHostView(@NonNull Context context) {
        OnDCMessageListener listener = new OnDCMessageListener(){

            @Override
            public void onMessage(Map<String, Object> params, int type) {
                switch (type) {
                    case 1: {
                        WXDCWeb.this.fireEvent("onPostMessage", params);
                        break;
                    }
                    case 2: {
                        WXSDKInstance instance = WeexInstanceMgr.self().findWXSDKInstance("__uniapp__service");
                        if (instance == null) break;
                        params.put("ref", WXDCWeb.this.getRef());
                        params.put("id", WXDCWeb.this.getInstance().getInstanceId());
                        instance.fireGlobalEventCallback("WebviewPostMessage", params);
                        break;
                    }
                }
            }
        };
        PlatformUtil.invokeMethod((Object)this.mWebView, (String)"setOnDCMessageListener", (Class[])new Class[]{OnDCMessageListener.class}, (Object[])new Object[]{listener});
        this.mWebView.setOnErrorListener(new IWebView.OnErrorListener(){

            @Override
            public void onError(String type, Object message) {
                WXDCWeb.this.fireEvent(type, message);
            }
        });
        this.mWebView.setOnPageListener(new IWebView.OnPageListener(){

            @Override
            public void onReceivedTitle(String title) {
                if (WXDCWeb.this.getEvents().contains("receivedtitle")) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("title", title);
                    HashMap<String, Object> detail = new HashMap<String, Object>();
                    detail.put("detail", params);
                    WXDCWeb.this.fireEvent("receivedtitle", detail);
                }
            }

            @Override
            public void onPageStart(String url) {
                if (WXDCWeb.this.getEvents().contains("pagestart")) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("url", url);
                    HashMap<String, Object> detail = new HashMap<String, Object>();
                    detail.put("detail", params);
                    WXDCWeb.this.fireEvent("pagestart", detail);
                }
            }

            @Override
            public void onPageFinish(String url, boolean canGoBack, boolean canGoForward) {
                if (WXDCWeb.this.getEvents().contains("pagefinish")) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("url", url);
                    params.put("canGoBack", canGoBack);
                    params.put("canGoForward", canGoForward);
                    HashMap<String, Object> detail = new HashMap<String, Object>();
                    detail.put("detail", params);
                    WXDCWeb.this.fireEvent("pagefinish", detail);
                }
            }
        });
        this.mWebView.setOnMessageListener(new IWebView.OnMessageListener(){

            @Override
            public void onMessage(Map<String, Object> params) {
                HashMap<String, Object> detail = new HashMap<String, Object>();
                detail.put("detail", params);
                WXDCWeb.this.fireEvent("message", detail);
            }
        });
        View view = this.mWebView.getView();
        if (!TextUtils.isEmpty((CharSequence)AdaWebview.sCustomUserAgent)) {
            this.mDCWebView.setUserAgent(AdaWebview.sCustomUserAgent, true);
        } else {
            IWebview iWebview = WeexInstanceMgr.self().findWebview(this.getInstance());
            if (iWebview != null) {
                String customeUA = iWebview.obtainApp().obtainConfigProperty("useragent");
                boolean concatenate = Boolean.parseBoolean(iWebview.obtainApp().obtainConfigProperty("concatenate"));
                this.mDCWebView.setUserAgent(customeUA, concatenate);
            }
        }
        return view;
    }

    private void fireEvent(String type, Object message) {
        if (this.getEvents().contains("error")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("type", type);
            params.put("errorMsg", message);
            HashMap<String, Object> detail = new HashMap<String, Object>();
            detail.put("detail", params);
            this.fireEvent("error", detail);
        }
    }

    @JSMethod
    public void evalJs(String js) {
        if (this.mWebView != null) {
            String jsp = "javascript:(function(){";
            if (!js.startsWith(jsp)) {
                js = jsp + js + ";})();";
            }
            this.mWebView.loadUrl(js);
        }
    }

    @JSMethod
    public void evalJS(String js) {
        this.evalJs(js);
    }

    @Override
    protected void loadUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url) && url.startsWith("asset:///")) {
            url = url.replace("asset:///", "file:///android_asset/");
        }
        super.loadUrl(url);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mWebView != null) {
            this.mWebView.onActivityResult(requestCode, resultCode, data);
        }
    }

    @WXComponentProp(name="webviewStyles")
    public void webviewStyles(String styles) {
        JSONObject object;
        if (this.mWebStyles == null) {
            this.mWebStyles = new JSONObject();
        }
        if ((object = JSON.parseObject((String)styles)) != null && object.containsKey((Object)"progress")) {
            Object v = object.get((Object)"progress");
            if (v instanceof Boolean) {
                this.mWebStyles.put("isProgress", (Object)((Boolean)v));
            } else if (v instanceof JSONObject) {
                JSONObject sj = (JSONObject)v;
                this.mWebStyles.put("isProgress", (Object)true);
                if (sj.containsKey((Object)"color")) {
                    this.mWebStyles.put("progressColor", (Object)sj.getString("color"));
                }
            }
        }
    }

    public JSONObject getWebStyles() {
        if (this.mWebStyles == null) {
            this.mWebStyles = new JSONObject();
            this.mWebStyles.put("isProgress", (Object)true);
        }
        return this.mWebStyles;
    }

    @Override
    public void setBackgroundColor(String color2) {
        super.setBackgroundColor(color2);
        if (!TextUtils.isEmpty((CharSequence)color2) && this.mDCWebView != null) {
            int colorInt = WXResourceUtils.getColor(color2);
            if (this.mDCWebView.getWebView() != null) {
                this.mDCWebView.getWebView().setBackgroundColor(colorInt);
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mDCWebView = null;
    }

    public static interface OnDCMessageListener {
        public void onMessage(Map<String, Object> var1, int var2);
    }
}

