/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.connection;

import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

public class FileDownloadUrlConnection
implements FileDownloadConnection {
    protected URLConnection mConnection;

    public FileDownloadUrlConnection(String originUrl, Configuration configuration) throws IOException {
        this(new URL(originUrl), configuration);
    }

    public FileDownloadUrlConnection(URL url, Configuration configuration) throws IOException {
        this.mConnection = configuration != null && configuration.proxy != null ? url.openConnection(configuration.proxy) : url.openConnection();
        if (this.mConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.mConnection).setInstanceFollowRedirects(false);
        }
        if (configuration != null) {
            if (configuration.readTimeout != null) {
                this.mConnection.setReadTimeout(configuration.readTimeout);
            }
            if (configuration.connectTimeout != null) {
                this.mConnection.setConnectTimeout(configuration.connectTimeout);
            }
        }
    }

    public FileDownloadUrlConnection(String originUrl) throws IOException {
        this(originUrl, null);
    }

    @Override
    public void addHeader(String name, String value) {
        this.mConnection.addRequestProperty(name, value);
    }

    @Override
    public boolean dispatchAddResumeOffset(String etag, long offset) {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.mConnection.getInputStream();
    }

    @Override
    public Map<String, List<String>> getRequestHeaderFields() {
        return this.mConnection.getRequestProperties();
    }

    @Override
    public Map<String, List<String>> getResponseHeaderFields() {
        return this.mConnection.getHeaderFields();
    }

    @Override
    public String getResponseHeaderField(String name) {
        return this.mConnection.getHeaderField(name);
    }

    @Override
    public boolean setRequestMethod(String method) throws ProtocolException {
        if (this.mConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.mConnection).setRequestMethod(method);
            return true;
        }
        return false;
    }

    @Override
    public void execute() throws IOException {
        this.mConnection.connect();
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.mConnection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.mConnection).getResponseCode();
        }
        return 0;
    }

    @Override
    public void ending() {
        try {
            this.mConnection.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Configuration {
        private Proxy proxy;
        private Integer readTimeout;
        private Integer connectTimeout;

        public Configuration proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Configuration readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Configuration connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }
    }

    public static class Creator
    implements FileDownloadHelper.ConnectionCreator {
        private final Configuration mConfiguration;

        public Creator() {
            this(null);
        }

        public Creator(Configuration configuration) {
            this.mConfiguration = configuration;
        }

        FileDownloadConnection create(URL url) throws IOException {
            return new FileDownloadUrlConnection(url, this.mConfiguration);
        }

        @Override
        public FileDownloadConnection create(String originUrl) throws IOException {
            return new FileDownloadUrlConnection(originUrl, this.mConfiguration);
        }
    }
}

