/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.message;

import com.liulishuo.filedownloader.message.IFlowDirectly;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.message.MessageSnapshotThreadPool;

public class MessageSnapshotFlow {
    private volatile MessageSnapshotThreadPool flowThreadPool;
    private volatile MessageReceiver receiver;

    public static MessageSnapshotFlow getImpl() {
        return HolderClass.INSTANCE;
    }

    public void setReceiver(MessageReceiver receiver) {
        this.receiver = receiver;
        this.flowThreadPool = receiver == null ? null : new MessageSnapshotThreadPool(5, receiver);
    }

    public void inflow(MessageSnapshot snapshot) {
        if (snapshot instanceof IFlowDirectly) {
            if (this.receiver != null) {
                this.receiver.receive(snapshot);
            }
        } else if (this.flowThreadPool != null) {
            this.flowThreadPool.execute(snapshot);
        }
    }

    public static interface MessageReceiver {
        public void receive(MessageSnapshot var1);
    }

    public static final class HolderClass {
        private static final MessageSnapshotFlow INSTANCE = new MessageSnapshotFlow();
    }
}

