/*
 * Decompiled with CFR 0.152.
 */
package com.wonderkiln.camerakit.api16;

import android.graphics.YuvImage;
import android.hardware.Camera;
import com.wonderkiln.camerakit.utils.Rotation;

class ProcessStillTask
implements Runnable {
    private byte[] data;
    private Camera camera;
    private int rotation;
    private OnStillProcessedListener onStillProcessedListener;

    public ProcessStillTask(byte[] data, Camera camera, int rotation, OnStillProcessedListener onStillProcessedListener) {
        this.data = data;
        this.camera = camera;
        this.rotation = rotation;
        this.onStillProcessedListener = onStillProcessedListener;
    }

    @Override
    public void run() {
        int postHeight;
        int postWidth;
        Camera.Parameters parameters = this.camera.getParameters();
        int width = parameters.getPreviewSize().width;
        int height = parameters.getPreviewSize().height;
        byte[] rotatedData = new Rotation(this.data, width, height, this.rotation).getYuv();
        switch (this.rotation) {
            case 90: 
            case 270: {
                postWidth = height;
                postHeight = width;
                break;
            }
            default: {
                postWidth = width;
                postHeight = height;
            }
        }
        YuvImage yuv = new YuvImage(rotatedData, parameters.getPreviewFormat(), postWidth, postHeight, null);
        this.onStillProcessedListener.onStillProcessed(yuv);
    }

    static interface OnStillProcessedListener {
        public void onStillProcessed(YuvImage var1);
    }
}

