/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.midifile;

import com.jinmingyunle.midiplaylib.midifile.MidiEvent;
import com.jinmingyunle.midiplaylib.midifile.MidiFile;
import com.jinmingyunle.midiplaylib.midifile.MidiNote;
import java.util.ArrayList;

public class MidiTrack
implements Comparable<MidiTrack> {
    private int tracknum;
    private ArrayList<MidiNote> notes;
    private int instrument;
    private String trackName;
    private ArrayList<MidiEvent> lyrics;
    private int time = 0;

    public MidiTrack(int tracknum) {
        this.tracknum = tracknum;
        this.notes = new ArrayList(20);
        this.instrument = 0;
    }

    public MidiTrack(ArrayList<MidiEvent> events, int tracknum) {
        this.tracknum = tracknum;
        this.notes = new ArrayList(events.size());
        this.instrument = -1;
        this.time = 0;
        this.time = events.get((int)(events.size() - 1)).StartTime + events.get((int)(events.size() - 1)).DeltaTime;
        for (MidiEvent mevent : events) {
            if (mevent.EventFlag == -112 && mevent.Velocity > 0) {
                MidiNote note = new MidiNote(mevent.StartTime, mevent.Channel, mevent.Notenumber, 0);
                this.AddNote(note);
                continue;
            }
            if (mevent.EventFlag == -112 && mevent.Velocity == 0) {
                this.NoteOff(mevent.Channel, mevent.Notenumber, mevent.StartTime);
                continue;
            }
            if (mevent.EventFlag == -128) {
                this.NoteOff(mevent.Channel, mevent.Notenumber, mevent.StartTime);
                continue;
            }
            if (mevent.EventFlag == -64) {
                this.instrument = mevent.Instrument;
                continue;
            }
            if (mevent.Metaevent == 5) {
                this.AddLyric(mevent);
                if (this.lyrics == null) {
                    this.lyrics = new ArrayList();
                }
                this.lyrics.add(mevent);
                continue;
            }
            if (mevent.Metaevent == 3) {
                this.trackName = new String(mevent.Value);
                continue;
            }
            if (mevent.Metaevent != 4) continue;
        }
        if (this.notes.size() > 0 && this.notes.get(0).getChannel() == 9) {
            this.instrument = 128;
        }
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public String getTrackName() {
        return this.trackName;
    }

    public void setTrackName(String trackName) {
        this.trackName = trackName;
    }

    public int trackNumber() {
        return this.tracknum;
    }

    public ArrayList<MidiNote> getNotes() {
        return this.notes;
    }

    public int getInstrument() {
        return this.instrument;
    }

    public void setInstrument(int value) {
        this.instrument = value;
    }

    public ArrayList<MidiEvent> getLyrics() {
        return this.lyrics;
    }

    public void setLyrics(ArrayList<MidiEvent> value) {
        this.lyrics = value;
    }

    public String getInstrumentName() {
        if (this.instrument >= 0 && this.instrument <= 128) {
            return MidiFile.Instruments[this.instrument];
        }
        return "";
    }

    public void AddNote(MidiNote m) {
        this.notes.add(m);
    }

    public void NoteOff(int channel, int notenumber, int endtime) {
        for (int i = this.notes.size() - 1; i >= 0; --i) {
            MidiNote note = this.notes.get(i);
            if (note.getChannel() != channel || note.getNumber() != notenumber || note.getDuration() != 0) continue;
            note.NoteOff(endtime);
            return;
        }
    }

    public void AddLyric(MidiEvent mevent) {
        if (this.lyrics == null) {
            this.lyrics = new ArrayList();
        }
        this.lyrics.add(mevent);
    }

    public MidiTrack Clone() {
        MidiTrack track = new MidiTrack(this.trackNumber());
        track.instrument = this.instrument;
        for (MidiNote note : this.notes) {
            track.notes.add(note.Clone());
        }
        if (this.lyrics != null) {
            track.lyrics = new ArrayList();
            for (MidiEvent ev : this.lyrics) {
                track.lyrics.add(ev);
            }
        }
        return track;
    }

    public String toString() {
        String result = "Track number=" + this.tracknum + " instrument=" + this.instrument + "\n";
        for (MidiNote n : this.notes) {
            result = result + n + "\n";
        }
        result = result + "End Track\n";
        return result;
    }

    @Override
    public int compareTo(MidiTrack o) {
        int target;
        int original = this.getInstrument();
        if (original > (target = o.getInstrument())) {
            return 1;
        }
        if (original < target) {
            return -1;
        }
        return 0;
    }
}

