/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.utils;

public class DictInt {
    private int[] keys;
    private int[] values;
    private int size = 0;
    private int lastpos;

    public DictInt() {
        int amount = 23;
        this.lastpos = 0;
        this.keys = new int[amount];
        this.values = new int[amount];
    }

    private void resize() {
        int newcapacity = this.keys.length * 2;
        int[] newkeys = new int[newcapacity];
        int[] newvalues = new int[newcapacity];
        for (int i = 0; i < this.keys.length; ++i) {
            newkeys[i] = this.keys[i];
            newvalues[i] = this.values[i];
        }
        this.keys = newkeys;
        this.values = newvalues;
    }

    public void add(int key, int value) {
        if (this.size == this.keys.length) {
            this.resize();
        }
        for (int pos = this.size - 1; pos >= 0 && key < this.keys[pos]; --pos) {
            this.keys[pos + 1] = this.keys[pos];
            this.values[pos + 1] = this.values[pos];
        }
        this.keys[pos + 1] = key;
        this.values[pos + 1] = value;
        ++this.size;
    }

    public void set(int key, int value) {
        if (this.contains(key)) {
            this.keys[this.lastpos] = key;
            this.values[this.lastpos] = value;
        } else {
            this.add(key, value);
        }
    }

    public boolean contains(int key) {
        if (this.size == 0) {
            return false;
        }
        if (this.lastpos < 0 || this.lastpos >= this.size || key < this.keys[this.lastpos]) {
            this.lastpos = 0;
        }
        while (this.lastpos < this.size && key > this.keys[this.lastpos]) {
            ++this.lastpos;
        }
        return this.lastpos < this.size && key == this.keys[this.lastpos];
    }

    public int get(int key) {
        if (this.contains(key)) {
            return this.values[this.lastpos];
        }
        return 0;
    }

    public int count() {
        return this.size;
    }

    public int getKey(int index) {
        return this.keys[index];
    }
}

