/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.TextView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.dom.CSSConstants;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.ConfirmBar;
import com.taobao.weex.ui.component.DCWXInput;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXEditText;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.feature.weex.WeexInstanceMgr;
import java.util.HashMap;

public class DCTextArea
extends DCWXInput {
    private boolean isAutoHeight = false;
    private WXAttr attr;
    private boolean isLineChange = false;
    private WXComponent.OnFocusChangeListener mOnFocusChangeListener = new WXComponent.OnFocusChangeListener(){
        int count = 0;

        @Override
        public void onFocusChange(boolean hasFocus) {
            TextView text = (TextView)DCTextArea.this.getHostView();
            if (text == null) {
                return;
            }
            HashMap<String, Object> ret = new HashMap<String, Object>(1);
            HashMap<String, Object> sub = new HashMap<String, Object>(1);
            sub.put("value", text.getText().toString());
            if (hasFocus) {
                if (DCTextArea.this.keyboardHeight == 0.0f) {
                    this.fireEventForFocus(text);
                } else {
                    sub.put("height", Float.valueOf(DCTextArea.this.keyboardHeight));
                    sub.put("value", text.getText().toString());
                    ret.put("detail", sub);
                    DCTextArea.this.fireEvent("focus", ret);
                }
            } else {
                sub.put("cursor", text.getSelectionStart());
                ret.put("detail", sub);
                DCTextArea.this.fireEvent("blur", ret);
            }
        }

        private void fireEventForFocus(final TextView text) {
            ((WXEditText)DCTextArea.this.getHostView()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (DCTextArea.this.keyboardHeight == 0.0f) {
                        ++count;
                        if (count > 3) {
                            HashMap<String, Object> ret = new HashMap<String, Object>(1);
                            HashMap<String, Object> sub = new HashMap<String, Object>(1);
                            sub.put("value", text.getText().toString());
                            sub.put("height", Float.valueOf(DCTextArea.this.keyboardHeight));
                            ret.put("detail", sub);
                            DCTextArea.this.fireEvent("focus", ret);
                            return;
                        }
                        this.fireEventForFocus(text);
                    } else {
                        count = 0;
                        HashMap<String, Object> ret = new HashMap<String, Object>(1);
                        HashMap<String, Object> sub = new HashMap<String, Object>(1);
                        sub.put("value", text.getText().toString());
                        sub.put("height", Float.valueOf(DCTextArea.this.keyboardHeight));
                        ret.put("detail", sub);
                        DCTextArea.this.fireEvent("focus", ret);
                    }
                }
            }, 200L);
        }
    };
    boolean isShowConfirm = true;

    public DCTextArea(WXSDKInstance instance, WXVContainer parent, boolean isLazy, BasicComponentData basicComponentData) {
        super(instance, parent, isLazy, basicComponentData);
        this.attr = basicComponentData.getAttrs();
        this.setContentBoxMeasurement(new ContentBoxMeasurement(){

            @Override
            public void measureInternal(float width, float height, int widthMeasureMode, int heightMeasureMode) {
                if (CSSConstants.isUndefined(width)) {
                    this.mMeasureWidth = WXViewUtils.getRealPxByWidth(300.0f, DCTextArea.this.getInstance().getInstanceViewPortWidthWithFloat());
                }
                if (CSSConstants.isUndefined(height)) {
                    this.mMeasureHeight = DCTextArea.this.attr.containsKey("autoHeight") && WXUtils.getBoolean(DCTextArea.this.attr.get("autoHeight"), false) != false ? WXViewUtils.getRealPxByWidth((float)DCTextArea.this.getInstance().getDefaultFontSize() * 1.4f, DCTextArea.this.getInstance().getInstanceViewPortWidthWithFloat()) : WXViewUtils.getRealPxByWidth(150.0f, DCTextArea.this.getInstance().getInstanceViewPortWidthWithFloat());
                }
            }

            @Override
            public void layoutBefore() {
            }

            @Override
            public void layoutAfter(float computedWidth, float computedHeight) {
            }
        });
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (type.equals("linechange")) {
            this.isLineChange = true;
        }
    }

    @Override
    protected void setFocusAndBlur() {
        if (!this.ismHasFocusChangeListener(this.mOnFocusChangeListener)) {
            this.addFocusChangeListener(this.mOnFocusChangeListener);
        }
    }

    @Override
    protected void onHostViewInitialized(WXEditText host) {
        this.isNeedConfirm = false;
        host.setAllowDisableMovement(false);
        super.onHostViewInitialized(host);
        try {
            ConfirmBar.getInstance().createConfirmBar(this.getContext(), WeexInstanceMgr.self().findWebview(this.getInstance()).obtainApp());
            ConfirmBar.getInstance().addComponent(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.attr.containsKey("autoHeight") && WXUtils.getBoolean(this.attr.get("autoHeight"), false).booleanValue()) {
            float width = WXViewUtils.getRealPxByWidth((float)this.getInstance().getDefaultFontSize() * 1.4f, this.getInstance().getInstanceViewPortWidthWithFloat());
            WXBridgeManager.getInstance().setStyleHeight(this.getInstanceId(), this.getRef(), width);
        }
        this.watchLine();
    }

    private void watchLine() {
        this.addTextChangedListener(new TextWatcher(){
            int line = 0;

            public void beforeTextChanged(CharSequence s, int start, int count1, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (((WXEditText)DCTextArea.this.getHostView()).getLineCount() != this.line) {
                    this.line = ((WXEditText)DCTextArea.this.getHostView()).getLineCount();
                    int padding = ((WXEditText)DCTextArea.this.getHostView()).getExtendedPaddingTop() + ((WXEditText)DCTextArea.this.getHostView()).getExtendedPaddingBottom();
                    float height = ((WXEditText)DCTextArea.this.getHostView()).getLayout().getLineTop(((WXEditText)DCTextArea.this.getHostView()).getLineCount()) + padding;
                    if (padding == 0 && DCTextArea.this.isAutoHeight) {
                        height = (float)((WXEditText)DCTextArea.this.getHostView()).getLayout().getLineTop(((WXEditText)DCTextArea.this.getHostView()).getLineCount() - 1) + WXViewUtils.getRealPxByWidth((float)DCTextArea.this.getInstance().getDefaultFontSize() * 1.4f, DCTextArea.this.getInstance().getInstanceViewPortWidthWithFloat());
                    }
                    if (DCTextArea.this.isAutoHeight && height > 0.0f) {
                        WXBridgeManager.getInstance().setStyleHeight(DCTextArea.this.getInstanceId(), DCTextArea.this.getRef(), height);
                        WXBridgeManager.getInstance().notifyLayout(DCTextArea.this.getInstanceId());
                        WXBridgeManager.getInstance().forceLayout(DCTextArea.this.getInstanceId());
                    }
                    if (!DCTextArea.this.isLineChange) {
                        return;
                    }
                    HashMap<String, Number> values = new HashMap<String, Number>(3);
                    values.put("lineCount", this.line);
                    values.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth(height, DCTextArea.this.getInstance().getInstanceViewPortWidthWithFloat())));
                    values.put("heightRpx", Float.valueOf(height));
                    HashMap<String, Object> detail = new HashMap<String, Object>(1);
                    detail.put("detail", values);
                    DCTextArea.this.fireEvent("linechange", detail);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    @Override
    protected void appleStyleAfterCreated(WXEditText editText) {
        super.appleStyleAfterCreated(editText);
        editText.setSingleLine(false);
        editText.setMinLines(1);
        editText.setMaxLines(100);
        editText.setInputType(131073);
    }

    @Override
    protected void setHostLayoutParams(WXEditText host, int width, int height, int left, int right, int top, int bottom) {
        super.setHostLayoutParams(host, width, height, left, right, top, bottom);
    }

    @Override
    protected int getVerticalGravity() {
        return 48;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        this.isConfirmHold = WXUtils.getBoolean(param, true);
        return super.setProperty(key, param);
    }

    @Override
    public void setType(String type) {
        if (this.getHostView() != null) {
            if (type == null || this.getHostView() == null || this.mType.equals(type)) {
                return;
            }
            ((WXEditText)this.getHostView()).setInputType(131073);
        }
    }

    @WXComponentProp(name="autoHeight")
    public void setAutoHeight(boolean isAuto) {
        this.isAutoHeight = isAuto;
    }

    @Override
    public void setSingleLine(boolean singleLine) {
        ((WXEditText)this.getHostView()).setSingleLine(false);
    }

    @Override
    protected float getMeasureHeight() {
        if (this.isAutoHeight) {
            return this.getMeasuredLineHeight();
        }
        return super.getMeasureHeight();
    }

    @WXComponentProp(name="showConfirmBar")
    public void setShowConfirmBar(boolean isShowC) {
        this.isShowConfirm = isShowC;
    }

    @Override
    public void destroy() {
        super.destroy();
        ConfirmBar.getInstance().removeComponent(this);
    }
}

