/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.base;

import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.utils.FinLog;
import java.util.concurrent.locks.LockSupport;

public class AsyncResult<T> {
    private static final String TAG = "DataResult";
    private final T data;
    private final RTCErrorCode errorCode;

    private AsyncResult(T data, RTCErrorCode errorCode) {
        this.data = data;
        this.errorCode = errorCode;
    }

    public boolean isFailed() {
        return this.errorCode != null;
    }

    public T getData() {
        return this.data;
    }

    public RTCErrorCode getErrorCode() {
        return this.errorCode;
    }

    public static <V> TemporaryResult<V> create() {
        return new TemporaryResult(null, null);
    }

    public static <V> TemporaryResult<V> create(Thread workThread) {
        return new TemporaryResult(workThread, null);
    }

    public static <V> TemporaryResult<V> createByCurrentThread() {
        return new TemporaryResult(Thread.currentThread(), null);
    }

    public static AsyncResult convert(AsyncResult res) {
        return res;
    }

    public static TemporaryResult create(Thread workThread, RTCErrorCode defaultErrorCode) {
        return new TemporaryResult(workThread, defaultErrorCode);
    }

    public static TemporaryResult create(RTCErrorCode defaultErrorCode) {
        return new TemporaryResult(null, defaultErrorCode);
    }

    public static <V> TemporaryResult<V> create(V data) {
        return new TemporaryResult<V>(data);
    }

    public static <V> TemporaryResult<V> create(Thread workThread, V data) {
        return new TemporaryResult<V>(workThread, null, data);
    }

    public static class TemporaryResult<T> {
        public volatile T data;
        public volatile RTCErrorCode errorCode;
        private final Thread workThread;
        private RTCErrorCode defaultErrorCode;

        private TemporaryResult(Thread thread, RTCErrorCode defaultErrorCode) {
            this.workThread = thread;
            this.errorCode = this.defaultErrorCode = defaultErrorCode;
        }

        public TemporaryResult(T data) {
            this.data = data;
            this.workThread = null;
        }

        public TemporaryResult(Thread workThread, RTCErrorCode errorCode, T data) {
            this.data = data;
            this.errorCode = errorCode;
            this.workThread = workThread;
        }

        public synchronized void setAndNotify(T data) {
            this.data = data;
            this.errorCode = null;
            this.notifyThread();
        }

        public synchronized void setAndNotify(RTCErrorCode errorCode) {
            this.errorCode = errorCode;
            this.notifyThread();
        }

        public void notifyThread() {
            if (this.workThread != null) {
                LockSupport.unpark(this.workThread);
            }
        }

        public AsyncResult<T> waitForGetResult() {
            FinLog.d(AsyncResult.TAG, "[waitForGetResult] workThread: " + this.workThread);
            if (this.workThread != null) {
                LockSupport.park();
            }
            return this.getResult();
        }

        public synchronized AsyncResult<T> getResult() {
            FinLog.d(AsyncResult.TAG, "[getResult] data: " + this.data + " , errorCode: " + (Object)((Object)this.errorCode));
            return new AsyncResult(this.data, this.errorCode);
        }

        public void reset() {
            this.data = null;
            this.errorCode = this.defaultErrorCode;
        }
    }
}

