/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.custom;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.media.Image;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.custom.MediaVideoDecoder;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MediaVideoDecoder21
extends MediaVideoDecoder {
    private static final String TAG = "MediaVideoDecoder21";
    private MediaExtractor mVideoExtractor;
    private MediaCodec mVideoDecoder;
    private MediaFormat mVideoFormat = null;
    private int width;
    private int height;
    private int rotation;
    private boolean stopped = false;
    private HandlerThread handlerThread = new HandlerThread("AudioDecoder");
    private Handler handler;
    private ConsumeThread mConsumeThread;
    private BlockingQueue<DecoderData> mBufferQueue = new LinkedBlockingQueue<DecoderData>(10);

    @Override
    public boolean init(final FileDescriptor fd, final long offset, final long len) {
        this.handlerThread.start();
        Looper looper = this.handlerThread.getLooper();
        if (null == looper) {
            ReportUtil.libError(ReportUtil.TAG.CREATEHDVIDEODECODER, "reason", "handlerThread looper is null");
            this.handlerThread.quit();
            return false;
        }
        this.handler = new Handler(looper);
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                block11: {
                    try {
                        MediaVideoDecoder21.this.mConsumeThread = new ConsumeThread("ConsumeThread");
                        MediaVideoDecoder21.this.mVideoExtractor = new MediaExtractor();
                        MediaVideoDecoder21.this.mVideoExtractor.setDataSource(fd, offset, len);
                        int videoTrackIndex = MediaVideoDecoder21.this.selectVideoTrack(MediaVideoDecoder21.this.mVideoExtractor);
                        if (videoTrackIndex < 0) {
                            try {
                                MediaVideoDecoder21.this.mVideoExtractor.release();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            FinLog.d(MediaVideoDecoder21.TAG, "Video track not found, index=" + videoTrackIndex);
                            return;
                        }
                        MediaVideoDecoder21.this.mVideoFormat = MediaVideoDecoder21.this.mVideoExtractor.getTrackFormat(videoTrackIndex);
                        MediaVideoDecoder21.this.width = MediaVideoDecoder21.this.mVideoFormat.getInteger("width");
                        MediaVideoDecoder21.this.height = MediaVideoDecoder21.this.mVideoFormat.getInteger("height");
                        MediaVideoDecoder21.this.rotation = MediaVideoDecoder21.this.mVideoFormat.containsKey("rotation-degrees") ? MediaVideoDecoder21.this.mVideoFormat.getInteger("rotation-degrees") : 0;
                        String videoMimeType = MediaVideoDecoder21.this.mVideoFormat.getString("mime");
                        String decoderName = MediaVideoDecoder21.this.findDecoder(videoMimeType);
                        if (decoderName == null) {
                            FinLog.d(MediaVideoDecoder21.TAG, "Video decoder not found, mime=" + videoMimeType);
                            return;
                        }
                        MediaVideoDecoder21.this.mVideoDecoder = MediaCodec.createByCodecName((String)decoderName);
                        MediaVideoDecoder21.this.mVideoFormat.setInteger("color-format", 2135033992);
                        MediaVideoDecoder21.this.mVideoDecoder.configure(MediaVideoDecoder21.this.mVideoFormat, null, null, 0);
                        MediaVideoDecoder21.this.setVideoDecoderCallback();
                    }
                    catch (IOException e) {
                        FinLog.d(MediaVideoDecoder21.TAG, "Init failed: " + e.getMessage());
                        if (MediaVideoDecoder21.this.mVideoDecoder != null) {
                            try {
                                MediaVideoDecoder21.this.mVideoDecoder.release();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (MediaVideoDecoder21.this.mVideoExtractor == null) break block11;
                        try {
                            MediaVideoDecoder21.this.mVideoExtractor.release();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        return this.mVideoDecoder != null;
    }

    @Override
    public void start() {
        if (this.handler == null) {
            throw new IllegalStateException("Have not call init.");
        }
        if (this.mOnFrameAvailableListener == null) {
            throw new IllegalArgumentException("It's necessary to set an OnFrameAvailableListener.");
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (MediaVideoDecoder21.this.mVideoDecoder != null) {
                    MediaVideoDecoder21.this.mVideoDecoder.start();
                }
                if (MediaVideoDecoder21.this.mConsumeThread != null) {
                    MediaVideoDecoder21.this.mConsumeThread.start();
                }
            }
        });
    }

    @Override
    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.handler == null) {
            throw new IllegalStateException("Have not start decode.");
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                FinLog.e(MediaVideoDecoder21.TAG, "T-stop");
                if (MediaVideoDecoder21.this.mVideoDecoder != null) {
                    try {
                        MediaVideoDecoder21.this.mVideoDecoder.stop();
                    }
                    catch (Exception e) {
                        FinLog.e(MediaVideoDecoder21.TAG, "Media Decoder stop failed" + e.getMessage());
                        e.printStackTrace();
                    }
                    try {
                        MediaVideoDecoder21.this.mVideoDecoder.release();
                    }
                    catch (Exception e) {
                        FinLog.e(MediaVideoDecoder21.TAG, "Media Decoder release failed" + e.getMessage());
                        e.printStackTrace();
                    }
                }
                MediaVideoDecoder21.this.mVideoDecoder = null;
                if (MediaVideoDecoder21.this.mVideoExtractor != null) {
                    try {
                        MediaVideoDecoder21.this.mVideoExtractor.release();
                    }
                    catch (Exception e) {
                        FinLog.e(MediaVideoDecoder21.TAG, "VideoExtractor release failed" + e.getMessage());
                        e.printStackTrace();
                    }
                }
                MediaVideoDecoder21.this.mVideoExtractor = null;
                if (MediaVideoDecoder21.this.mConsumeThread != null) {
                    MediaVideoDecoder21.this.mConsumeThread.release();
                }
                MediaVideoDecoder21.this.mBufferQueue.clear();
                MediaVideoDecoder21.this.mConsumeThread = null;
                MediaVideoDecoder21.this.handler.getLooper().quit();
                MediaVideoDecoder21.this.handler = null;
                MediaVideoDecoder21.this.mOnFrameAvailableListener = null;
            }
        });
    }

    private String findDecoder(String mime) {
        int codecCount = MediaCodecList.getCodecCount();
        for (int i = 0; i < codecCount; ++i) {
            String[] supportedTypes;
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (codecInfo == null || codecInfo.isEncoder()) continue;
            for (String type : supportedTypes = codecInfo.getSupportedTypes()) {
                if (!type.equals(mime)) continue;
                return codecInfo.getName();
            }
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private void setVideoDecoderCallback() {
        if (this.mVideoDecoder == null) {
            return;
        }
        this.mVideoDecoder.setCallback(new MediaCodec.Callback(){

            public void onInputBufferAvailable(MediaCodec codec, int index) {
                if (MediaVideoDecoder21.this.stopped) {
                    return;
                }
                try {
                    ByteBuffer inputBuffer = codec.getInputBuffer(index);
                    if (inputBuffer == null) {
                        return;
                    }
                    inputBuffer.clear();
                    int readSize = MediaVideoDecoder21.this.mVideoExtractor.readSampleData(inputBuffer, 0);
                    if (readSize >= 0) {
                        codec.queueInputBuffer(index, 0, readSize, MediaVideoDecoder21.this.mVideoExtractor.getSampleTime(), MediaVideoDecoder21.this.mVideoExtractor.getSampleFlags());
                        MediaVideoDecoder21.this.mVideoExtractor.advance();
                    } else {
                        codec.queueInputBuffer(index, 0, 0, 0L, 4);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
                block7: {
                    if (MediaVideoDecoder21.this.stopped) {
                        return;
                    }
                    try {
                        ByteBuffer outputBuffer = codec.getOutputBuffer(index);
                        if (outputBuffer == null) break block7;
                        if ((info.flags & 4) != 0) {
                            if (MediaVideoDecoder21.this.mOnFrameAvailableListener != null) {
                                MediaVideoDecoder21.this.mOnFrameAvailableListener.onFrameEnd();
                            }
                            return;
                        }
                        DecoderData decoderData = new DecoderData();
                        decoderData.data = MediaVideoDecoder21.getDataFromImage(codec.getOutputImage(index));
                        decoderData.presentationTime = info.presentationTimeUs / 1000L;
                        try {
                            MediaVideoDecoder21.this.mBufferQueue.put(decoderData);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        codec.releaseOutputBuffer(index, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onError(MediaCodec codec, MediaCodec.CodecException e) {
            }

            public void onOutputFormatChanged(MediaCodec codec, MediaFormat format) {
            }
        });
    }

    @TargetApi(value=21)
    private static byte[] getDataFromImage(Image image) {
        Rect crop = image.getCropRect();
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        Image.Plane[] planes = image.getPlanes();
        byte[] data = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) / 8];
        byte[] rowData = new byte[planes[0].getRowStride()];
        int channelOffset = 0;
        int outputStride = 1;
        for (int i = 0; i < planes.length; ++i) {
            switch (i) {
                case 0: {
                    channelOffset = 0;
                    outputStride = 1;
                    break;
                }
                case 1: {
                    channelOffset = width * height + 1;
                    outputStride = 2;
                    break;
                }
                case 2: {
                    channelOffset = width * height;
                    outputStride = 2;
                }
            }
            ByteBuffer buffer = planes[i].getBuffer();
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            int shift = i == 0 ? 0 : 1;
            int w = width >> shift;
            int h = height >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            for (int row = 0; row < h; ++row) {
                int length;
                if (pixelStride == 1 && outputStride == 1) {
                    length = w;
                    buffer.get(data, channelOffset, length);
                    channelOffset += length;
                } else {
                    length = (w - 1) * pixelStride + 1;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < w; ++col) {
                        data[channelOffset] = rowData[col * pixelStride];
                        channelOffset += outputStride;
                    }
                }
                if (row >= h - 1) continue;
                buffer.position(buffer.position() + rowStride - length);
            }
        }
        return data;
    }

    @TargetApi(value=21)
    private static byte[] YUV_420_888toNV21(Image image) {
        Rect crop = image.getCropRect();
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        int pixelSize = width * height;
        byte[] nv21 = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) >> 3];
        ByteBuffer yBuffer = image.getPlanes()[0].getBuffer();
        int yPixelStride = image.getPlanes()[0].getPixelStride();
        int i = 0;
        int j = 0;
        while (i < pixelSize) {
            nv21[i] = yBuffer.get(i);
            ++i;
            j += yPixelStride;
        }
        ByteBuffer vBuffer = image.getPlanes()[2].getBuffer();
        int vPixelStride = image.getPlanes()[2].getPixelStride();
        int i2 = pixelSize;
        int j2 = 0;
        while (i2 < nv21.length) {
            nv21[i2] = vBuffer.get(j2);
            i2 += 2;
            j2 += vPixelStride;
        }
        ByteBuffer uBuffer = image.getPlanes()[1].getBuffer();
        int uPixelStride = image.getPlanes()[1].getPixelStride();
        int i3 = pixelSize + 1;
        int j3 = 0;
        while (i3 < nv21.length) {
            nv21[i3] = uBuffer.get(j3);
            i3 += 2;
            j3 += uPixelStride;
        }
        return nv21;
    }

    @Override
    public void release() {
    }

    private class ConsumeThread
    extends Thread {
        private boolean keepAlive;

        public ConsumeThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            while (this.keepAlive) {
                try {
                    DecoderData decoderData = (DecoderData)MediaVideoDecoder21.this.mBufferQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (MediaVideoDecoder21.this.mOnFrameAvailableListener == null || decoderData == null) continue;
                    MediaVideoDecoder21.this.mOnFrameAvailableListener.onFrame(decoderData.data, MediaVideoDecoder21.this.width, MediaVideoDecoder21.this.height, MediaVideoDecoder21.this.rotation, decoderData.presentationTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void release() {
            this.keepAlive = false;
        }
    }

    private class DecoderData {
        byte[] data;
        long presentationTime;

        private DecoderData() {
        }
    }
}

