/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.report.RTCStatusReportManager;
import cn.rongcloud.rtc.base.RCRTCConnectionState;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.core.IceCandidate;
import cn.rongcloud.rtc.core.MediaStream;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.RtpReceiver;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.webrtc.RTCConnectionEvents;

public class RTCConnectionEventsImpl
implements RTCConnectionEvents {
    public RTCStatusReportManager mStatusReportManager;
    private static final String TAG = "RTCConnectionEventsImpl";

    public void setStatusReportManager(RTCStatusReportManager statusReport) {
        this.mStatusReportManager = statusReport;
    }

    @Override
    public void onIceCandidate(IceCandidate candidate) {
    }

    @Override
    public void onIceCandidatesRemoved(IceCandidate[] candidates) {
    }

    @Override
    public void onIceConnected() {
        RTCEngineImpl.getInstance().sendMessage(8104, (Object)RCRTCConnectionState.CONNECTED);
    }

    @Override
    public void onIceDisconnected() {
        RTCEngineImpl.getInstance().sendMessage(8000, new Object[0]);
        RTCEngineImpl.getInstance().sendMessage(8104, (Object)RCRTCConnectionState.DISCONNECTED);
    }

    @Override
    public void onIceChecking() {
        RTCEngineImpl.getInstance().sendMessage(8104, (Object)RCRTCConnectionState.CONNECTING);
    }

    @Override
    public void onRTCConnectionError(String description) {
    }

    @Override
    public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
        String userId;
        MediaStreamTrack track;
        String streamId = "";
        MediaStream mediaStream = null;
        if (mediaStreams != null && mediaStreams.length >= 1) {
            mediaStream = mediaStreams[0];
            streamId = mediaStream.getId();
        }
        if ((track = receiver.track()) == null) {
            ReportUtil.libError(ReportUtil.TAG.ONADDTRACK, "Track is empty. streamId : " + streamId, new Object[0]);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (mediaStream != null && !TextUtils.isEmpty((CharSequence)mediaStream.getId())) {
            stringBuilder.append(mediaStream.getId());
        }
        stringBuilder.append("_");
        if (!TextUtils.isEmpty((CharSequence)track.kind())) {
            stringBuilder.append(track.kind());
        }
        String trackId = stringBuilder.toString();
        ReportUtil.libStatus(ReportUtil.TAG.ONADDTRACK, "media|trackId|streamId", track.kind(), trackId, streamId);
        String realUserId = userId = streamId;
        String tag = "";
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            if (RTCEngineImpl.getInstance().version2UserIDs.containsKey(userId)) {
                realUserId = userId;
            } else {
                int n = userId.lastIndexOf(95);
                if (n > 0 && n < userId.length()) {
                    realUserId = userId.substring(0, n);
                    if (n < userId.length() - 1) {
                        tag = userId.substring(n + 1, userId.length());
                    }
                }
            }
        }
        RCRTCMediaType videoType = RCRTCMediaType.AUDIO.getDescription().equals(track.kind()) ? RCRTCMediaType.AUDIO : RCRTCMediaType.VIDEO;
        this.setAudioRtpObserver(receiver, videoType, realUserId, tag);
        RCRTCMediaType mediaType = RCRTCMediaType.parseByDes(track.kind());
        RTCEngineImpl.getInstance().sendMessage(2060, new Object[]{realUserId, tag, mediaType, track});
        RongRtcStatMagr.instance.reportSubStream(trackId, streamId, mediaType);
    }

    private void setAudioRtpObserver(RtpReceiver receiver, RCRTCMediaType mediaType, final String finalUserId, final String finalTag) {
        if (mediaType != RCRTCMediaType.AUDIO) {
            return;
        }
        receiver.setOuterObserver(new RtpReceiver.Observer(){

            @Override
            public void onFirstPacketReceived(MediaStreamTrack.MediaType media_type) {
                FinLog.d(RTCConnectionEventsImpl.TAG, "onFirstAudioPacketReceived: userId:" + finalUserId + " , tag:" + finalTag);
                ReportUtil.libStatus(ReportUtil.TAG.ONFIRSTAUDIOFRAMERECEIVED, "uid", finalUserId);
                RTCEngineImpl.getInstance().sendMessage(3308, finalUserId, finalTag);
            }
        });
    }
}

