/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.DisplayMetrics;
import android.view.Display;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CpuUsageMeasurer;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.a;
import com.tencent.liteav.base.util.j;
import com.tencent.liteav.base.util.u;

@JNINamespace(value="liteav")
public class SystemUtil {
    private static final String TAG = "SystemUtil";
    private static boolean mFirstTimeRun;
    private static final a<CpuUsageMeasurer> sCpuUsageMeasurer;

    public static int[] getProcessCPURate() {
        if (mFirstTimeRun) {
            mFirstTimeRun = false;
            sCpuUsageMeasurer.a();
            CpuUsageMeasurer.a();
            return new int[]{0, 0};
        }
        sCpuUsageMeasurer.a();
        return CpuUsageMeasurer.a();
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnectedOrConnecting();
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    @NonNull
    public static Size getDisplaySize() {
        try {
            Display display = SystemUtil.getDisplay();
            if (display != null) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                display.getRealMetrics(displayMetrics);
                return new Size(displayMetrics.widthPixels, displayMetrics.heightPixels);
            }
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "get display size failed.", exception);
        }
        return new Size(720, 1280);
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public static int getDisplayRotationDegree() {
        return j.a().c().mValue;
    }

    public static Display getDisplay() {
        return j.a().d();
    }

    static {
        sCpuUsageMeasurer = new a(u.b());
    }
}

