/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.api;

import android.annotation.SuppressLint;
import android.media.AudioAttributes;
import com.tencent.thumbplayer.adapter.strategy.utils.TPNativeKeyMap;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;

public class TPAudioAttributes {
    @TPNativeKeyMap.MapTPAudioAttributeContentType(value=0)
    public static final int TP_CONTENT_UNKNOWN = 0;
    @TPNativeKeyMap.MapTPAudioAttributeContentType(value=1)
    public static final int TP_CONTENT_SPEECH = 1;
    @TPNativeKeyMap.MapTPAudioAttributeContentType(value=2)
    public static final int TP_CONTENT_MUSIC = 2;
    @TPNativeKeyMap.MapTPAudioAttributeContentType(value=3)
    public static final int TP_CONTENT_MOVIE = 3;
    @TPNativeKeyMap.MapTPAudioAttributeContentType(value=4)
    public static final int TP_CONTENT_SONIFICATION = 4;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=0)
    public static final int TP_USAGE_UNKNOWN = 0;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=1)
    public static final int TP_USAGE_MEDIA = 1;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=2)
    public static final int TP_USAGE_VOICE_COMMUNICATION = 2;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=3)
    public static final int TP_USAGE_VOICE_COMMUNICATION_SIGNALLING = 3;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=4)
    public static final int TP_USAGE_ALARM = 4;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=5)
    public static final int TP_USAGE_NOTIFICATION = 5;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=6)
    public static final int TP_USAGE_NOTIFICATION_RINGTONE = 6;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=7)
    public static final int TP_USAGE_NOTIFICATION_COMMUNICATION_REQUEST = 7;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=8)
    public static final int TP_USAGE_NOTIFICATION_COMMUNICATION_INSTANT = 8;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=9)
    public static final int TP_USAGE_NOTIFICATION_COMMUNICATION_DELAYED = 9;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=10)
    public static final int TP_USAGE_NOTIFICATION_EVENT = 10;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=11)
    public static final int TP_USAGE_ASSISTANCE_ACCESSIBILITY = 11;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=12)
    public static final int TP_USAGE_ASSISTANCE_NAVIGATION_GUIDANCE = 12;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=13)
    public static final int TP_USAGE_ASSISTANCE_SONIFICATION = 13;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=14)
    public static final int TP_USAGE_GAME = 14;
    @TPNativeKeyMap.MapTPAudioAttributeUsage(value=16)
    public static final int TP_USAGE_ASSISTANT = 16;
    @TPNativeKeyMap.MapTPAudioAttributeFlag(value=0)
    public static final int TP_FLAG_UNKNOWN = 0;
    @TPNativeKeyMap.MapTPAudioAttributeFlag(value=1)
    public static final int TP_FLAG_AUDIBILITY_ENFORCED = 1;
    @TPNativeKeyMap.MapTPAudioAttributeFlag(value=16)
    public static final int TP_FLAG_HW_AV_SYNC = 16;
    @TPNativeKeyMap.MapTPAudioAttributeFlag(value=256)
    public static final int TP_FLAG_LOW_LATENCY = 256;
    @TPNativeKeyMap.MapTPAudioAttributeStreamType(value=-1)
    public static final int TP_STREAM_UNKNOWN = -1;
    @TPNativeKeyMap.MapTPAudioAttributeStreamType(value=0)
    public static final int TP_STREAM_VOICE_CALL = 0;
    @TPNativeKeyMap.MapTPAudioAttributeStreamType(value=1)
    public static final int TP_STREAM_SYSTEM = 1;
    @TPNativeKeyMap.MapTPAudioAttributeStreamType(value=2)
    public static final int TP_STREAM_RING = 2;
    @TPNativeKeyMap.MapTPAudioAttributeStreamType(value=3)
    public static final int TP_STREAM_MUSIC = 3;
    @TPNativeKeyMap.MapTPAudioAttributeStreamType(value=4)
    public static final int TP_STREAM_ALARM = 4;
    @TPNativeKeyMap.MapTPAudioAttributeStreamType(value=5)
    public static final int TP_STREAM_NOTIFICATION = 5;
    @TPNativeKeyMap.MapTPAudioAttributeStreamType(value=8)
    public static final int TP_STREAM_DTMF = 8;
    private static final int TP_FLAG_PUBLIC = 273;
    private static final HashMap<Integer, String> mMapContentTypeToString = new HashMap<Integer, String>();
    private static final HashMap<Integer, Integer> mMapContentTypeToAndroidMediaContentType;
    private static final HashMap<Integer, String> mMapUsageToString;
    private static final HashMap<Integer, Integer> mMapUsageToAndroidMediaUsage;
    private static final HashMap<Integer, Integer> mMapUsageToAndroidMediaStreamType;
    private int mUsage = 0;
    private int mContentType = 0;
    private int mFlags = 0;

    private TPAudioAttributes() {
    }

    @TPAudioAttributeUsage
    public int getUsage() {
        return this.mUsage;
    }

    @TPAudioAttributeContentType
    public int getContentType() {
        return this.mContentType;
    }

    public int getFlags() {
        return this.mFlags & 0x111;
    }

    public String toString() {
        return "AudioAttributes: usage=" + TPAudioAttributes.usageToString(this.mUsage) + " content=" + TPAudioAttributes.contentTypeToString(this.mContentType) + " flags=0x" + Integer.toHexString(this.mFlags).toUpperCase();
    }

    public static String usageToString(@TPAudioAttributeUsage int n2) {
        if (mMapUsageToString.containsKey(n2)) {
            return mMapUsageToString.get(n2);
        }
        return "unknown usage ".concat(String.valueOf(n2));
    }

    public static String contentTypeToString(@TPAudioAttributeContentType int n2) {
        if (mMapContentTypeToString.containsKey(n2)) {
            return mMapContentTypeToString.get(n2);
        }
        return "unknown content type".concat(String.valueOf(n2));
    }

    @SuppressLint(value={"NewApi"})
    public AudioAttributes toAndroidMediaAudioAttributes() {
        int n2 = TPAudioAttributes.usageToAndroidMediaUsage(this.mUsage);
        int n3 = TPAudioAttributes.contentTypeToAndroidMediaContentType(this.mContentType);
        int n4 = TPAudioAttributes.flagsToAndroidMediaFlags(this.mFlags);
        return new AudioAttributes.Builder().setContentType(n3).setUsage(n2).setFlags(n4).build();
    }

    public static int usageToAndroidMediaStreamType(@TPAudioAttributeUsage int n2) {
        if (mMapUsageToAndroidMediaStreamType.containsKey(n2)) {
            return mMapUsageToAndroidMediaStreamType.get(n2);
        }
        return 3;
    }

    private static int usageToAndroidMediaUsage(@TPAudioAttributeUsage int n2) {
        if (mMapUsageToAndroidMediaUsage.containsKey(n2)) {
            return mMapUsageToAndroidMediaUsage.get(n2);
        }
        return 0;
    }

    private static int contentTypeToAndroidMediaContentType(@TPAudioAttributeContentType int n2) {
        if (mMapContentTypeToAndroidMediaContentType.containsKey(n2)) {
            return mMapContentTypeToAndroidMediaContentType.get(n2);
        }
        return 0;
    }

    private static int flagsToAndroidMediaFlags(int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 = 1;
        }
        if ((n2 & 0x10) != 0) {
            n3 |= 0x10;
        }
        if ((n2 & 0x100) != 0) {
            n3 |= 0x100;
        }
        return n3;
    }

    static {
        mMapContentTypeToString.put(0, "TP_CONTENT_UNKNOWN");
        mMapContentTypeToString.put(1, "TP_CONTENT_SPEECH");
        mMapContentTypeToString.put(2, "TP_CONTENT_MUSIC");
        mMapContentTypeToString.put(3, "TP_CONTENT_MOVIE");
        mMapContentTypeToString.put(4, "TP_CONTENT_SONIFICATION");
        mMapContentTypeToAndroidMediaContentType = new HashMap<Integer, Integer>();
        mMapContentTypeToAndroidMediaContentType.put(0, 0);
        mMapContentTypeToAndroidMediaContentType.put(1, 1);
        mMapContentTypeToAndroidMediaContentType.put(2, 2);
        mMapContentTypeToAndroidMediaContentType.put(3, 3);
        mMapContentTypeToAndroidMediaContentType.put(4, 4);
        mMapUsageToString = new HashMap<Integer, String>();
        mMapUsageToString.put(0, "TP_USAGE_UNKNOWN");
        mMapUsageToString.put(1, "TP_USAGE_MEDIA");
        mMapUsageToString.put(2, "TP_USAGE_VOICE_COMMUNICATION");
        mMapUsageToString.put(3, "TP_USAGE_VOICE_COMMUNICATION_SIGNALLING");
        mMapUsageToString.put(4, "TP_USAGE_ALARM");
        mMapUsageToString.put(5, "TP_USAGE_NOTIFICATION");
        mMapUsageToString.put(6, "TP_USAGE_NOTIFICATION_RINGTONE");
        mMapUsageToString.put(7, "TP_USAGE_NOTIFICATION_COMMUNICATION_REQUEST");
        mMapUsageToString.put(8, "TP_USAGE_NOTIFICATION_COMMUNICATION_INSTANT");
        mMapUsageToString.put(9, "TP_USAGE_NOTIFICATION_COMMUNICATION_DELAYED");
        mMapUsageToString.put(10, "TP_USAGE_NOTIFICATION_EVENT");
        mMapUsageToString.put(11, "TP_USAGE_ASSISTANCE_ACCESSIBILITY");
        mMapUsageToString.put(12, "TP_USAGE_ASSISTANCE_NAVIGATION_GUIDANCE");
        mMapUsageToString.put(13, "TP_USAGE_ASSISTANCE_SONIFICATION");
        mMapUsageToString.put(14, "TP_USAGE_GAME");
        mMapUsageToString.put(16, "TP_USAGE_ASSISTANT");
        mMapUsageToAndroidMediaUsage = new HashMap<Integer, Integer>();
        mMapUsageToAndroidMediaUsage.put(0, 0);
        mMapUsageToAndroidMediaUsage.put(1, 1);
        mMapUsageToAndroidMediaUsage.put(2, 2);
        mMapUsageToAndroidMediaUsage.put(3, 3);
        mMapUsageToAndroidMediaUsage.put(4, 4);
        mMapUsageToAndroidMediaUsage.put(5, 5);
        mMapUsageToAndroidMediaUsage.put(6, 6);
        mMapUsageToAndroidMediaUsage.put(7, 7);
        mMapUsageToAndroidMediaUsage.put(8, 8);
        mMapUsageToAndroidMediaUsage.put(9, 9);
        mMapUsageToAndroidMediaUsage.put(10, 10);
        mMapUsageToAndroidMediaUsage.put(11, 11);
        mMapUsageToAndroidMediaUsage.put(12, 12);
        mMapUsageToAndroidMediaUsage.put(13, 13);
        mMapUsageToAndroidMediaUsage.put(14, 14);
        mMapUsageToAndroidMediaUsage.put(16, 16);
        mMapUsageToAndroidMediaStreamType = new HashMap<Integer, Integer>();
        mMapUsageToAndroidMediaStreamType.put(0, 3);
        mMapUsageToAndroidMediaStreamType.put(1, 3);
        mMapUsageToAndroidMediaStreamType.put(2, 0);
        mMapUsageToAndroidMediaStreamType.put(3, 8);
        mMapUsageToAndroidMediaStreamType.put(4, 4);
        mMapUsageToAndroidMediaStreamType.put(5, 5);
        mMapUsageToAndroidMediaStreamType.put(6, 2);
        mMapUsageToAndroidMediaStreamType.put(7, 5);
        mMapUsageToAndroidMediaStreamType.put(8, 5);
        mMapUsageToAndroidMediaStreamType.put(9, 5);
        mMapUsageToAndroidMediaStreamType.put(10, 5);
        mMapUsageToAndroidMediaStreamType.put(12, 3);
        mMapUsageToAndroidMediaStreamType.put(13, 1);
        mMapUsageToAndroidMediaStreamType.put(14, 3);
        mMapUsageToAndroidMediaStreamType.put(16, 3);
    }

    @Target(value={ElementType.METHOD, ElementType.LOCAL_VARIABLE, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TPAudioAttributeStreamType {
    }

    @Target(value={ElementType.METHOD, ElementType.LOCAL_VARIABLE, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TPAudioAttributeFlag {
    }

    @Target(value={ElementType.METHOD, ElementType.LOCAL_VARIABLE, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TPAudioAttributeUsage {
    }

    @Target(value={ElementType.METHOD, ElementType.LOCAL_VARIABLE, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TPAudioAttributeContentType {
    }

    public static class Builder {
        private static final HashMap<Integer, Integer> mMapStreamTypeToContentType = new HashMap<Integer, Integer>();
        private static final HashMap<Integer, Integer> mMapStreamTypeToUsage;
        private int mUsage = 0;
        private int mContentType = 0;
        private int mFlags = 0;

        public TPAudioAttributes build() {
            TPAudioAttributes tPAudioAttributes = new TPAudioAttributes();
            tPAudioAttributes.mContentType = this.mContentType;
            tPAudioAttributes.mUsage = this.mUsage;
            tPAudioAttributes.mFlags = this.mFlags;
            return tPAudioAttributes;
        }

        public Builder setUsage(@TPAudioAttributeUsage int n2) {
            this.mUsage = mMapUsageToString.containsKey(n2) ? n2 : 0;
            return this;
        }

        public Builder setContentType(@TPAudioAttributeContentType int n2) {
            this.mContentType = mMapContentTypeToString.containsKey(n2) ? n2 : 0;
            return this;
        }

        public Builder addFlags(int n2) {
            this.mFlags |= (n2 &= 0x111);
            return this;
        }

        public Builder setFlag(int n2) {
            this.mFlags = n2 &= 0x111;
            return this;
        }

        public Builder setLegacyStreamType(@TPAudioAttributeStreamType int n2) {
            this.mContentType = mMapStreamTypeToContentType.containsKey(n2) ? mMapStreamTypeToContentType.get(n2) : 0;
            this.mUsage = mMapStreamTypeToUsage.containsKey(n2) ? mMapStreamTypeToUsage.get(n2) : 0;
            return this;
        }

        static {
            mMapStreamTypeToContentType.put(-1, 0);
            mMapStreamTypeToContentType.put(0, 1);
            mMapStreamTypeToContentType.put(1, 4);
            mMapStreamTypeToContentType.put(2, 4);
            mMapStreamTypeToContentType.put(3, 2);
            mMapStreamTypeToContentType.put(4, 4);
            mMapStreamTypeToContentType.put(5, 4);
            mMapStreamTypeToContentType.put(8, 4);
            mMapStreamTypeToUsage = new HashMap<Integer, Integer>();
            mMapStreamTypeToUsage.put(-1, 0);
            mMapStreamTypeToUsage.put(0, 2);
            mMapStreamTypeToUsage.put(1, 13);
            mMapStreamTypeToUsage.put(2, 6);
            mMapStreamTypeToUsage.put(3, 1);
            mMapStreamTypeToUsage.put(4, 4);
            mMapStreamTypeToUsage.put(5, 5);
            mMapStreamTypeToUsage.put(8, 3);
        }
    }
}

