/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.drm;

import android.annotation.SuppressLint;
import android.media.DeniedByServerException;
import android.media.MediaCrypto;
import android.media.MediaCryptoException;
import android.media.MediaDrm;
import android.media.NotProvisionedException;
import android.media.UnsupportedSchemeException;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Base64;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import com.tencent.thumbplayer.core.drm.ITPDrmInterruptCallback;
import com.tencent.thumbplayer.core.drm.ITPMediaDrm;
import com.tencent.thumbplayer.core.drm.TPDrmInterruptCallbackProxy;
import com.tencent.thumbplayer.core.drm.TPMediaDrmFatalException;
import com.tencent.thumbplayer.core.drm.TPMediaDrmPool;
import com.tencent.thumbplayer.core.utils.TPThreadPool;
import java.util.HashMap;
import java.util.UUID;

@SuppressLint(value={"NewApi"})
public class TPMediaDrmProxy {
    private static final String TAG = "[PlayerCore][TPMediaDrmProxy]";
    private static final long CREATE_MEDIA_DRM_TIMEOUT_MS = 5000L;
    private static final long CREATE_MEDIA_DRM_SLICE_WAIT_TIME_MS = 100L;
    private static final int MAX_LICENSE_DURATION_TO_RENEW_SECONDS = 60;
    public static final String PROPERTY_LICENSE_DURATION_REMAINING = "LicenseDurationRemaining";
    public static final String PROPERTY_PLAYBACK_DURATION_REMAINING = "PlaybackDurationRemaining";
    private UUID mUUID;
    private ITPMediaDrm mMediaDrm;
    private long mNativeContext;
    private static final int ERR_NONE = 0;
    private static final int ERR_ILLEGAL_ARGUMENT = 1;
    private static final int ERR_API_LOW_LEVEL = 2;
    private static final int ERR_INTERRUPT = 3;
    private static final int ERR_UNSUPPORTED_SCHEME = 4;
    private static final int ERR_CREATE_MEDIA_DRM_FAILED = 5;

    private TPMediaDrmProxy(UUID uUID, boolean bl2) {
        ITPMediaDrm iTPMediaDrm = bl2 ? TPMediaDrmPool.getInstance().createTPMediaDrm(uUID) : TPMediaDrmPool.getInstance().createTPDirectMediaDrm(uUID);
        new ITPMediaDrm.OnEventListener(){

            @Override
            public void onEvent(ITPMediaDrm iTPMediaDrm, byte[] byArray, int n2, int n3, byte[] byArray2) {
                if (iTPMediaDrm == TPMediaDrmProxy.this.mMediaDrm) {
                    TPMediaDrmProxy.this.native_mediaDrmOnEvent(byArray, n2, n3, byArray2);
                }
            }
        };
        this.mMediaDrm = iTPMediaDrm;
        this.mUUID = uUID;
    }

    public static void setMediaDrmReuseEnable(boolean bl2) {
        TPMediaDrmPool.getInstance().setMediaDrmReuseEnable(bl2);
        TPNativeLog.printLog(2, TAG, "setMediaDrmReuseEnable, reuse:" + (bl2 ? "true" : "false"));
    }

    public static boolean isCryptoSchemeSupported(String string) {
        ITPMediaDrm iTPMediaDrm;
        UUID uUID;
        if (string == null) {
            TPNativeLog.printLog(2, "isCryptoSchemeSupported, illegal argument.");
            return false;
        }
        try {
            uUID = UUID.fromString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TPNativeLog.printLog(4, illegalArgumentException.getMessage());
            return false;
        }
        TPNativeLog.printLog(2, "isCryptoSchemeSupported, MediaDrm create start.");
        try {
            iTPMediaDrm = TPMediaDrmPool.getInstance().createTPMediaDrm(uUID);
        }
        catch (UnsupportedSchemeException unsupportedSchemeException) {
            TPNativeLog.printLog(4, unsupportedSchemeException.getMessage());
            return false;
        }
        iTPMediaDrm.close();
        TPNativeLog.printLog(2, "isCryptoSchemeSupported, MediaDrm release finished.");
        boolean bl2 = MediaDrm.isCryptoSchemeSupported((UUID)uUID);
        TPNativeLog.printLog(2, "isCryptoSchemeSupported, supported:".concat(String.valueOf(bl2)));
        return bl2;
    }

    private static MediaDrmProxyCreateResult createMediaDrmProxyByUUID(String string, boolean bl2, TPDrmInterruptCallbackProxy tPDrmInterruptCallbackProxy) {
        TPMediaDrmProxy tPMediaDrmProxy;
        UUID uUID;
        if (string == null) {
            TPNativeLog.printLog(4, "illegal argument.");
            return new MediaDrmProxyCreateResult(null, 1);
        }
        try {
            uUID = UUID.fromString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TPNativeLog.printLog(4, illegalArgumentException.getMessage());
            return new MediaDrmProxyCreateResult(null, 1);
        }
        if (Build.VERSION.SDK_INT < 18) {
            return new MediaDrmProxyCreateResult(null, 2);
        }
        try {
            tPMediaDrmProxy = TPMediaDrmProxy.createMediaDrmProxyWithAsyncTimeout(uUID, bl2, tPDrmInterruptCallbackProxy);
        }
        catch (UnsupportedSchemeException unsupportedSchemeException) {
            TPNativeLog.printLog(4, unsupportedSchemeException.getMessage());
            return new MediaDrmProxyCreateResult(null, 4);
        }
        catch (InterruptedException interruptedException) {
            TPNativeLog.printLog(4, interruptedException.getMessage());
            return new MediaDrmProxyCreateResult(null, 3);
        }
        TPMediaDrmProxy tPMediaDrmProxy2 = tPMediaDrmProxy;
        return new MediaDrmProxyCreateResult(tPMediaDrmProxy2, tPMediaDrmProxy2 != null ? 0 : 5);
    }

    private static void checkInterrupt(ITPDrmInterruptCallback iTPDrmInterruptCallback) {
        if (iTPDrmInterruptCallback != null && iTPDrmInterruptCallback.isInterrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TPMediaDrmProxy createMediaDrmProxyWithAsyncTimeout(final UUID uUID, final boolean bl2, ITPDrmInterruptCallback iTPDrmInterruptCallback) {
        final Object object = new Object();
        final TPMediaDrmProxy[] tPMediaDrmProxyArray = new TPMediaDrmProxy[]{null};
        final UnsupportedSchemeException[] unsupportedSchemeExceptionArray = new UnsupportedSchemeException[]{null};
        final boolean[] blArray = new boolean[]{false};
        TPNativeLog.printLog(2, "async create mediaDrm proxy start.");
        TPThreadPool.getInstance().obtainThreadExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                boolean bl22;
                TPNativeLog.printLog(2, "create system mediaDrm proxy start.");
                try {
                    tPMediaDrmProxyArray[0] = new TPMediaDrmProxy(uUID, bl2);
                }
                catch (UnsupportedSchemeException unsupportedSchemeException) {
                    unsupportedSchemeExceptionArray[0] = unsupportedSchemeException;
                }
                TPNativeLog.printLog(2, "create system mediaDrm proxy end.");
                Object object2 = object;
                synchronized (object2) {
                    bl22 = blArray[0];
                    object.notify();
                }
                if (bl22 && null != tPMediaDrmProxyArray[0]) {
                    tPMediaDrmProxyArray[0].release();
                }
            }
        });
        long l2 = SystemClock.elapsedRealtime();
        while (null == tPMediaDrmProxyArray[0]) {
            Object object2 = object;
            synchronized (object2) {
                try {
                    TPMediaDrmProxy.checkInterrupt(iTPDrmInterruptCallback);
                }
                catch (InterruptedException interruptedException) {
                    blArray[0] = true;
                    throw interruptedException;
                }
            }
            long l3 = 5000L - (SystemClock.elapsedRealtime() - l2);
            if (l3 <= 0L) break;
            Object object3 = object;
            synchronized (object3) {
                try {
                    object.wait(Math.min(l3, 100L));
                }
                catch (InterruptedException interruptedException) {
                    blArray[0] = true;
                    throw interruptedException;
                }
            }
        }
        if (null != unsupportedSchemeExceptionArray[0]) {
            throw unsupportedSchemeExceptionArray[0];
        }
        TPMediaDrmProxy tPMediaDrmProxy = null;
        Object object4 = object;
        synchronized (object4) {
            if (null == tPMediaDrmProxyArray[0]) {
                blArray[0] = true;
            } else {
                tPMediaDrmProxy = tPMediaDrmProxyArray[0];
            }
        }
        TPNativeLog.printLog(2, "async create mediaDrm proxy end.");
        return tPMediaDrmProxy;
    }

    public DrmSessionId openSession() {
        byte[] byArray = null;
        int n2 = 0;
        try {
            byArray = this.mMediaDrm.openSession();
        }
        catch (NotProvisionedException notProvisionedException) {
            n2 = -1;
        }
        catch (Exception exception) {
            n2 = -2;
        }
        return new DrmSessionId(n2, byArray);
    }

    public MediaCrypto getMediaCrypto(byte[] byArray) {
        MediaCrypto mediaCrypto;
        try {
            mediaCrypto = new MediaCrypto(this.mUUID, byArray);
        }
        catch (MediaCryptoException mediaCryptoException) {
            return null;
        }
        return mediaCrypto;
    }

    public void closeSession(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.mMediaDrm.closeSession(byArray);
    }

    public void release() {
        this.mMediaDrm.close();
    }

    public ProvisionRequest getProvisionRequest() {
        MediaDrm.ProvisionRequest provisionRequest;
        try {
            provisionRequest = this.mMediaDrm.getProvisionRequest();
        }
        catch (TPMediaDrmFatalException tPMediaDrmFatalException) {
            return new ProvisionRequest("", new byte[0]);
        }
        return new ProvisionRequest(provisionRequest.getDefaultUrl(), provisionRequest.getData());
    }

    public int provideProvisionResponse(byte[] byArray) {
        try {
            this.mMediaDrm.provideProvisionResponse(byArray);
        }
        catch (DeniedByServerException deniedByServerException) {
            return -1;
        }
        return 0;
    }

    public KeyRequest getKeyRequest(byte[] byArray, byte[] byArray2, String string, int n2) {
        MediaDrm.KeyRequest keyRequest;
        int n3 = 0;
        try {
            keyRequest = this.mMediaDrm.getKeyRequest(byArray, byArray2, string, n2, null);
        }
        catch (NotProvisionedException | TPMediaDrmFatalException throwable) {
            return new KeyRequest(-1, null, -1);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            n3 = keyRequest.getRequestType();
        }
        return new KeyRequest(n3, keyRequest.getData(), 0);
    }

    public int provideKeyResponse(byte[] byArray, byte[] byArray2) {
        try {
            this.mMediaDrm.provideKeyResponse(byArray, byArray2);
        }
        catch (NotProvisionedException notProvisionedException) {
            return -1;
        }
        catch (DeniedByServerException | TPMediaDrmFatalException throwable) {
            return -2;
        }
        return 0;
    }

    public String getPropertyString(String string) {
        return this.mMediaDrm.getPropertyString(string);
    }

    public void setPropertyString(String string, String string2) {
        this.mMediaDrm.setPropertyString(string, string2);
    }

    public int restoreKeys(byte[] byArray, String string) {
        int n2 = 0;
        try {
            this.mMediaDrm.restoreKeys(byArray, Base64.decode((String)string, (int)2));
            long l2 = this.getLicenseDurationRemainingSec(byArray);
            if (l2 <= 60L) {
                TPNativeLog.printLog(3, "Offline license has expired or will expire soon, Remaining seconds: ".concat(String.valueOf(l2)));
                this.mMediaDrm.removeKeys(byArray);
                n2 = -1;
            }
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    private long getLicenseDurationRemainingSec(byte[] byArray) {
        try {
            HashMap<String, String> hashMap = this.mMediaDrm.queryKeyStatus(byArray);
            if (hashMap != null && hashMap.size() > 0) {
                String string = hashMap.get(PROPERTY_LICENSE_DURATION_REMAINING);
                long l2 = 0L;
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    l2 = Long.parseLong(string);
                }
                String string2 = hashMap.get(PROPERTY_PLAYBACK_DURATION_REMAINING);
                long l3 = 0L;
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    l3 = Long.parseLong(string2);
                }
                return Math.min(l2, l3);
            }
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, "queryKeyStatus failed, error:" + throwable.toString());
        }
        return 0L;
    }

    private native void native_mediaDrmOnEvent(byte[] var1, int var2, int var3, byte[] var4);

    public static final class KeyRequest {
        byte[] mData;
        int mRequestType;
        int mStatus;

        KeyRequest(int n2, byte[] byArray, int n3) {
            this.mRequestType = n2;
            this.mData = byArray;
            this.mStatus = n3;
        }
    }

    public static final class ProvisionRequest {
        String mDefaultUrl;
        byte[] mData;

        ProvisionRequest(String string, byte[] byArray) {
            this.mDefaultUrl = string;
            this.mData = byArray;
        }
    }

    public static final class DrmSessionId {
        byte[] mSessionId;
        int mStatus;

        DrmSessionId(int n2, byte[] byArray) {
            this.mStatus = n2;
            this.mSessionId = byArray;
        }
    }

    public static final class MediaDrmProxyCreateResult {
        TPMediaDrmProxy mMediaDrmProxy;
        int mErrorCode;

        MediaDrmProxyCreateResult(TPMediaDrmProxy tPMediaDrmProxy, int n2) {
            this.mMediaDrmProxy = tPMediaDrmProxy;
            this.mErrorCode = n2;
        }
    }
}

