/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.utils.c;
import com.tencent.ugc.RemuxJoiner;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.TXVideoEditer;
import com.tencent.ugc.UGCLicenseChecker;
import com.tencent.ugc.bw;
import com.tencent.ugc.bx;
import com.tencent.ugc.by;
import com.tencent.ugc.bz;
import com.tencent.ugc.ca;
import com.tencent.ugc.cb;
import com.tencent.ugc.cc;
import com.tencent.ugc.cd;
import com.tencent.ugc.ce;
import com.tencent.ugc.cf;
import com.tencent.ugc.cg;
import com.tencent.ugc.ch;
import com.tencent.ugc.ci;
import com.tencent.ugc.cj;
import com.tencent.ugc.ck;
import com.tencent.ugc.cl;
import com.tencent.ugc.cm;
import com.tencent.ugc.cn;
import com.tencent.ugc.co;
import com.tencent.ugc.datereport.UGCDataReport;
import java.io.File;
import java.util.List;

public class TXVideoJoiner {
    private static final String TAG = "TXVideoJoiner";
    private static final int VIDEO_COMPRESSED_UNDEFINED = -1;
    private final l mSequenceTaskRunner;
    private final Context mContext;
    private TXVideoEditer mTXVideoEditer;
    private RemuxJoiner mRemuxJoiner;
    private TXVideoPreviewListener mTXVideoPreviewListener;
    private TXVideoJoinerListener mTXVideoJoinerListener;
    private List<String> mVideoSourceList;
    private boolean mIsNeedEdit = false;
    private String mVideoOutputPath;
    private TXVideoEditConstants.TXPreviewParam mTxPreviewParam;
    private int mProfile = -1;
    private List<TXVideoEditConstants.TXAbsoluteRect> mSplitScreenRects;
    private int mSplitScreenCanvasWidth = -1;
    private int mSplitScreenCanvasHeight = -1;
    private float[] mVideoVolumes;
    private final TXVideoEditer.TXVideoPreviewListener mTXEditerVideoPreviewListener = new TXVideoEditer.TXVideoPreviewListener(){

        @Override
        public final void onPreviewProgress(int time) {
            TXVideoPreviewListener tXVideoPreviewListener = TXVideoJoiner.this.mTXVideoPreviewListener;
            if (tXVideoPreviewListener != null) {
                tXVideoPreviewListener.onPreviewProgress(time);
            }
        }

        @Override
        public final void onPreviewFinished() {
            TXVideoJoiner.this.mSequenceTaskRunner.a(cm.a(this));
            TXVideoPreviewListener tXVideoPreviewListener = TXVideoJoiner.this.mTXVideoPreviewListener;
            if (tXVideoPreviewListener != null) {
                tXVideoPreviewListener.onPreviewFinished();
            }
        }

        static /* synthetic */ void a(1 var0) {
            var0.TXVideoJoiner.this.stopPlayInternal();
        }
    };
    private final TXVideoEditer.TXVideoGenerateListener mTXEditerVideoJoinerListener = new TXVideoEditer.TXVideoGenerateListener(){

        @Override
        public final void onGenerateProgress(float progress) {
            TXVideoJoiner.this.notifyJoinProgress(progress);
        }

        @Override
        public final void onGenerateComplete(TXVideoEditConstants.TXGenerateResult result) {
            TXVideoJoiner.this.notifyJoinComplete(result.retCode, result.descMsg);
        }
    };
    private final RemuxJoiner.RemuxJoinerListener mRemuxJoinerListener = new RemuxJoiner.RemuxJoinerListener(){

        @Override
        public final void onRemuxJoinerProgress(float progress) {
            TXVideoJoiner.this.mSequenceTaskRunner.a(cn.a(this, progress));
        }

        @Override
        public final void onRemuxJoinerComplete(int code, String msg) {
            TXVideoJoiner.this.mSequenceTaskRunner.a(co.a(this, code, msg));
        }

        static /* synthetic */ void a(3 var0, int n2, String string) {
            var0.TXVideoJoiner.this.notifyJoinComplete(n2, string);
            var0.TXVideoJoiner.this.destroyRemuxJoiner();
        }

        static /* synthetic */ void a(3 var0, float f2) {
            var0.TXVideoJoiner.this.notifyJoinProgress(f2);
        }
    };

    public TXVideoJoiner(Context context) {
        this.mSequenceTaskRunner = new l();
        this.mContext = context.getApplicationContext();
        UGCDataReport.reportDAU(1005);
    }

    public int setVideoPathList(List<String> videoSourceList) {
        for (String string : videoSourceList) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return -1;
            }
            int n2 = TXVideoEditer.isMediaSourceValid(string);
            if (n2 == 0) continue;
            LiteavLog.i(TAG, "setVideoPathList " + string + " is illegal." + n2);
            return n2;
        }
        this.mSequenceTaskRunner.a(bw.a(this, videoSourceList));
        return 0;
    }

    public void setRecordPath(String recordPath) {
        LiteavLog.i(TAG, "setRecordPath recordPath = ".concat(String.valueOf(recordPath)));
    }

    public void initWithPreview(TXVideoEditConstants.TXPreviewParam param) {
        LiteavLog.i(TAG, "initWithPreview videoView = " + param.videoView);
        this.mSequenceTaskRunner.a(ce.a(this, param));
    }

    public void setTXVideoPreviewListener(TXVideoPreviewListener listener) {
        LiteavLog.i(TAG, "setTXVideoPreviewListener");
        this.mSequenceTaskRunner.a(cf.a(this, listener));
    }

    public void startPlay() {
        LiteavLog.i(TAG, "startPlay");
        this.mSequenceTaskRunner.a(cg.a(this));
    }

    public void pausePlay() {
        LiteavLog.i(TAG, "pausePlay");
        this.mSequenceTaskRunner.a(ch.a(this));
    }

    public void resumePlay() {
        LiteavLog.i(TAG, "resumePlay");
        this.mSequenceTaskRunner.a(ci.a(this));
    }

    public void stopPlay() {
        LiteavLog.i(TAG, "stopPlay");
        this.mSequenceTaskRunner.a(cj.a(this));
    }

    private void stopPlayInternal() {
        LiteavLog.i(TAG, "stopPlayInternal");
        if (this.mTXVideoEditer != null) {
            this.mTXVideoEditer.stopPlay();
            this.mTXVideoEditer.release();
            this.mTXVideoEditer = null;
        }
    }

    public void setVideoJoinerListener(TXVideoJoinerListener listener) {
        LiteavLog.i(TAG, "setVideoJoinerListener");
        this.mSequenceTaskRunner.a(ck.a(this, listener));
    }

    public void setProfile(int profile) {
        LiteavLog.i(TAG, "setProfile profile ".concat(String.valueOf(profile)));
        this.mSequenceTaskRunner.a(cl.a(this, profile));
    }

    public void joinVideo(int videoCompressed, String videoOutputPath) {
        LiteavLog.i(TAG, "joinVideo videoCompressed " + videoCompressed + " videoOutputPath = " + videoOutputPath);
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "joinVideo is not support on smart version");
            this.notifyJoinComplete(-5, "licence verify failed");
            return;
        }
        this.mVideoOutputPath = videoOutputPath;
        this.mSequenceTaskRunner.a(bx.a(this, videoOutputPath, videoCompressed));
    }

    public void cancel() {
        LiteavLog.i(TAG, "cancel");
        this.mSequenceTaskRunner.a(by.a(this));
    }

    private void destroyRemuxJoiner() {
        if (this.mRemuxJoiner != null) {
            this.mRemuxJoiner.stop();
            this.mRemuxJoiner.uninitialize();
            this.mRemuxJoiner = null;
        }
    }

    private void destroyVideoEditer() {
        if (this.mTXVideoEditer != null) {
            this.mTXVideoEditer.cancel();
            this.mTXVideoEditer.release();
            this.mTXVideoEditer = null;
        }
    }

    public void setSplitScreenList(List<TXVideoEditConstants.TXAbsoluteRect> rects, int canvasWidth, int canvasHeight) {
        LiteavLog.i(TAG, "setSplitScreenList canvasWidth = " + canvasWidth + " canvasHeight = " + canvasHeight);
        this.mSequenceTaskRunner.a(bz.a(this, rects, canvasWidth, canvasHeight));
    }

    public void setVideoVolumes(List<Float> volumes) {
        LiteavLog.i(TAG, "setVideoVolumes");
        this.mSequenceTaskRunner.a(ca.a(this, volumes));
    }

    public void splitJoinVideo(int videoCompressed, String videoOutputPath) {
        LiteavLog.i(TAG, "splitJoinVideo video Compressed = " + videoCompressed + " videoOutputPath = " + videoOutputPath);
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "splitJoinVideo is not support on smart version");
            this.notifyJoinComplete(-5, "licence verify failed");
            return;
        }
        this.mVideoOutputPath = videoOutputPath;
        this.mSequenceTaskRunner.a(cb.a(this, videoCompressed, videoOutputPath));
        UGCDataReport.reportDAU(1031);
    }

    private void joinVideoInternal(int videoCompressed, String videoOutputPath, boolean isSplitJoin) {
        this.destroyVideoEditer();
        this.mTXVideoEditer = new TXVideoEditer(this.mContext, this.mSequenceTaskRunner);
        this.mTXVideoEditer.setMediaSourcePaths(this.mVideoSourceList);
        if (isSplitJoin && this.mTXVideoEditer.isHasAudio() && !c.a(this.mSplitScreenRects)) {
            this.mTXVideoEditer.setIsSplitScreen(true);
            this.mTXVideoEditer.setSplitScreenList(this.mSplitScreenRects, this.mSplitScreenCanvasWidth, this.mSplitScreenCanvasHeight);
            if (this.mVideoVolumes != null) {
                this.mTXVideoEditer.setVideoVolumes(this.mVideoVolumes);
            }
        }
        this.mTXVideoEditer.setVideoGenerateListener(this.mTXEditerVideoJoinerListener);
        this.mTXVideoEditer.setIsFullIFrame(this.mIsNeedEdit);
        this.mTXVideoEditer.setProfile(this.mProfile);
        if (this.mSplitScreenCanvasWidth > 0) {
            this.mTXVideoEditer.generateVideo(-1, videoOutputPath);
            return;
        }
        this.mTXVideoEditer.generateVideo(videoCompressed, videoOutputPath);
    }

    public void setNeedEdit(boolean needEdit) {
        LiteavLog.i(TAG, "setNeedEdit = ".concat(String.valueOf(needEdit)));
        this.mSequenceTaskRunner.a(cc.a(this, needEdit));
    }

    private boolean startQuickJoinVideo(String videoOutputPath) {
        this.destroyRemuxJoiner();
        if (this.mVideoSourceList == null || !RemuxJoiner.isConcatableWithoutReencode(this.mVideoSourceList)) {
            return false;
        }
        LiteavLog.i(TAG, "RemuxerJoinerChecker check is ok");
        if (this.mRemuxJoiner == null) {
            this.mRemuxJoiner = new RemuxJoiner();
            this.mRemuxJoiner.initialize();
        }
        this.mRemuxJoiner.stop();
        if (this.mRemuxJoiner.setSourcePaths(this.mVideoSourceList)) {
            return false;
        }
        if (this.mRemuxJoiner.setTargetPath(videoOutputPath)) {
            return false;
        }
        this.mVideoOutputPath = videoOutputPath;
        this.mRemuxJoiner.setVideoJoinerListener(this.mRemuxJoinerListener);
        return this.mRemuxJoiner.start();
    }

    private void notifyJoinProgress(float progress) {
        TXVideoJoinerListener tXVideoJoinerListener = this.mTXVideoJoinerListener;
        if (tXVideoJoinerListener != null) {
            tXVideoJoinerListener.onJoinProgress(progress);
        }
    }

    private void notifyJoinComplete(int code, String msg) {
        this.mSequenceTaskRunner.a(cd.a(this));
        TXVideoEditConstants.TXJoinerResult tXJoinerResult = new TXVideoEditConstants.TXJoinerResult();
        new TXVideoEditConstants.TXJoinerResult().descMsg = msg;
        tXJoinerResult.retCode = code;
        LiteavLog.i(TAG, "TXGenerateResult descMsg = " + msg + " retCode = " + code);
        TXVideoJoinerListener tXVideoJoinerListener = this.mTXVideoJoinerListener;
        if (tXVideoJoinerListener != null) {
            tXVideoJoinerListener.onJoinComplete(tXJoinerResult);
        }
        if (code == 0 && !TextUtils.isEmpty((CharSequence)this.mVideoOutputPath) && new File(this.mVideoOutputPath).exists()) {
            int n2 = (int)new File(this.mVideoOutputPath).length();
            UGCDataReport.reportDAU(1032, n2, "");
        }
    }

    static /* synthetic */ void lambda$notifyJoinComplete$14(TXVideoJoiner this_) {
        if (this_.mTXVideoEditer != null) {
            this_.mTXVideoEditer.release();
            this_.mTXVideoEditer = null;
        }
    }

    static /* synthetic */ void lambda$setNeedEdit$13(TXVideoJoiner this_, boolean needEdit) {
        this_.mIsNeedEdit = needEdit;
    }

    static /* synthetic */ void lambda$splitJoinVideo$12(TXVideoJoiner this_, int videoCompressed, String videoOutputPath) {
        this_.joinVideoInternal(videoCompressed, videoOutputPath, true);
    }

    static /* synthetic */ void lambda$setVideoVolumes$11(TXVideoJoiner this_, List volumes) {
        this_.mVideoVolumes = new float[volumes.size()];
        for (int i2 = 0; i2 < volumes.size(); ++i2) {
            this_.mVideoVolumes[i2] = ((Float)volumes.get(i2)).floatValue();
        }
        if (this_.mTXVideoEditer != null) {
            this_.mTXVideoEditer.setVideoVolumes(this_.mVideoVolumes);
        }
    }

    static /* synthetic */ void lambda$setSplitScreenList$10(TXVideoJoiner this_, List rects, int canvasWidth, int canvasHeight) {
        this_.mSplitScreenRects = rects;
        this_.mSplitScreenCanvasWidth = canvasWidth;
        this_.mSplitScreenCanvasHeight = canvasHeight;
        if (this_.mTXVideoEditer != null) {
            this_.mTXVideoEditer.setSplitScreenList(this_.mSplitScreenRects, this_.mSplitScreenCanvasWidth, this_.mSplitScreenCanvasHeight);
        }
    }

    static /* synthetic */ void lambda$cancel$9(TXVideoJoiner this_) {
        this_.destroyRemuxJoiner();
        this_.destroyVideoEditer();
    }

    static /* synthetic */ void lambda$joinVideo$8(TXVideoJoiner this_, String videoOutputPath, int videoCompressed) {
        if (this_.startQuickJoinVideo(videoOutputPath)) {
            LiteavLog.i(TAG, "quickJoinVideo success");
            return;
        }
        this_.joinVideoInternal(videoCompressed, videoOutputPath, false);
    }

    static /* synthetic */ void lambda$setProfile$7(TXVideoJoiner this_, int profile) {
        this_.mProfile = profile;
    }

    static /* synthetic */ void lambda$setVideoJoinerListener$6(TXVideoJoiner this_, TXVideoJoinerListener listener) {
        this_.mTXVideoJoinerListener = listener;
    }

    static /* synthetic */ void lambda$resumePlay$5(TXVideoJoiner this_) {
        if (this_.mTXVideoEditer != null) {
            this_.mTXVideoEditer.resumePlay();
        }
    }

    static /* synthetic */ void lambda$pausePlay$4(TXVideoJoiner this_) {
        if (this_.mTXVideoEditer != null) {
            this_.mTXVideoEditer.pausePlay();
        }
    }

    static /* synthetic */ void lambda$startPlay$3(TXVideoJoiner this_) {
        this_.stopPlayInternal();
        this_.mTXVideoEditer = new TXVideoEditer(this_.mContext, this_.mSequenceTaskRunner);
        this_.mTXVideoEditer.setMediaSourcePaths(this_.mVideoSourceList);
        this_.mTXVideoEditer.initWithPreview(this_.mTxPreviewParam);
        if (this_.mTXVideoEditer.isHasAudio() && !c.a(this_.mSplitScreenRects)) {
            this_.mTXVideoEditer.setIsSplitScreen(true);
            this_.mTXVideoEditer.setSplitScreenList(this_.mSplitScreenRects, this_.mSplitScreenCanvasWidth, this_.mSplitScreenCanvasHeight);
            if (this_.mVideoVolumes != null) {
                this_.mTXVideoEditer.setVideoVolumes(this_.mVideoVolumes);
            }
        }
        this_.mTXVideoEditer.setTXVideoPreviewListener(this_.mTXEditerVideoPreviewListener);
        this_.mTXVideoEditer.startPlayFromTime(0L, this_.mTXVideoEditer.getDuration());
    }

    static /* synthetic */ void lambda$setTXVideoPreviewListener$2(TXVideoJoiner this_, TXVideoPreviewListener listener) {
        this_.mTXVideoPreviewListener = listener;
    }

    static /* synthetic */ void lambda$initWithPreview$1(TXVideoJoiner this_, TXVideoEditConstants.TXPreviewParam param) {
        this_.mTxPreviewParam = param;
        if (this_.mTXVideoEditer != null) {
            this_.mTXVideoEditer.initWithPreview(this_.mTxPreviewParam);
        }
    }

    static /* synthetic */ void lambda$setVideoPathList$0(TXVideoJoiner this_, List videoSourceList) {
        this_.mVideoSourceList = videoSourceList;
    }

    static /* synthetic */ void access$lambda$0(TXVideoJoiner tXVideoJoiner) {
        tXVideoJoiner.stopPlayInternal();
    }

    public static interface TXVideoPreviewListener {
        public void onPreviewProgress(int var1);

        public void onPreviewFinished();
    }

    public static interface TXVideoJoinerListener {
        public void onJoinProgress(float var1);

        public void onJoinComplete(TXVideoEditConstants.TXJoinerResult var1);
    }
}

