/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.text.TextUtils;
import android.util.Pair;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import io.rong.common.fwlog.LogSplitUtil;
import java.util.Arrays;
import java.util.List;

public class ReportUtil {
    public static final String PREFIX_APP = "A-";
    public static final String PREFIX_LIB = "L-";
    public static final String PREFIX_PROTOCOL = "P-";
    public static final String SUFFIX_OPERATE = "-O";
    public static final String SUFFIX_STATUS = "-S";
    public static final String SUFFIX_TASK = "-T";
    public static final String SUFFIX_RESULT = "-R";
    public static final String SUFFIX_ERROR = "-E";
    public static final String KEY_ROOMID = "roomId";
    public static final String KEY_CODE = "code";
    public static final int CODE_SUCCESS = 0;
    public static final String KEY_ROOMIDCODE = "roomId|code";

    public static void appTask(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_TASK, keys, values);
    }

    public static void appRes(TAG tag, String roomId) {
        ReportUtil.appRes(tag, KEY_ROOMIDCODE, roomId, 0);
    }

    public static void appRes(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_RESULT, keys, values);
    }

    public static void appError(TAG tag, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(code.getValue() + ""), (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void appError(TAG tag, int level, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.appError(tag, level, (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void appError(TAG tag, RTCErrorCode code) {
        ReportUtil.appError(tag, code.getValue(), code.getReason());
    }

    public static void appError(TAG tag, int level, RTCErrorCode code) {
        ReportUtil.appError(tag, level, code.getValue(), code.getReason());
    }

    public static void appError(TAG tag, int code, String desc) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(code + ""), "code|desc", code, desc);
    }

    public static void appError(TAG tag, int level, int code, String desc) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, level, "code|desc", code, desc);
    }

    public static void appError(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(values), keys, values);
    }

    public static void appError(TAG tag, boolean checkErrorCodeAndDegradeLevel, String keys, Object ... values) {
        if (!checkErrorCodeAndDegradeLevel) {
            ReportUtil.appError(tag, keys, values);
            return;
        }
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(values), keys, values);
    }

    private static int degradeLogLevel(Object ... values) {
        int level = 1;
        for (Object obj : values) {
            String errorCode;
            if (obj == null || !(errorCode = obj.toString()).equals(RTCErrorCode.RongRTCCodeHttpTimeoutError.getValue() + "") && !errorCode.equals(RTCErrorCode.RongRTCCodeHttpError.getValue() + "")) continue;
            level = 2;
            break;
        }
        return level;
    }

    public static void appError(TAG tag, int level, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, level, keys, values);
    }

    public static void appOperate(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_OPERATE, keys, values);
    }

    public static void appStatus(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_STATUS, keys, values);
    }

    public static void libTask(TAG tag) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_TASK, KEY_CODE, 0);
    }

    public static void libTask(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_TASK, keys, values);
    }

    public static void libRes(TAG tag) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_RESULT, KEY_CODE, 0);
    }

    public static void libRes(TAG tag, String roomId) {
        ReportUtil.libRes(tag, KEY_ROOMIDCODE, roomId, 0);
    }

    public static void libRes(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_RESULT, keys, values);
    }

    public static void libErrorW(TAG tag, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.libError(tag, 2, (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void libError(TAG tag, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.libError(tag, (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void libError(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_ERROR, keys, values);
    }

    public static void libError(TAG tag, int level, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_ERROR, level, keys, values);
    }

    public static void libError(TAG tag, boolean checkErrorCodeAndDegradeLevel, String keys, Object ... values) {
        if (!checkErrorCodeAndDegradeLevel) {
            ReportUtil.libError(tag, keys, values);
            return;
        }
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(values), keys, values);
    }

    public static void libStatus(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_STATUS, keys, values);
    }

    public static void report(String prefix, TAG tag, String suffix, String keys, Object ... values) {
        int level = 3;
        if (SUFFIX_ERROR.equals(suffix)) {
            level = 1;
        }
        ReportUtil.write(level, prefix + tag.tag + suffix, keys, values);
    }

    public static void report(String prefix, TAG tag, String suffix, int level, String keys, Object ... values) {
        ReportUtil.write(level, prefix + tag.tag + suffix, keys, values);
    }

    private static void write(int level, String tag, String keys, Object ... values) {
        if (values == null) {
            LogSplitUtil.write((int)level, (String)tag, (String)keys, (Object[])new Object[]{""});
        } else {
            LogSplitUtil.write((int)level, (String)tag, (String)keys, (Object[])values);
        }
    }

    private static Pair<String, Object[]> getCommonParams(RTCErrorCode code, String keys, Object ... values) {
        String tmpKeys = keys;
        tmpKeys = TextUtils.isEmpty((CharSequence)tmpKeys) ? "code|desc" : tmpKeys + (tmpKeys.endsWith("|") ? "code|desc" : "|code|desc");
        Object[] tmpValues = values != null ? Arrays.copyOf(values, values.length + 2) : new Object[2];
        tmpValues[tmpValues.length - 2] = code.getValue();
        tmpValues[tmpValues.length - 1] = code.getReason();
        return Pair.create((Object)tmpKeys, (Object)tmpValues);
    }

    public static String streamToString(List<? extends RCRTCStream> streams) {
        if (streams == null || streams.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (RCRTCStream rCRTCStream : streams) {
            sb.append(rCRTCStream.toString()).append(" , ");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static String resourceToString(List<? extends IStreamResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (IStreamResource iStreamResource : resources) {
            if (iStreamResource == null) continue;
            sb.append(iStreamResource.toString()).append(" , ");
        }
        if (sb.length() > 0) {
            return sb.toString().substring(0, sb.length() - 1);
        }
        return "";
    }

    public static enum TAG {
        JOINROOM("joinRoom"),
        JOINRTCROOMANDGETDATA("joinRTCRoomAndGetData"),
        VIEWERJOINROOM("viewerJoinRoom"),
        CHATROOMKVSYNC("ChatRoomKVSync"),
        HATROOMKVUPDATE("ChatRoomKVUpdate"),
        CHATROOMKVREMOVE("ChatRoomKVRemove"),
        VIEWERQUITROOM("viewerQuitRoom"),
        REJOINROOM("rejoinRoom"),
        RELEASEROOM("releaseRoom"),
        LEAVEROOM("leaveRoom"),
        LEAVELIVE("leaveLive"),
        CREATEOFFER("createOffer"),
        SETLOCALSDP("setLocalSDP"),
        CREATEANSWER("createAnswer"),
        SETREMOTESDP("setRemoteSDP"),
        PUBLISHAVSTREAM("publishAVStream"),
        PUBLISHLIVEAVSTREAM("publishLiveAVStream"),
        UNPUBLISHLIVEAVSTREAM("unpublishLiveAVStream"),
        SDPEXCHANGE("SDPExchange"),
        RTCPUTINNERDATA("RTCPutInnerData"),
        RTCPUTOUTERDATA("RTCPutOuterData"),
        ENGINESUBSCRIBESTREAMS("engineSubscribeStreams"),
        SUBSCRIBEAVSTREAM("subscribeAVStream"),
        SUBSCRIBELIVEURL("subscribeLiveUrl"),
        GETRTCTOKEN("getRtcToken"),
        ENGINESUBSCRIBELIVESTREAM("engineSubscribeLiveStream"),
        SUBSCRIBELIVESTREAM("subscribeLiveStream"),
        UNSUBSCRIBEAVSTREAM("unsubscribeAVStream"),
        UNSUBSCRIBELIVESTREAM("unsubscribeLiveStream"),
        UNPUBLISHAVSTREAM("unpublishAVStream"),
        SETMICROPHONEDISABLE("setMicrophoneDisable"),
        STARTCAPTURE("startCapture"),
        STOPCAPTURE("stopCapture"),
        SWITCHCAMERA("switchCamera"),
        USESPEAKER("useSpeaker"),
        CREATEHDVIDEODECODER("createHDVideoDecoder"),
        FIRSTDECODEDFRAME("firstDecodedFrame"),
        DECODER("decoder"),
        CREATEHDVIDEOENCODER("createHDVideoEncoder"),
        RTCCONFIG("RTCConfig"),
        RTCAUDIOCONFIG("RTCAudioConfig"),
        RTCVIDEOCONFIG("RTCVideoConfig"),
        RTCINIT("RTCInit"),
        RTCUNINIT("RTCUnInit"),
        CHANGEAUDIOSCENARIO("changeAudioScenario"),
        SETAUDIOQUALITY("setAudioQuality"),
        ONREMOTEUSERPUBLISHRESOURCE("onRemoteUserPublishResource"),
        ONREMOTEUSERUNPUBLISHRESOURCE("onRemoteUserUnpublishResource"),
        ONPUBLISHLIVERESOURCE("onPublishLiveStreams"),
        ONPUBLISHCDNSTREAM("onPublishCDNStream"),
        ONUNPUBLISHCDNSTREAM("onUnpublishCDNStream"),
        ONUNPUBLISHLIVERESOURCE("onUnpublishLiveStreams"),
        ONREMOTEUSERMODIFYRESOURCE("onRemoteUserModifyResource"),
        ONREMOTEUSERJOINED("onRemoteUserJoined"),
        ONREMOTEUSERLEFT("onRemoteUserLeft"),
        ONREMOTEUSEROFFLINE("onRemoteUserOffline"),
        ONADDTRACK("onAddTrack"),
        ONFIRSTFRAME("onFirstFrame"),
        ONFIRSTAUDIOFRAMERECEIVED("onFirstAudioFrameReceived"),
        ONRECORDCAPTUREEVENT("onRecordCaptureEvent"),
        AUDIORECORDMONITOR("audioRecordMonitor"),
        AUDIORECORDSTATUS("audioRecordStatus"),
        CAMERASTATUS("cameraStatus"),
        RECORDCALLBACKMANGERLOCKER("RecordCallBackMangerLocker"),
        PINGFAILED4TIMESLEAVEROOM("pingFailed4TimesLeaveRoom"),
        IMLOGOUT("IMLogout"),
        KICKEDBYOTHERCLIENT("kickedByOtherClient"),
        RESETICE("resetICE"),
        ONICECONNECTIONCHANGE("onICEConnectionChange"),
        ONREMOVEREMOTESTREAM("onRemoveRemoteStream"),
        SETMIXCONFIG("setMixConfig"),
        SETAUDIOQUALITYMIXCONFIG("setAudioQualityMixConfig"),
        SETMIXINPUTFILTERBYSTREAMS("setMixInputFilterByStreams"),
        SETMIXINPUTFILTERBYROOMIDS("setMixInputFilterByRoomIds"),
        MCUCONFIGREQUEST("mCUConfigRequest"),
        ADDPUBLISHSTREAMURL("addPublishStreamUrl"),
        REMOVEPUBLISHSTREAMURL("removePublishStreamUrl"),
        MONITORRECEIVESTAT("monitorReceiveStat"),
        MONITORLOSSSTAT("monitorLossStat"),
        MODIFYRESOURCE("modifyResource"),
        DIFFDATA("diffData"),
        DIFFSTREAM("diffStream"),
        RTCNAVIDATA("RTCNaviData"),
        MUTEALLREMOTEAUDIO("muteAllRemoteAudio"),
        KICKEDFROMSERVER("kickedFromServer"),
        SETROOMATTRIBUTEVALUE("setRoomAttributeValue"),
        DELETEROOMATTRIBUTE("deleteRoomAttribute"),
        PUT_INNER_DATA("putInnerData"),
        GETROOMATTRIBUTE("getRoomAttribute"),
        SETATTRIBUTEVALUE("setAttributeValue"),
        DELETEATTRIBUTE("deleteAttribute"),
        GETATTRIBUTE("getAttribute"),
        SETMEDIASERVERURL("setMediaServerUrl"),
        INITVIDEOVIEW("initVideoView"),
        BINDVIDEOVIEW("bindVideoView"),
        DESTROYVIDEOVIEW("destroyVideoView"),
        SETREMOTERENDERVIEW("setRemoteRenderView"),
        SETLOCALRENDERVIEW("setLocalRenderView"),
        CREATEVIDEOVIEW("createVideoView"),
        HTTP_REQUEST("httpRequest"),
        GETRTCUSERDATA("getRTCUserData"),
        REMOTEUSERTOTALCONTENTTAG("remoteUserTotalContent"),
        SENDEVENTMESSAGE("sendEventMessage"),
        UNHANDLEDMESSAGE("unhandledMessage"),
        TRANSITIONTOSTATE("transitionToState"),
        STATEMACHINE("stateMachine"),
        IMLOGIN("IMLogin"),
        PUBSUBQUEUEOFFER("PubSubQueueOffer"),
        PUBSUBQUEUECANCEL("PubSubQueueCancel"),
        PUBSUBQUEUEPOLL("PubSubQueuePoll"),
        RESUBSCRIBESTREAMS("resubscribeStreams"),
        SWITCHSTREAMTINYORNORMAL("switchStreamTinyOrNormal"),
        CREATEFILEVIDEOOUTSTREAM("createFileVideoOutStream"),
        EXCHANGEVIDEOSIZE("exchangeVideoSize"),
        RESOLUTIONCHANGED("resolutionChanged"),
        ENABLE_EAR_MONITOR("enableEarMonitor"),
        RECLAIM_EAR_MONITOR("reclaimEarMonitor"),
        OPENSLES_DEVICE_ERR("OpenSLESDeviceError"),
        JOINOTHERROOM("joinOtherRoom"),
        LEAVEOTHERROOM("leaveOtherRoom"),
        REQUESTJOINOTHERROOM("requestJoinOtherRoom"),
        RESPONSEJOINOTHERROOM("responseJoinOtherRoom"),
        FINISHOTHERROOM("finishOtherRoom"),
        CANCELREQUESTJOINOTHERROOM("cancelRequestJoinOtherRoom"),
        INVITETIMEOUT("inviteTimeout"),
        INVITE("invite"),
        ANSWER_INVITE("answerInvite"),
        CANCEL_INVITE("cancelInvite"),
        PINGFAILED4TIMESLEAVEOTHERROOM("pingFailed4TimesLeaveOtherRoom"),
        END_INVITE("endInvite"),
        INVALID_PROTOCOL("InvalidProtocol"),
        SIGNAL_NOTIFY_MSG("RtcNotifyMsg"),
        PULL_KV("PullKV"),
        UNSUB_CDN_STREAM("unSubCDNStream"),
        GET_CDN_URI("getCDNUri"),
        PLAYER_STATE("playerState"),
        PLAYER_MUTE("playerMute"),
        MCU_CONFIG("mcuConfig"),
        BROADCAST_CDN_SERVER("broadcastCDNServer"),
        ENABLE_INNER_CDN("enableInnerCDN"),
        CHANGE_CDN_VIDEO_SIZE("changeCDNVideoSize"),
        PLAYER_RECONNECT("playerReconnect"),
        SETWATERMARK("setWatermark"),
        INITWATERMARKENV("initWatermarkEnv"),
        REINITWATERMARKENV("reInitWatermarkEnv"),
        DESTROYWATERMARKENV("destroyWatermarkEnv"),
        HARDWARE_ENCODE("hardwareEncode"),
        HARDWARE_DECODE("hardwareDecode"),
        SOFT_ENCODE("softEncode"),
        SOFT_DECODE("softDecode"),
        ENCODER_SELECTED("encoderSelected"),
        DECODER_SELECTED("encoderSelected"),
        STARTMIX("startMix"),
        VIDEOVIEW_STATUS("VideoViewStatus"),
        SETMIXINGVOLUME("setMixingVolume"),
        SETPLAYBACKVOLUME("setPlaybackVolume"),
        SETPLAYBACK("setMixingPlayback"),
        SEEKTO("setMixingSeekTo"),
        STOPMIX("stopMix"),
        RESUMEMIX("resumeMix"),
        PAUSEMIX("pauseMix"),
        MIXLOOPCOUNT("setMixLoopCount"),
        MIXINGSTATECHANGED("mixingStateChanged"),
        MIXWRITE("mixWrite"),
        SETAUDIODUALMONOMODE("setAudioDualMonoMode"),
        INITSWICTHAUDIOCHANNEL("initSwitchAudioChannel"),
        DESTROYSWICTHAUDIOCHANNEL("destroySwitchAudioChannel"),
        FACE_BEAUTY_LOAD("face_bueaty_load"),
        FACE_BEAUTY_INIT("face_beauty_init"),
        FACE_BEAUTY_UNINIT("face_beauty_unInit"),
        FACE_BEAUTY_SUPPORT("face_beauty_support"),
        FACE_BEAUTY_SET_BEAUTY_OPTION("face_beauty_setBeautyOptions"),
        FACE_BEAUTY_SET_FILTER_INTENSITY("face_beauty_setFilterIntensity"),
        FACE_BEAUTY_SET_BEAUTY_FILTER("face_beauty_setBeautyFilter"),
        VOICE_BEAUTIFIER_LOAD("voice_beautifier_load"),
        VOICE_BEAUTIFIER_INIT("voice_beautifier_init"),
        VOICE_BEAUTIFIER_INIT_INTERNAL("voice_beautifier_init_internal"),
        VOICE_BEAUTIFIER_START("voice_beautifier_start"),
        VOICE_BEAUTIFIER_START_INTERNAL("voice_beautifier_start_internal"),
        VOICE_BEAUTIFIER_STOP("voice_beautifier_stop"),
        VOICE_BEAUTIFIER_UNINIT("voice_beautifier_uninit"),
        VOICE_BEAUTIFIER_ENBALE("voice_beautifier_enable"),
        VOICE_BEAUTIFIER_PROCESS("voice_beautifier_process"),
        VOICE_BEAUTIFIER_PRESET("voice_beautifier_preset"),
        VOICE_BEAUTIFIER_REPORT("voice_beautifier_report"),
        NETSTARTMIX("netstartMix"),
        NETSTOPMIX("netstopMix"),
        NETPAUSEMIX("netpauseMix"),
        NETRESUMEMIX("netresumeMix"),
        NETSEEKTO("netsetMixingSeekTo"),
        NETSETMIXINGVOLUME("netsetMixingVolume"),
        NETSETPLAYBACKVOLUME("netsetPlaybackVolume"),
        NETMIXINGSTATECHANGED("netmixingStateChanged"),
        NETPLAYERPLAY("netplayerplay"),
        NETPLAYERSTOP("netplayerstop"),
        NETPLAYERPAUSE("netplayerpause"),
        NETPLAYERRESUME("netplayerresume"),
        NETPLAYERSETVOLUME("netplayersetvolume"),
        NETPLAYERSEEK("netplayerseek"),
        NETPLAYREPORTPROGRESS("netplayreportprogress"),
        FFMPEGAUDIOMIXINIT("ffmpegAudioMixInit"),
        FFMPEGAUDIOMIXDATAINVALID("ffmpegAudioMixDataInvalid"),
        FFMPEGAUDIOMIXUNINIT("ffmpegAudioMixUninit"),
        SOUND_EFFECT_INIT("sound_effect_int"),
        SOUND_EFFECT_PROCESS("sound_effect_process"),
        SOUND_EFFECT_PITCH("sound_effect_pitch"),
        SOUND_EFFECT_TEMPO("sound_effect_tempo"),
        SOUND_EFFECT_RATE("sound_effect_rate"),
        SOUND_EFFECT_RELEASE("sound_effect_release"),
        AUDIO_ROUTE("audioroute"),
        AUDIO_DEVICE_STATUS("audioDeviceStatus"),
        AUDIO_ROUTE_TYPE("audioRouteType"),
        AUDIO_ROUTE_RESET("audioRouteReset"),
        AUDIO_ROUTE_STATE("audioRouteState"),
        AUDIO_ROUTE_HEADSET_CHANGE("audioRouteHeadsetChange"),
        AUDIO_ROUTE_BT_CHANGE("audioRouteBTChange"),
        UNLOADALLEFFECTS("unloadAllEffects"),
        UNLOADEFFECT("unloadEffect"),
        EFFECTFINISHED("effectFinished"),
        PRELOADEFFECT("preloadEffect"),
        PLAYEFFECT("playEffect"),
        PAUSEEFFECT("pauseEffect"),
        PAUSEALLEFFECTS("pauseAllEffects"),
        RESUMEEFFECT("resumeEffect"),
        RESUMEALLEFFECTS("resumeAllEffects"),
        STOPEFFECT("stopEffect"),
        STOPALLEFFECTS("stopAllEffects"),
        SETEFFECTSVOLUME("setEffectsVolume"),
        SETEFFECTVOLUMEBYID("setEffectVolumeById"),
        SET_STREAM_MUTE("setStreamMute"),
        SETCAMERAPREVIEWMIRROR("setCameraPreviewMirror"),
        SETVIDEOVIEW("setVideoView"),
        SETTRACK("setTrack"),
        UNBINDINGSINK("unbindingSink"),
        CREATEEGLFAILED("CreateEglFailed"),
        GLAPIERROR("glapierror"),
        SETVIDEOCONFIG("setVideoConfig"),
        SETCAMERADISPLAYORIENTATION("setCameraDisplayOrientation"),
        SETFRAMEORIENTATION("setFrameOrientation"),
        ENABLETINYSTREAM("enableTinyStream"),
        SETTINYVIDEOCONFIG("setTinyVideoConfig"),
        SETCAMERAEXPOSUREPOSITIONINPREVIEW("setCameraExposurePositionInPreview"),
        SETCAMERAFOCUSPOSITIONINPREVIEW("setCameraFocusPositionInPreview"),
        ADJUSTRECORDINGVOLUME("adjustRecordingVolume"),
        SETCAMERAPARAMS("setCameraParams"),
        CAMERARUNNABLE("cameraRunnable"),
        START_SCREEN_CAPTURE("startScreenCapture"),
        STOP_SCREEN_CAPTURE("stopScreenCapture"),
        SCREEN_CAPTURE_CONFIG("screenCaptureConfig"),
        START_SCREEN_CAPTURE_ACTIVITY("startScreenCaptureActivity"),
        STOP_SCREEN_CAPTURE_ACTIVITY("stopScreenCaptureActivity"),
        RELEASERTCENGINE("ReleaseRTCEngine"),
        SWITCH_TO_AUDIENCE("switchToAudience"),
        SWITCH_TO_BROADCASTER("switchToBroadcaster"),
        SWITCH_ROLE("onSwitchRole"),
        RESETAUDIOINPUT("resetAudioInput"),
        CHANGEAUDIOINPUT("changeAudioInput"),
        AUDIOINPUTSTATUS("audioinputStatus"),
        MCU_CLIENT_ACTION("mcuClientAction"),
        QUERY_JOINED_ROOM("QueryJoinedRoom"),
        START_AUDIO_CAPTURE("startAudioCapture"),
        STOP_AUDIO_CAPTURE("stopAudioCapture"),
        EARPHONE_ENABLE("earphone_enable"),
        EARPHONE_MUSIC_MODE("earphone_music_mode"),
        EARPHONE_AUDIO_SOURCE("earphone_audio_source"),
        MEMORYHELPER("memoryhelper"),
        STARTPROBEFORENGINE("startProbeForEngine"),
        GETPROBERTCTOKEN("getProbeRTCToken"),
        STARTPROBEFORIMPL("startProbeForImpl"),
        STARTPROBEMEDIASERVER("startProbeForMediaServer"),
        STOPPROBEMEDIASERVER("stopProbeForMediaServer"),
        STOPPROBEFORIMPL("stopProbeForImpl"),
        STOPPROBEFORENGINE("stopProbeForEngine"),
        START_STATE_MACHINE("start_state_machine"),
        TIMERHEARTBEAT("TimerHeartBeat");

        private String tag;

        private TAG(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

