/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.uniapp.ui.shadow;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;

public class UniInsetBoxShadowDrawable
extends Drawable {
    private static final int LEFT_TO_RIGHT = 0;
    private static final int TOP_TO_BOTTOM = 1;
    private static final int RIGHT_TO_LEFT = 2;
    private static final int BOTTOM_TO_TOP = 3;
    private float blurRadius;
    private int shadowColor;
    private float[] radii;
    private float width;
    private float height;
    private float shadowXSize;
    private float shadowYSize;
    private Shader[] shades = new Shader[4];
    private Path[] paths = new Path[4];
    private Paint paint;

    public UniInsetBoxShadowDrawable(int viewWidth, int viewHeight, float dx, float dy, float blurRadius, float spread, int shadowColor, float[] radii) {
        this.blurRadius = blurRadius;
        this.shadowColor = shadowColor;
        this.width = (float)viewWidth + 2.0f * dx;
        this.height = (float)viewHeight + 2.0f * dy;
        this.shadowXSize = dx + spread;
        this.shadowYSize = dy + spread;
        this.radii = radii;
        this.setBounds(0, 0, viewWidth, viewHeight);
        this.prepare();
    }

    private void prepare() {
        PointF a = new PointF(0.0f, 0.0f);
        PointF b = new PointF(this.width, 0.0f);
        PointF c = new PointF(b.x, this.height);
        PointF d = new PointF(a.x, c.y);
        PointF e = new PointF(this.shadowXSize, this.shadowYSize);
        PointF f = new PointF(b.x - this.shadowXSize, e.y);
        PointF g = new PointF(f.x, c.y - this.shadowYSize);
        PointF h = new PointF(e.x, g.y);
        LinearGradient ltr = new LinearGradient(e.x - this.blurRadius, e.y, e.x, e.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
        LinearGradient ttb = new LinearGradient(e.x, e.y - this.blurRadius, e.x, e.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
        LinearGradient rtl = new LinearGradient(g.x + this.blurRadius, g.y, g.x, g.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
        LinearGradient btt = new LinearGradient(g.x, g.y + this.blurRadius, g.x, g.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
        this.shades[0] = ltr;
        this.shades[1] = ttb;
        this.shades[2] = rtl;
        this.shades[3] = btt;
        Path ltrPath = new Path();
        ltrPath.moveTo(a.x, a.y);
        ltrPath.lineTo(e.x, e.y);
        ltrPath.lineTo(h.x, h.y);
        ltrPath.lineTo(d.x, d.y);
        ltrPath.close();
        Path ttbPath = new Path();
        ttbPath.moveTo(a.x, a.y);
        ttbPath.lineTo(b.x, b.y);
        ttbPath.lineTo(f.x, f.y);
        ttbPath.lineTo(e.x, e.y);
        ttbPath.close();
        Path rtlPath = new Path();
        rtlPath.moveTo(b.x, b.y);
        rtlPath.lineTo(c.x, c.y);
        rtlPath.lineTo(g.x, g.y);
        rtlPath.lineTo(f.x, f.y);
        rtlPath.close();
        Path bttPath = new Path();
        bttPath.moveTo(d.x, d.y);
        bttPath.lineTo(c.x, c.y);
        bttPath.lineTo(g.x, g.y);
        bttPath.lineTo(h.x, h.y);
        bttPath.close();
        this.paths[0] = ltrPath;
        this.paths[1] = ttbPath;
        this.paths[2] = rtlPath;
        this.paths[3] = bttPath;
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.shadowColor);
    }

    public void draw(Canvas canvas) {
        Rect bounds = canvas.getClipBounds();
        Path border = new Path();
        RectF rectF = new RectF(bounds);
        border.addRoundRect(rectF, this.radii, Path.Direction.CCW);
        canvas.clipPath(border);
        canvas.translate((float)bounds.left, (float)bounds.top);
        for (int i = 0; i < 4; ++i) {
            Shader shader = this.shades[i];
            Path path = this.paths[i];
            this.paint.setShader(shader);
            canvas.drawPath(path, this.paint);
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -1;
    }
}

