/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.extend;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.ViewPager;
import com.taobao.weex.ui.view.WXCircleViewPager;

public class DCWXCircleViewPager
extends WXCircleViewPager {
    private boolean isVertical = false;
    private int pointCounr = 0;

    public DCWXCircleViewPager(Context context) {
        super(context);
    }

    public DCWXCircleViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    private MotionEvent swapTouchEvent(MotionEvent event) {
        float width = this.getWidth();
        float height = this.getHeight();
        float swappedX = event.getY() / height * width;
        float swappedY = event.getX() / width * height;
        event.setLocation(swappedX, swappedY);
        return event;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void setVertical(boolean vertical) {
        this.isVertical = vertical;
        if (this.isVertical) {
            this.setPageTransformer(false, new ViewPager.PageTransformer(){

                public void transformPage(View view, float position) {
                    view.setTranslationX((float)view.getWidth() * -position);
                    float yPosition = position * (float)view.getHeight();
                    view.setTranslationY(yPosition);
                }
            });
        } else {
            this.setPageTransformer(false, null);
        }
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        try {
            if (this.isVertical) {
                boolean intercept = super.onInterceptTouchEvent(this.swapTouchEvent(event));
                this.swapTouchEvent(event);
                return intercept;
            }
            return super.onInterceptTouchEvent(event);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return super.onInterceptTouchEvent(event);
    }

    public int getPointCounr() {
        return this.pointCounr;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.pointCounr = ev.getPointerCount();
                break;
            }
            case 1: 
            case 3: {
                this.pointCounr = 0;
            }
        }
        if (this.isVertical) {
            ViewGroup viewGroup = (ViewGroup)this.getParent();
            switch (ev.getAction()) {
                case 2: {
                    viewGroup.requestDisallowInterceptTouchEvent(true);
                    break;
                }
                case 1: 
                case 3: {
                    viewGroup.requestDisallowInterceptTouchEvent(false);
                }
            }
            return super.onTouchEvent(this.swapTouchEvent(ev));
        }
        return super.onTouchEvent(ev);
    }
}

