/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.message;

import android.os.Parcel;
import com.liulishuo.filedownloader.message.IFlowDirectly;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import java.io.Serializable;

public abstract class LargeMessageSnapshot
extends MessageSnapshot {
    LargeMessageSnapshot(int id) {
        super(id);
        this.isLargeFile = true;
    }

    LargeMessageSnapshot(Parcel in) {
        super(in);
    }

    @Override
    public int getSmallSofarBytes() {
        if (this.getLargeSofarBytes() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.getLargeSofarBytes();
    }

    @Override
    public int getSmallTotalBytes() {
        if (this.getLargeTotalBytes() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.getLargeTotalBytes();
    }

    public static class PausedSnapshot
    extends PendingMessageSnapshot {
        PausedSnapshot(int id, long sofarBytes, long totalBytes) {
            super(id, sofarBytes, totalBytes);
        }

        @Override
        public byte getStatus() {
            return -2;
        }
    }

    public static class WarnMessageSnapshot
    extends PendingMessageSnapshot
    implements MessageSnapshot.IWarnMessageSnapshot {
        WarnMessageSnapshot(int id, long sofarBytes, long totalBytes) {
            super(id, sofarBytes, totalBytes);
        }

        WarnMessageSnapshot(Parcel in) {
            super(in);
        }

        @Override
        public MessageSnapshot turnToPending() {
            return new PendingMessageSnapshot(this);
        }

        @Override
        public byte getStatus() {
            return -4;
        }
    }

    public static class WarnFlowDirectlySnapshot
    extends WarnMessageSnapshot
    implements IFlowDirectly {
        WarnFlowDirectlySnapshot(int id, long sofarBytes, long totalBytes) {
            super(id, sofarBytes, totalBytes);
        }

        WarnFlowDirectlySnapshot(Parcel in) {
            super(in);
        }
    }

    public static class RetryMessageSnapshot
    extends ErrorMessageSnapshot {
        private final int retryingTimes;

        RetryMessageSnapshot(int id, long sofarBytes, Throwable throwable, int retryingTimes) {
            super(id, sofarBytes, throwable);
            this.retryingTimes = retryingTimes;
        }

        @Override
        public int getRetryingTimes() {
            return this.retryingTimes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.retryingTimes);
        }

        RetryMessageSnapshot(Parcel in) {
            super(in);
            this.retryingTimes = in.readInt();
        }

        @Override
        public byte getStatus() {
            return 5;
        }
    }

    public static class ErrorMessageSnapshot
    extends LargeMessageSnapshot {
        private final long sofarBytes;
        private final Throwable throwable;

        ErrorMessageSnapshot(int id, long sofarBytes, Throwable throwable) {
            super(id);
            this.sofarBytes = sofarBytes;
            this.throwable = throwable;
        }

        @Override
        public long getLargeSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public byte getStatus() {
            return -1;
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeLong(this.sofarBytes);
            dest.writeSerializable((Serializable)this.throwable);
        }

        ErrorMessageSnapshot(Parcel in) {
            super(in);
            this.sofarBytes = in.readLong();
            this.throwable = (Throwable)in.readSerializable();
        }
    }

    public static class CompletedSnapshot
    extends LargeMessageSnapshot {
        private final boolean reusedDownloadedFile;
        private final long totalBytes;

        CompletedSnapshot(int id, boolean reusedDownloadedFile, long totalBytes) {
            super(id);
            this.reusedDownloadedFile = reusedDownloadedFile;
            this.totalBytes = totalBytes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte(this.reusedDownloadedFile ? (byte)1 : 0);
            dest.writeLong(this.totalBytes);
        }

        CompletedSnapshot(Parcel in) {
            super(in);
            this.reusedDownloadedFile = in.readByte() != 0;
            this.totalBytes = in.readLong();
        }

        @Override
        public byte getStatus() {
            return -3;
        }

        @Override
        public long getLargeTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public boolean isReusedDownloadedFile() {
            return this.reusedDownloadedFile;
        }
    }

    public static class CompletedFlowDirectlySnapshot
    extends CompletedSnapshot
    implements IFlowDirectly {
        CompletedFlowDirectlySnapshot(int id, boolean reusedDownloadedFile, long totalBytes) {
            super(id, reusedDownloadedFile, totalBytes);
        }

        CompletedFlowDirectlySnapshot(Parcel in) {
            super(in);
        }
    }

    public static class ProgressMessageSnapshot
    extends LargeMessageSnapshot {
        private final long sofarBytes;

        ProgressMessageSnapshot(int id, long sofarBytes) {
            super(id);
            this.sofarBytes = sofarBytes;
        }

        @Override
        public byte getStatus() {
            return 3;
        }

        @Override
        public long getLargeSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeLong(this.sofarBytes);
        }

        ProgressMessageSnapshot(Parcel in) {
            super(in);
            this.sofarBytes = in.readLong();
        }
    }

    public static class ConnectedMessageSnapshot
    extends LargeMessageSnapshot {
        private final boolean resuming;
        private final long totalBytes;
        private final String etag;
        private final String fileName;

        ConnectedMessageSnapshot(int id, boolean resuming, long totalBytes, String etag, String fileName) {
            super(id);
            this.resuming = resuming;
            this.totalBytes = totalBytes;
            this.etag = etag;
            this.fileName = fileName;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte(this.resuming ? (byte)1 : 0);
            dest.writeLong(this.totalBytes);
            dest.writeString(this.etag);
            dest.writeString(this.fileName);
        }

        ConnectedMessageSnapshot(Parcel in) {
            super(in);
            this.resuming = in.readByte() != 0;
            this.totalBytes = in.readLong();
            this.etag = in.readString();
            this.fileName = in.readString();
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public byte getStatus() {
            return 2;
        }

        @Override
        public boolean isResuming() {
            return this.resuming;
        }

        @Override
        public long getLargeTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public String getEtag() {
            return this.etag;
        }
    }

    public static class PendingMessageSnapshot
    extends LargeMessageSnapshot {
        private final long sofarBytes;
        private final long totalBytes;

        PendingMessageSnapshot(PendingMessageSnapshot snapshot) {
            this(snapshot.getId(), snapshot.getLargeSofarBytes(), snapshot.getLargeTotalBytes());
        }

        PendingMessageSnapshot(int id, long sofarBytes, long totalBytes) {
            super(id);
            this.sofarBytes = sofarBytes;
            this.totalBytes = totalBytes;
        }

        @Override
        public byte getStatus() {
            return 1;
        }

        @Override
        public long getLargeSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public long getLargeTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeLong(this.sofarBytes);
            dest.writeLong(this.totalBytes);
        }

        PendingMessageSnapshot(Parcel in) {
            super(in);
            this.sofarBytes = in.readLong();
            this.totalBytes = in.readLong();
        }
    }
}

